/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.jij;

import gg.essential.loader.stage2.data.FabricModJson;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyntheticModJar
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern INNER_JAR_NAME_PATTERN = Pattern.compile("(?<id>.+)@(?<version>.+)\\.jar");
    private static final String INNER_JAR_NAME_FORMAT = "%s@%s.jar";
    private final Path outerPath;
    private final FileSystem fileSystem;
    private final String modId;
    private final String modName;

    public SyntheticModJar(Path path, String modId, String modName) throws IOException {
        this.outerPath = path;
        this.fileSystem = FileSystems.newFileSystem(path, (ClassLoader)null);
        this.modId = modId;
        this.modName = modName;
    }

    private Path jarsFolder() throws IOException {
        return Files.createDirectories(this.fileSystem.getPath("META-INF", "jars"), new FileAttribute[0]);
    }

    public List<InnerJar> getInnerJars() throws IOException {
        try (Stream<Path> stream = Files.list(this.jarsFolder());){
            List<InnerJar> list = stream.map(path -> {
                Matcher matcher = INNER_JAR_NAME_PATTERN.matcher(path.getFileName().toString());
                if (matcher.matches()) {
                    String id = matcher.group("id");
                    String versionStr = matcher.group("version");
                    return new InnerJar(id, versionStr);
                }
                LOGGER.error("Invalid inner jar name \"{}\" in \"{}\"", path, (Object)this.outerPath);
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return list;
        }
    }

    public void addInnerJar(Path source) throws IOException {
        FabricModJson modJson = FabricModJson.readFromJar(source);
        String fileName = String.format(INNER_JAR_NAME_FORMAT, modJson.getId(), modJson.getVersion());
        Path innerPath = this.jarsFolder().resolve(fileName);
        Files.copy(source, innerPath, StandardCopyOption.REPLACE_EXISTING);
    }

    public void removeInnerJar(InnerJar innerJar) throws IOException {
        String fileName = String.format(INNER_JAR_NAME_FORMAT, innerJar.getId(), innerJar.getVersion());
        Path innerPath = this.jarsFolder().resolve(fileName);
        Files.delete(innerPath);
    }

    private void writeModJson() throws IOException {
        List<FabricModJson.Jar> jars;
        try (Stream<Path> stream = Files.list(this.jarsFolder());){
            jars = stream.map(it -> it.toAbsolutePath().toString().substring(1)).map(FabricModJson.Jar::new).collect(Collectors.toList());
        }
        Map<String, FabricModJson.VersionRange> depends = this.getInnerJars().stream().collect(Collectors.toMap(InnerJar::getId, it -> new FabricModJson.VersionRange(">=" + it.getVersion())));
        FabricModJson json = new FabricModJson(1, this.modId, "0", this.modName, depends, jars);
        FabricModJson.write(this.fileSystem.getPath("fabric.mod.json", new String[0]), json);
    }

    @Override
    public void close() throws IOException {
        try {
            this.writeModJson();
        }
        finally {
            this.fileSystem.close();
        }
    }

    public static class InnerJar {
        private final String id;
        private final String version;

        public InnerJar(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return this.id + "@" + this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerJar that = (InnerJar)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version);
        }
    }
}

