/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import snownee.jade.util.CommonProxy;

public class JadeFluidObject {
    public static final Codec<JadeFluidObject> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41173.method_40294().fieldOf("type").forGetter(JadeFluidObject::getType), (App)Codec.LONG.fieldOf("amount").forGetter(JadeFluidObject::getAmount), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(JadeFluidObject::getComponents)).apply((Applicative)instance, JadeFluidObject::new));
    public static final class_9139<class_9129, JadeFluidObject> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56383((class_5321)class_7924.field_41270), JadeFluidObject::getType, (class_9139)class_9135.field_54505, JadeFluidObject::getAmount, (class_9139)class_9326.field_49590, JadeFluidObject::getComponents, JadeFluidObject::new);
    private final class_6880<class_3611> type;
    private final long amount;
    private final class_9326 components;

    public static long bucketVolume() {
        return CommonProxy.bucketVolume();
    }

    public static long blockVolume() {
        return CommonProxy.blockVolume();
    }

    public static JadeFluidObject empty() {
        return JadeFluidObject.of(class_3612.field_15906, 0L);
    }

    public static JadeFluidObject of(class_3611 fluid) {
        return JadeFluidObject.of(fluid, JadeFluidObject.blockVolume());
    }

    public static JadeFluidObject of(class_3611 fluid, long amount) {
        return JadeFluidObject.of(fluid, amount, class_9326.field_49588);
    }

    public static JadeFluidObject of(class_3611 fluid, long amount, class_9326 components) {
        return new JadeFluidObject((class_6880<class_3611>)fluid.method_40178(), amount, components);
    }

    private JadeFluidObject(class_6880<class_3611> type, long amount, class_9326 components) {
        this.type = type;
        this.amount = amount;
        this.components = components;
        Objects.requireNonNull(type);
        Objects.requireNonNull(components);
    }

    public class_6880<class_3611> getType() {
        return this.type;
    }

    public long getAmount() {
        return this.amount;
    }

    public class_9326 getComponents() {
        return this.components;
    }

    public boolean isEmpty() {
        return this.getType() == class_3612.field_15906 || this.getAmount() == 0L;
    }

    public class_2561 getDisplayName() {
        return CommonProxy.getFluidName(this);
    }

    public static boolean isSameFluidSameComponents(JadeFluidObject first, JadeFluidObject second) {
        if (first.type != second.type) {
            return false;
        }
        return first.isEmpty() && second.isEmpty() || Objects.equals(first.components, second.components);
    }
}

