/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.gui;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UICircle;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.ColorConstraint;
import gg.essential.elementa.constraints.RadiusConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.effects.ScissorEffect;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgg/essential/vigilance/gui/ExpandingClickEffect;", "Lgg/essential/elementa/effects/Effect;", "color", "Ljava/awt/Color;", "animationTime", "", "scissorBoundingBox", "Lgg/essential/elementa/UIComponent;", "(Ljava/awt/Color;FLgg/essential/elementa/UIComponent;)V", "circle", "Lgg/essential/elementa/components/UICircle;", "lastClick", "Lgg/essential/elementa/events/UIClickEvent;", "radiusDelta", "scissorEffect", "Lgg/essential/elementa/effects/ScissorEffect;", "state", "Lgg/essential/vigilance/gui/ExpandingClickEffect$State;", "targetRadius", "animationFrame", "", "beforeDraw", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "setup", "Companion", "State", "Vigilance"})
@SourceDebugExtension(value={"SMAP\nExpandingClickEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpandingClickEffect.kt\ngg/essential/vigilance/gui/ExpandingClickEffect\n+ 2 Extensions.kt\ngg/essential/vigilance/utils/ExtensionsKt\n+ 3 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n*L\n1#1,120:1\n22#2,5:121\n22#2,5:126\n9#3,3:131\n*S KotlinDebug\n*F\n+ 1 ExpandingClickEffect.kt\ngg/essential/vigilance/gui/ExpandingClickEffect\n*L\n71#1:121,5\n73#1:126,5\n63#1:131,3\n*E\n"})
public final class ExpandingClickEffect
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Color color;
    private final float animationTime;
    @Nullable
    private final UIComponent scissorBoundingBox;
    @NotNull
    private State state;
    private float targetRadius;
    private float radiusDelta;
    private ScissorEffect scissorEffect;
    private UIClickEvent lastClick;
    @NotNull
    private UICircle circle;

    @JvmOverloads
    public ExpandingClickEffect(@NotNull Color color, float animationTime, @Nullable UIComponent scissorBoundingBox) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.color = color;
        this.animationTime = animationTime;
        this.scissorBoundingBox = scissorBoundingBox;
        this.state = State.NotActive;
        this.targetRadius = -1.0f;
        this.radiusDelta = -1.0f;
        this.circle = new UICircle(0.0f, this.color, 0, 5, null);
    }

    public /* synthetic */ ExpandingClickEffect(Color color, float f, UIComponent uIComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.2f;
        }
        if ((n & 4) != 0) {
            uIComponent = null;
        }
        this(color, f, uIComponent);
    }

    public void setup() {
        UIComponent uIComponent = this.scissorBoundingBox;
        if (uIComponent == null) {
            uIComponent = this.getBoundComponent();
        }
        this.scissorEffect = new ScissorEffect(uIComponent, false, 2, null);
        UIComponent uIComponent2 = (UIComponent)this.circle;
        ScissorEffect scissorEffect = this.scissorEffect;
        if (scissorEffect == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scissorEffect");
            scissorEffect = null;
        }
        ComponentsKt.effect((UIComponent)uIComponent2, (Effect)((Effect)scissorEffect));
        Window.Companion.enqueueRenderOperation((Function0)new Function0<Unit>(this){
            final /* synthetic */ ExpandingClickEffect this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ComponentsKt.childOf((UIComponent)((UIComponent)ExpandingClickEffect.access$getCircle$p(this.this$0)), (UIComponent)((UIComponent)Window.Companion.of(ExpandingClickEffect.access$getBoundComponent(this.this$0))));
                ExpandingClickEffect.access$getCircle$p(this.this$0).hide(true);
            }
        });
        UIComponent $this$onLeftClick$iv = this.getBoundComponent();
        boolean $i$f$onLeftClick = false;
        $this$onLeftClick$iv.onMouseClick((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ ExpandingClickEffect this$0;
            {
                this.this$0 = expandingClickEffect;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getMouseButton() == 0) {
                    void it2;
                    UIClickEvent uIClickEvent = it;
                    UIComponent $this$setup_u24lambda_u241 = $this$onMouseClick;
                    boolean bl = false;
                    ExpandingClickEffect.access$setup$onClickHandler(this.this$0, (UIClickEvent)it2);
                }
            }
        });
        $this$onLeftClick$iv = (UIComponent)this.circle;
        $i$f$onLeftClick = false;
        $this$onLeftClick$iv.onMouseClick((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ ExpandingClickEffect this$0;
            {
                this.this$0 = expandingClickEffect;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getMouseButton() == 0) {
                    void it2;
                    UIClickEvent uIClickEvent = it;
                    UIComponent $this$setup_u24lambda_u242 = $this$onMouseClick;
                    boolean bl = false;
                    ExpandingClickEffect.access$setup$onClickHandler(this.this$0, (UIClickEvent)it2);
                }
            }
        });
    }

    public void animationFrame() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                float newRadius = this.circle.getRadius() + this.radiusDelta;
                if (newRadius >= this.targetRadius) {
                    this.state = State.Expanded;
                    break;
                }
                this.circle.setRadius((RadiusConstraint)UtilitiesKt.getPixels((Number)Float.valueOf(newRadius)));
                break;
            }
            case 3: {
                Color currentColor = this.circle.getColor();
                int alpha = currentColor.getAlpha() - 2;
                if (alpha <= 0) {
                    this.state = State.NotActive;
                    this.targetRadius = -1.0f;
                    this.radiusDelta = -1.0f;
                    this.circle.hide(true);
                    break;
                }
                this.circle.setColor((ColorConstraint)UtilitiesKt.toConstraint((Color)ExtensionsKt.withAlpha((Color)currentColor, (int)alpha)));
            }
        }
    }

    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        if (this.state != State.NotActive) {
            this.circle.draw(matrixStack);
        }
    }

    @JvmOverloads
    public ExpandingClickEffect(@NotNull Color color, float animationTime) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this(color, animationTime, null, 4, null);
    }

    @JvmOverloads
    public ExpandingClickEffect(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this(color, 0.0f, null, 6, null);
    }

    private static final void setup$onClickHandler(ExpandingClickEffect this$0, UIClickEvent clickEvent) {
        UIComponent uIComponent;
        this$0.lastClick = clickEvent;
        UIComponent.unhide$default((UIComponent)((UIComponent)this$0.circle), (boolean)false, (int)1, null);
        this$0.state = State.Expanding;
        float left = this$0.getBoundComponent().getLeft();
        float top = this$0.getBoundComponent().getTop();
        float right = this$0.getBoundComponent().getRight();
        float bottom = this$0.getBoundComponent().getBottom();
        Pair center = TuplesKt.to((Object)Float.valueOf(clickEvent.getAbsoluteX()), (Object)Float.valueOf(clickEvent.getAbsoluteY()));
        this$0.targetRadius = Math.max(Math.max(ExpandingClickEffect.Companion.distance((Pair<Float, Float>)center, (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(left), (Object)Float.valueOf(top))), ExpandingClickEffect.Companion.distance((Pair<Float, Float>)center, (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(left), (Object)Float.valueOf(bottom)))), Math.max(ExpandingClickEffect.Companion.distance((Pair<Float, Float>)center, (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(right), (Object)Float.valueOf(top))), ExpandingClickEffect.Companion.distance((Pair<Float, Float>)center, (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(right), (Object)Float.valueOf(bottom))))) + 2.0f;
        this$0.radiusDelta = this$0.targetRadius / this$0.animationTime / (float)Window.Companion.of(this$0.getBoundComponent()).getAnimationFPS();
        UIComponent $this$constrain$iv = (UIComponent)this$0.circle;
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        boolean bl = false;
        UIConstraints $this$setup_u24onClickHandler_u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
        boolean bl2 = false;
        $this$setup_u24onClickHandler_u24lambda_u240.setX((XConstraint)UtilitiesKt.getPixels((Number)Float.valueOf(clickEvent.getAbsoluteX())));
        $this$setup_u24onClickHandler_u24lambda_u240.setY((YConstraint)UtilitiesKt.getPixels((Number)Float.valueOf(clickEvent.getAbsoluteY())));
        $this$setup_u24onClickHandler_u24lambda_u240.setColor((ColorConstraint)UtilitiesKt.toConstraint((Color)this$0.color));
        $this$setup_u24onClickHandler_u24lambda_u240.setRadius((RadiusConstraint)UtilitiesKt.getPixels((Number)0));
    }

    public static final /* synthetic */ UICircle access$getCircle$p(ExpandingClickEffect $this) {
        return $this.circle;
    }

    public static final /* synthetic */ UIComponent access$getBoundComponent(ExpandingClickEffect $this) {
        return $this.getBoundComponent();
    }

    public static final /* synthetic */ void access$setup$onClickHandler(ExpandingClickEffect this$0, UIClickEvent clickEvent) {
        ExpandingClickEffect.setup$onClickHandler(this$0, clickEvent);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u00a8\u0006\b"}, d2={"Lgg/essential/vigilance/gui/ExpandingClickEffect$Companion;", "", "()V", "distance", "", "p1", "Lkotlin/Pair;", "p2", "Vigilance"})
    public static final class Companion {
        private Companion() {
        }

        private final float distance(Pair<Float, Float> p1, Pair<Float, Float> p2) {
            return (float)Math.sqrt((float)Math.pow(((Number)p1.getFirst()).floatValue() - ((Number)p2.getFirst()).floatValue(), 2.0f) + (float)Math.pow(((Number)p1.getSecond()).floatValue() - ((Number)p2.getSecond()).floatValue(), 2.0f));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lgg/essential/vigilance/gui/ExpandingClickEffect$State;", "", "(Ljava/lang/String;I)V", "NotActive", "Expanding", "Expanded", "Vigilance"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NotActive = new State();
        public static final /* enum */ State Expanding = new State();
        public static final /* enum */ State Expanded = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.NotActive, State.Expanding, State.Expanded};
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.NotActive.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Expanding.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Expanded.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

