/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.restrictions;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_3542;

public abstract class UsageRestriction<TYPE> {
    protected ListType type = ListType.NONE;
    protected final HashSet<TYPE> blackList = new HashSet();
    protected final HashSet<TYPE> whiteList = new HashSet();

    public void setListType(ListType type) {
        this.type = type;
    }

    public ListType getListType() {
        return this.type;
    }

    public void setListContents(List<String> namesBlacklist, List<String> namesWhitelist) {
        this.setValuesForList(ListType.BLACKLIST, namesBlacklist);
        this.setValuesForList(ListType.WHITELIST, namesWhitelist);
    }

    public Set<TYPE> getListForType(ListType type) {
        return type == ListType.WHITELIST ? this.whiteList : this.blackList;
    }

    public void setValuesForList(ListType type, List<String> names) {
        Set<TYPE> set = this.getListForType(type);
        set.clear();
        this.setValuesForList(set, names);
    }

    protected abstract void setValuesForList(Set<TYPE> var1, List<String> var2);

    public boolean isAllowed(TYPE value) {
        if (this.type == ListType.BLACKLIST) {
            return !this.blackList.contains(value);
        }
        if (this.type == ListType.WHITELIST) {
            return this.whiteList.contains(value);
        }
        return true;
    }

    public static enum ListType implements IConfigOptionListEntry,
    class_3542
    {
        NONE("none", "malilib.label.list_type.none"),
        BLACKLIST("blacklist", "malilib.label.list_type.blacklist"),
        WHITELIST("whitelist", "malilib.label.list_type.whitelist");

        public static final class_3542.class_7292<ListType> CODEC;
        public static final ImmutableList<ListType> VALUES;
        private final String configString;
        private final String translationKey;

        private ListType(String configString, String translationKey) {
            this.configString = configString;
            this.translationKey = translationKey;
        }

        @Override
        public String getStringValue() {
            return this.configString;
        }

        @Override
        public String getDisplayName() {
            return StringUtils.translate(this.translationKey, new Object[0]);
        }

        @Override
        public IConfigOptionListEntry cycle(boolean forward) {
            int id = this.ordinal();
            if (forward) {
                if (++id >= ListType.values().length) {
                    id = 0;
                }
            } else if (--id < 0) {
                id = ListType.values().length - 1;
            }
            return ListType.values()[id % ListType.values().length];
        }

        @Override
        public ListType fromString(String name) {
            return ListType.fromStringStatic(name);
        }

        public static ListType fromStringStatic(String name) {
            for (ListType mode : ListType.values()) {
                if (!mode.configString.equalsIgnoreCase(name)) continue;
                return mode;
            }
            return NONE;
        }

        public String method_15434() {
            return this.configString;
        }

        static {
            CODEC = class_3542.method_28140(ListType::values);
            VALUES = ImmutableList.copyOf((Object[])ListType.values());
        }
    }
}

