/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ParentEntry
extends ModListEntry {
    private static final class_2960 PARENT_MOD_TEXTURE = class_2960.method_60655((String)"modmenu", (String)"textures/gui/parent_mod.png");
    protected List<Mod> children;
    protected ModListWidget list;
    protected boolean hoveringIcon = false;

    public ParentEntry(Mod parent, List<Mod> children, ModListWidget list) {
        super(parent, list);
        this.children = children;
        this.list = list;
    }

    @Override
    public void method_25343(class_332 drawContext, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.method_25343(drawContext, mouseX, mouseY, isSelected, delta);
        class_327 font = this.client.field_1772;
        int x = this.method_73380() - 2;
        int y = this.method_73382() + this.getYOffset();
        Objects.requireNonNull(font);
        int childrenBadgeHeight = 9;
        Objects.requireNonNull(font);
        int childrenBadgeWidth = 9;
        int shownChildren = ModSearch.search(this.list.getParent(), this.list.getParent().getSearchInput(), this.getChildren()).size();
        class_5250 str = shownChildren == this.children.size() ? class_2561.method_43470((String)String.valueOf(shownChildren)) : class_2561.method_43470((String)(shownChildren + "/" + this.children.size()));
        int childrenWidth = font.method_27525((class_5348)str) - 1;
        if (childrenBadgeWidth < childrenWidth + 4) {
            childrenBadgeWidth = childrenWidth + 4;
        }
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        int childrenBadgeX = x + iconSize - childrenBadgeWidth;
        int childrenBadgeY = y + iconSize - childrenBadgeHeight;
        int childrenOutlineColor = -15698860;
        int childrenFillColor = -16172759;
        drawContext.method_25294(childrenBadgeX + 1, childrenBadgeY, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenOutlineColor);
        drawContext.method_25294(childrenBadgeX, childrenBadgeY + 1, childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        drawContext.method_25294(childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        drawContext.method_25294(childrenBadgeX + 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight - 1, childrenFillColor);
        drawContext.method_25294(childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight, childrenOutlineColor);
        drawContext.method_51430(font, str.method_30937(), (int)((float)childrenBadgeX + (float)childrenBadgeWidth / 2.0f - (float)childrenWidth / 2.0f), childrenBadgeY + 1, -3487030, false);
        boolean bl = this.hoveringIcon = mouseX >= x - 1 && mouseX <= x - 1 + iconSize && mouseY >= y - 1 && mouseY <= y - 1 + iconSize;
        if (this.method_25405(mouseX, mouseY)) {
            drawContext.method_25294(x, y, x + iconSize, y + iconSize, -1601138544);
            int xOffset = this.list.getParent().showModChildren.contains(this.getMod().getId()) ? iconSize : 0;
            int yOffset = this.hoveringIcon ? iconSize : 0;
            drawContext.method_25291(class_10799.field_56883, PARENT_MOD_TEXTURE, x, y, (float)xOffset, (float)yOffset, iconSize + xOffset, iconSize + yOffset, ModMenuConfig.COMPACT_LIST.getValue() ? 152 : 256, ModMenuConfig.COMPACT_LIST.getValue() ? 152 : 256, -1);
        }
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubleClick) {
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        boolean quickConfigure = ModMenuConfig.QUICK_CONFIGURE.getValue();
        if (click.comp_4798() - (double)this.list.method_25342() <= (double)iconSize) {
            this.toggleChildren();
            return true;
        }
        if (!quickConfigure && class_156.method_658() - this.sinceLastClick < 250L) {
            this.toggleChildren();
            return true;
        }
        return super.method_25402(click, doubleClick);
    }

    private void toggleChildren() {
        String id = this.getMod().getId();
        if (this.list.getParent().showModChildren.contains(id)) {
            this.list.getParent().showModChildren.remove(id);
        } else {
            this.list.getParent().showModChildren.add(id);
        }
        this.list.filter(this.list.getParent().getSearchInput(), false);
    }

    public boolean method_25404(class_11908 input) {
        String modId = this.getMod().getId();
        if (input.method_74229()) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
            } else {
                this.list.getParent().showModChildren.add(modId);
            }
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        if (input.method_74232()) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
                this.list.filter(this.list.getParent().getSearchInput(), false);
            }
            return true;
        }
        if (input.method_74233()) {
            if (!this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.add(modId);
                this.list.filter(this.list.getParent().getSearchInput(), false);
                return true;
            }
            return this.list.method_25404(new class_11908(264, 0, 0));
        }
        return super.method_25404(input);
    }

    public void setChildren(List<Mod> children) {
        this.children = children;
    }

    public void addChildren(List<Mod> children) {
        this.children.addAll(children);
    }

    public void addChildren(Mod ... children) {
        this.children.addAll(Arrays.asList(children));
    }

    public List<Mod> getChildren() {
        return this.children;
    }

    public boolean method_25405(double double_1, double double_2) {
        return Objects.equals((Object)this.list.getEntryAtPos(double_1, double_2), (Object)this);
    }
}

