/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.api.profile;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u000f\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\r\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lgg/essential/api/profile/WrappedGameProfile;", "", "Ljava/util/UUID;", "id", "", "name", "<init>", "(Ljava/util/UUID;Ljava/lang/String;)V", "Lcom/mojang/authlib/GameProfile;", "profile", "(Lcom/mojang/authlib/GameProfile;)V", "copy", "()Lgg/essential/api/profile/WrappedGameProfile;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "getId", "()Ljava/util/UUID;", "getName", "()Ljava/lang/String;", "Lcom/mojang/authlib/GameProfile;", "getProfile", "()Lcom/mojang/authlib/GameProfile;", "Lcom/mojang/authlib/properties/PropertyMap;", "getProperties", "()Lcom/mojang/authlib/properties/PropertyMap;", "properties", "essential-api"})
public final class WrappedGameProfile {
    @NotNull
    private final GameProfile profile;

    public WrappedGameProfile(@NotNull GameProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        this.profile = profile2;
    }

    @NotNull
    public final GameProfile getProfile() {
        return this.profile;
    }

    public WrappedGameProfile(@NotNull UUID id2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this(new GameProfile(id2, name2));
    }

    @NotNull
    public final UUID getId() {
        UUID uUID = this.profile.id();
        if (uUID == null) {
            String string = "OfflinePlayer:" + this.getName();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            UUID uUID2 = UUID.nameUUIDFromBytes(byArray);
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"nameUUIDFromBytes(...)");
        }
        return uUID;
    }

    @NotNull
    public final String getName() {
        String string = this.profile.name();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final PropertyMap getProperties() {
        PropertyMap propertyMap = this.profile.properties();
        Intrinsics.checkNotNullExpressionValue((Object)propertyMap, (String)"properties(...)");
        return propertyMap;
    }

    @NotNull
    public final WrappedGameProfile copy() {
        GameProfile profile2 = new GameProfile(this.profile.id(), this.profile.name());
        profile2.properties().putAll((Multimap)this.getProperties());
        return new WrappedGameProfile(profile2);
    }

    public int hashCode() {
        UUID uUID = this.profile.id();
        int result = uUID != null ? uUID.hashCode() : 0;
        String string = this.profile.name();
        result = 31 * result + (string != null ? string.hashCode() : 0);
        result = 31 * result + this.profile.properties().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WrappedGameProfile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.profile.id(), (Object)((WrappedGameProfile)other).profile.id())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.profile.name(), (Object)((WrappedGameProfile)other).profile.name())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.profile.properties(), (Object)((WrappedGameProfile)other).profile.properties());
    }
}

