/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.clipboard;

import gg.essential.clipboard.Clipboard;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001c\u0010\u0004\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lgg/essential/clipboard/AWTClipboard;", "Lgg/essential/clipboard/Clipboard;", "Ljava/awt/datatransfer/ClipboardOwner;", "()V", "lostOwnership", "Ljava/util/concurrent/Semaphore;", "getLostOwnership", "()Ljava/util/concurrent/Semaphore;", "copyPNG", "", "file", "Ljava/io/File;", "ensureRGBImage", "Ljava/awt/image/BufferedImage;", "bufferedImage", "", "p0", "Ljava/awt/datatransfer/Clipboard;", "p1", "Ljava/awt/datatransfer/Transferable;", "TransferableImage", "clipboard"})
public final class AWTClipboard
implements Clipboard,
ClipboardOwner {
    @NotNull
    private final Semaphore lostOwnership = new Semaphore(0);

    @NotNull
    public final Semaphore getLostOwnership() {
        return this.lostOwnership;
    }

    @Override
    public boolean copyPNG(@NotNull File file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            BufferedImage bufferedImage2 = ImageIO.read(file);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"read(...)");
            BufferedImage image2 = this.ensureRGBImage(bufferedImage2);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new TransferableImage(image2), this);
            bl = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public void lostOwnership(@Nullable java.awt.datatransfer.Clipboard p0, @Nullable Transferable p1) {
        this.lostOwnership.release();
    }

    private final BufferedImage ensureRGBImage(BufferedImage bufferedImage2) {
        BufferedImage bufferedImage3;
        if (bufferedImage2.getType() == 1) {
            return bufferedImage2;
        }
        BufferedImage $this$ensureRGBImage_u24lambda_u240 = bufferedImage3 = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 1);
        boolean bl = false;
        Graphics2D graphics = $this$ensureRGBImage_u24lambda_u240.createGraphics();
        graphics.drawImage((Image)bufferedImage2, 0, 0, null);
        graphics.dispose();
        return bufferedImage3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgg/essential/clipboard/AWTClipboard$TransferableImage;", "Ljava/awt/datatransfer/Transferable;", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "getTransferData", "", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "getTransferDataFlavors", "", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "clipboard"})
    private static final class TransferableImage
    implements Transferable {
        @NotNull
        private final BufferedImage image;

        public TransferableImage(@NotNull BufferedImage image2) {
            Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
            this.image = image2;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.imageFlavor, (String)"imageFlavor");
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public Object getTransferData(@NotNull DataFlavor flavor) throws UnsupportedFlavorException {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            if (DataFlavor.imageFlavor.equals(flavor)) {
                return this.image;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

