/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.connectionmanager.common.util;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoginUtil {
    private static final byte[] SHARED_CONSTANT = new BigInteger("173be201d4e5591dcef37bcaf701d136", 16).toByteArray();
    private static final int SHARED_SECRET_LENGTH = 16;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private static byte[] sha1(byte[] source) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            return digest.digest(source);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] generateSharedSecret() {
        byte[] bytes = new byte[16];
        SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }

    @Nullable
    public static String computeHash(byte @NotNull [] sharedSecret) {
        if (sharedSecret.length != 16) {
            return null;
        }
        byte[] buf = Arrays.copyOf(sharedSecret, sharedSecret.length + SHARED_CONSTANT.length);
        System.arraycopy(SHARED_CONSTANT, 0, buf, sharedSecret.length, SHARED_CONSTANT.length);
        return new BigInteger(LoginUtil.sha1(buf)).toString(16);
    }
}

