/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import gg.essential.config.EssentialConfig;
import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.cosmetics.WearablesManager;
import gg.essential.mixins.impl.client.gui.GuiInventoryExt;
import gg.essential.mixins.impl.client.model.PlayerEntityRenderStateExt;
import gg.essential.model.EnumPart;
import gg.essential.model.ModelInstance;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.model.backend.minecraft.PlayerPoseKt;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.universal.UMatrixStack;
import gg.essential.util.ExtensionsKt;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11659;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_591;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssentialModelRenderer
extends class_3887<class_10055, class_591> {
    private final class_1007 playerRenderer;

    public EssentialModelRenderer(class_1007 playerRenderer) {
        super((class_3883)playerRenderer);
        this.playerRenderer = playerRenderer;
    }

    public static boolean shouldRender(class_742 player2) {
        if (((Boolean)GuiInventoryExt.isInventoryEntityRendering.getUntracked()).booleanValue() && EssentialConfig.INSTANCE.getDisableCosmeticsInInventory()) {
            return false;
        }
        return !player2.method_5767() && !player2.method_7325();
    }

    public void render(UMatrixStack matrixStack, RenderBackend.CommandQueue queue, @Nullable class_10055 playerState, @NotNull CosmeticsRenderState cState, @Nullable Set<EnumPart> parts, boolean setsPose) {
        WearablesManager wearablesManager2 = cState.wearablesManager();
        if (wearablesManager2 == null) {
            return;
        }
        Map<Cosmetic, ModelInstance> models = wearablesManager2.getModels();
        if (models.isEmpty()) {
            return;
        }
        if (playerState != null) {
            this.playerRenderer.method_4038().method_2819((Object)playerState);
        }
        PlayerPose pose = PlayerPoseKt.toPose(this.playerRenderer, wearablesManager2.getState().getUsesCapePose(), wearablesManager2.getState().getUsesElytraPose());
        MinecraftRenderBackend.SkinTexture skin2 = new MinecraftRenderBackend.SkinTexture(cState.skinTexture());
        matrixStack.push();
        if (parts == null) {
            parts = new HashSet<EnumPart>(Arrays.asList(EnumPart.values()));
        }
        matrixStack.translate(0.0f, 1.5f, 0.0f);
        wearablesManager2.render(ExtensionsKt.toCommon(matrixStack), queue, pose, skin2, parts);
        matrixStack.pop();
        if (setsPose) {
            cState.setRenderedPose(pose);
        }
    }

    public void render(class_4587 matrices, class_11659 queue, int light, class_10055 state2, float limbAngle, float limbDistance) {
        CosmeticsRenderState.Snapshot cState = ((PlayerEntityRenderStateExt)state2).essential$getCosmetics();
        UMatrixStack uMatrixStack = new UMatrixStack(matrices);
        MinecraftRenderBackend.MinecraftCommandQueue uQueue = new MinecraftRenderBackend.MinecraftCommandQueue(queue, light);
        this.render(uMatrixStack, uQueue, state2, cState, null, true);
    }
}

