/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.account;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import gg.essential.handlers.account.WebAccountManager;
import gg.essential.lib.gson.JsonDeserializationContext;
import gg.essential.lib.gson.JsonDeserializer;
import gg.essential.lib.gson.JsonElement;
import gg.essential.lib.gson.JsonPrimitive;
import gg.essential.lib.gson.JsonSerializationContext;
import gg.essential.lib.gson.JsonSerializer;
import gg.essential.lib.gson.annotations.JsonAdapter;
import gg.essential.minecraftauth.exception.AuthenticationException;
import gg.essential.minecraftauth.microsoft.MicrosoftAuthenticationService;
import gg.essential.minecraftauth.microsoft.response.MicrosoftAccessTokenResponse;
import gg.essential.minecraftauth.minecraft.MinecraftAuthenticationService;
import gg.essential.minecraftauth.minecraft.response.MinecraftProfileResponse;
import gg.essential.minecraftauth.minecraft.response.MinecraftTokenResponse;
import gg.essential.minecraftauth.xbox.XboxLiveAuthenticationService;
import gg.essential.minecraftauth.xbox.response.XboxLiveTokenResponse;
import gg.essential.util.UUIDUtil;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001:\u0002>?B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0012\u001a\u00020\u00112\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0015\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000bJ'\u0010\u0016\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u000bJ3\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00172\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J1\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u00172\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0019J\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u0017\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J9\u0010'\u001a\u00020\u001b*\u0004\u0018\u00010!2!\u0010&\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u001b0\"H\u0082\b\u00a2\u0006\u0004\b'\u0010(R\u0018\u0010)\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0013\u0010.\u001a\u0004\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0018\u0010/\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u0010*R$\u00100\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0018\u00106\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0018\u00108\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0018\u0010:\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010*R\u0018\u0010;\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u00109R\u0018\u0010<\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010*R\u0018\u0010=\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010*\u00a8\u0006@"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication;", "", "<init>", "()V", "Ljava/util/concurrent/CompletableFuture;", "Ljava/net/URI;", "future", "", "forceRefresh", "", "acquireAccessToken", "(Ljava/util/concurrent/CompletableFuture;Z)Ljava/lang/String;", "acquireAccessTokenViaOAuth", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/String;", "codeVerifier", "acquireAuthorizationCode", "(Ljava/lang/String;Ljava/util/concurrent/CompletableFuture;)Ljava/lang/String;", "Lcom/mojang/authlib/GameProfile;", "acquireGameProfile", "(Ljava/util/concurrent/CompletableFuture;)Lcom/mojang/authlib/GameProfile;", "retry", "acquireMCToken", "acquireXBLToken", "Lkotlin/Pair;", "acquireXSTSToken", "(Ljava/util/concurrent/CompletableFuture;Z)Lkotlin/Pair;", "logIn", "", "refreshRefreshToken", "Lgg/essential/minecraftauth/microsoft/response/MicrosoftAccessTokenResponse;", "response", "saveMicrosoftTokens", "(Lgg/essential/minecraftauth/microsoft/response/MicrosoftAccessTokenResponse;)V", "Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "token", "block", "ifValid", "(Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;Lkotlin/jvm/functions/Function1;)V", "accessToken", "Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "Ljava/time/Instant;", "getExpiryTime", "()Ljava/time/Instant;", "expiryTime", "mcToken", "openUri", "Ljava/net/URI;", "getOpenUri", "()Ljava/net/URI;", "setOpenUri", "(Ljava/net/URI;)V", "profile", "Lcom/mojang/authlib/GameProfile;", "redirectUri", "Ljava/lang/String;", "refreshToken", "uhs", "xblToken", "xstsToken", "LegacyTokenSerializer", "Token", "Essential 1.21.9-fabric"})
@SourceDebugExtension(value={"SMAP\nMicrosoftUserAuthentication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicrosoftUserAuthentication.kt\ngg/essential/gui/account/MicrosoftUserAuthentication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n201#1,4:219\n201#1,4:224\n201#1,4:228\n201#1,4:232\n1#2:223\n*S KotlinDebug\n*F\n+ 1 MicrosoftUserAuthentication.kt\ngg/essential/gui/account/MicrosoftUserAuthentication\n*L\n69#1:219,4\n111#1:224,4\n133#1:228,4\n157#1:232,4\n*E\n"})
public final class MicrosoftUserAuthentication {
    @Nullable
    private String redirectUri;
    @Nullable
    private Token accessToken;
    @JsonAdapter(value=LegacyTokenSerializer.class)
    @Nullable
    private Token refreshToken;
    @Nullable
    private Token xblToken;
    @Nullable
    private Token xstsToken;
    @Nullable
    private String uhs;
    @Nullable
    private Token mcToken;
    @Nullable
    private GameProfile profile;
    @Nullable
    private URI openUri;

    @Nullable
    public final Instant getExpiryTime() {
        Token token = this.refreshToken;
        return token != null ? token.getExpires() : null;
    }

    @Nullable
    public final URI getOpenUri() {
        return this.openUri;
    }

    public final void setOpenUri(@Nullable URI uRI) {
        this.openUri = uRI;
    }

    @NotNull
    public final Pair<GameProfile, String> logIn(@NotNull CompletableFuture<URI> future2, boolean forceRefresh) {
        Intrinsics.checkNotNullParameter(future2, (String)"future");
        if (forceRefresh) {
            this.mcToken = null;
        }
        GameProfile profile2 = this.acquireGameProfile(future2);
        String token = MicrosoftUserAuthentication.acquireMCToken$default(this, future2, false, 2, null);
        return new Pair((Object)profile2, (Object)token);
    }

    public static /* synthetic */ Pair logIn$default(MicrosoftUserAuthentication microsoftUserAuthentication, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return microsoftUserAuthentication.logIn(completableFuture, bl);
    }

    public final void refreshRefreshToken() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        this.acquireAccessToken(completableFuture, true);
    }

    private final String acquireAccessToken(CompletableFuture<URI> future2, boolean forceRefresh) {
        if (!forceRefresh) {
            MicrosoftUserAuthentication microsoftUserAuthentication = this;
            Token $this$ifValid$iv = this.accessToken;
            boolean $i$f$ifValid = false;
            if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
                String it = $this$ifValid$iv.getValue();
                boolean bl = false;
                return it;
            }
        }
        Token token = this.refreshToken;
        if (token == null) {
            return this.acquireAccessTokenViaOAuth(future2);
        }
        Token refreshToken = token;
        MicrosoftAccessTokenResponse response = MicrosoftAuthenticationService.INSTANCE.refreshAccessToken(refreshToken.getValue());
        this.saveMicrosoftTokens(response);
        return response.getAccessToken();
    }

    /*
     * WARNING - void declaration
     */
    private final String acquireAccessTokenViaOAuth(CompletableFuture<URI> future2) {
        void it;
        byte[] byArray;
        byte[] byArray2 = byArray = new byte[32];
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        boolean bl = false;
        new SecureRandom().nextBytes((byte[])it);
        String codeVerifier = encoder.encodeToString(byArray);
        Intrinsics.checkNotNull((Object)codeVerifier);
        String code = this.acquireAuthorizationCode(codeVerifier, future2);
        String string = this.redirectUri;
        if (string == null) {
            string = "";
        }
        MicrosoftAccessTokenResponse response = MicrosoftAuthenticationService.INSTANCE.exchangeCodeForAccessToken(code, codeVerifier, string);
        this.saveMicrosoftTokens(response);
        return response.getAccessToken();
    }

    private final void saveMicrosoftTokens(MicrosoftAccessTokenResponse response) {
        String string = response.getRefreshToken();
        Instant instant = Instant.now().plus(Duration.ofDays(90L));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        this.refreshToken = new Token(string, instant);
        String string2 = response.getAccessToken();
        Instant instant2 = Instant.now().plus(Duration.ofSeconds(response.getExpiresIn()));
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"plus(...)");
        this.accessToken = new Token(string2, instant2);
    }

    private final String acquireAuthorizationCode(String codeVerifier, CompletableFuture<URI> future2) {
        this.redirectUri = WebAccountManager.INSTANCE.getMicrosoftRedirectUri();
        String string = this.redirectUri;
        if (string == null) {
            string = "";
        }
        URI uri = MicrosoftAuthenticationService.INSTANCE.generateAuthorizationURI(codeVerifier, string);
        if (future2.isDone()) {
            throw new InvalidCredentialsException("Re-authentication with Microsoft required");
        }
        future2.complete(uri);
        this.openUri = uri;
        CompletableFuture<String> completableFuture = WebAccountManager.INSTANCE.getAuthorizationCodeFuture();
        String string2 = completableFuture != null ? completableFuture.join() : null;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    private final String acquireXBLToken(CompletableFuture<URI> future2, boolean retry) {
        XboxLiveTokenResponse $i$f$ifValid2;
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        Token $this$ifValid$iv = this.xblToken;
        boolean $i$f$ifValid2 = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean bl = false;
            return it;
        }
        String accessToken = this.acquireAccessToken(future2, false);
        try {
            $i$f$ifValid2 = XboxLiveAuthenticationService.INSTANCE.authenticateWithXboxLive(accessToken);
        }
        catch (AuthenticationException.InvalidCredentials e) {
            if (retry) {
                this.accessToken = null;
                return this.acquireXBLToken(future2, false);
            }
            throw e;
        }
        XboxLiveTokenResponse response = $i$f$ifValid2;
        Instant expires = Instant.parse(response.getNotAfter());
        String string = response.getToken();
        Intrinsics.checkNotNull((Object)expires);
        this.xblToken = new Token(string, expires);
        return response.getToken();
    }

    static /* synthetic */ String acquireXBLToken$default(MicrosoftUserAuthentication microsoftUserAuthentication, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return microsoftUserAuthentication.acquireXBLToken(completableFuture, bl);
    }

    private final Pair<String, String> acquireXSTSToken(CompletableFuture<URI> future2, boolean retry) {
        Pair<XboxLiveTokenResponse, String> $i$f$ifValid2;
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        Token $this$ifValid$iv = this.xstsToken;
        boolean $i$f$ifValid2 = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean bl = false;
            String string = this.uhs;
            Intrinsics.checkNotNull((Object)string);
            return new Pair((Object)it, (Object)string);
        }
        String xblToken = MicrosoftUserAuthentication.acquireXBLToken$default(this, future2, false, 2, null);
        try {
            $i$f$ifValid2 = XboxLiveAuthenticationService.INSTANCE.authenticateWithXSTS(xblToken);
        }
        catch (AuthenticationException.InvalidCredentials e) {
            if (retry) {
                this.xblToken = null;
                return this.acquireXSTSToken(future2, false);
            }
            throw e;
        }
        Pair<XboxLiveTokenResponse, String> pair = $i$f$ifValid2;
        XboxLiveTokenResponse response = (XboxLiveTokenResponse)pair.component1();
        String userHash = (String)pair.component2();
        Instant expires = Instant.parse(response.getNotAfter());
        this.uhs = userHash;
        String string = response.getToken();
        Intrinsics.checkNotNull((Object)expires);
        this.xstsToken = new Token(string, expires);
        return TuplesKt.to((Object)response.getToken(), (Object)userHash);
    }

    static /* synthetic */ Pair acquireXSTSToken$default(MicrosoftUserAuthentication microsoftUserAuthentication, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return microsoftUserAuthentication.acquireXSTSToken(completableFuture, bl);
    }

    private final String acquireMCToken(CompletableFuture<URI> future2, boolean retry) {
        MinecraftTokenResponse minecraftTokenResponse2;
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        Token $this$ifValid$iv = this.mcToken;
        boolean $i$f$ifValid = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean minecraftTokenResponse2 = false;
            return it;
        }
        microsoftUserAuthentication = MicrosoftUserAuthentication.acquireXSTSToken$default(this, future2, false, 2, null);
        String xstsToken = (String)microsoftUserAuthentication.component1();
        String uhs = (String)microsoftUserAuthentication.component2();
        try {
            minecraftTokenResponse2 = MinecraftAuthenticationService.INSTANCE.authenticateWithXbox(xstsToken, uhs);
        }
        catch (AuthenticationException.InvalidCredentials e) {
            if (retry) {
                this.xstsToken = null;
                return this.acquireMCToken(future2, false);
            }
            throw e;
        }
        MinecraftTokenResponse response = minecraftTokenResponse2;
        String token = response.getAccessToken();
        long expiresIn = response.getExpiresIn();
        Instant instant = Instant.now().plus(Duration.ofSeconds(expiresIn));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        this.mcToken = new Token(token, instant);
        this.profile = null;
        return token;
    }

    static /* synthetic */ String acquireMCToken$default(MicrosoftUserAuthentication microsoftUserAuthentication, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return microsoftUserAuthentication.acquireMCToken(completableFuture, bl);
    }

    private final GameProfile acquireGameProfile(CompletableFuture<URI> future2) {
        GameProfile profile2;
        String token = MicrosoftUserAuthentication.acquireMCToken$default(this, future2, false, 2, null);
        GameProfile gameProfile2 = this.profile;
        if (gameProfile2 != null) {
            GameProfile it = gameProfile2;
            boolean bl = false;
            return it;
        }
        MinecraftProfileResponse response = MinecraftAuthenticationService.INSTANCE.getProfile(token);
        this.profile = profile2 = new GameProfile(UUIDUtil.formatWithDashes(response.getId()), response.getName());
        return profile2;
    }

    private final void ifValid(Token $this$ifValid, Function1<? super String, Unit> block) {
        boolean $i$f$ifValid = false;
        if ($this$ifValid != null && !$this$ifValid.getExpired()) {
            block.invoke((Object)$this$ifValid.getValue());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication$LegacyTokenSerializer;", "Lgg/essential/lib/gson/JsonSerializer;", "Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "Lgg/essential/lib/gson/JsonDeserializer;", "<init>", "()V", "Lgg/essential/lib/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lgg/essential/lib/gson/JsonDeserializationContext;", "context", "deserialize", "(Lgg/essential/lib/gson/JsonElement;Ljava/lang/reflect/Type;Lgg/essential/lib/gson/JsonDeserializationContext;)Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "src", "typeOfSrc", "Lgg/essential/lib/gson/JsonSerializationContext;", "serialize", "(Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;Ljava/lang/reflect/Type;Lgg/essential/lib/gson/JsonSerializationContext;)Lgg/essential/lib/gson/JsonElement;", "Essential 1.21.9-fabric"})
    private static final class LegacyTokenSerializer
    implements JsonSerializer<Token>,
    JsonDeserializer<Token> {
        @Override
        @NotNull
        public Token deserialize(@NotNull JsonElement json2, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
            Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (json2 instanceof JsonPrimitive) {
                String string = ((JsonPrimitive)json2).getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
                token = new Token(string, instant);
            } else {
                Object t = context.deserialize(json2, (Type)((Object)Token.class));
                Intrinsics.checkNotNullExpressionValue(t, (String)"deserialize(...)");
                token = (Token)t;
            }
            return token;
        }

        @Override
        @NotNull
        public JsonElement serialize(@NotNull Token src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonElement jsonElement = context.serialize(src);
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"serialize(...)");
            return jsonElement;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\tR\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\t\u00a8\u0006\u001d"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "", "", "value", "Ljava/time/Instant;", "expires", "<init>", "(Ljava/lang/String;Ljava/time/Instant;)V", "component1", "()Ljava/lang/String;", "component2", "()Ljava/time/Instant;", "copy", "(Ljava/lang/String;Ljava/time/Instant;)Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "getExpired", "()Z", "expired", "Ljava/time/Instant;", "getExpires", "Ljava/lang/String;", "getValue", "Essential 1.21.9-fabric"})
    public static final class Token {
        @NotNull
        private final String value;
        @NotNull
        private final Instant expires;

        public Token(@NotNull String value, @NotNull Instant expires) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
            this.value = value;
            this.expires = expires;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final Instant getExpires() {
            return this.expires;
        }

        public final boolean getExpired() {
            return this.expires.isBefore(Instant.now());
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final Instant component2() {
            return this.expires;
        }

        @NotNull
        public final Token copy(@NotNull String value, @NotNull Instant expires) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
            return new Token(value, expires);
        }

        public static /* synthetic */ Token copy$default(Token token, String string, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = token.value;
            }
            if ((n & 2) != 0) {
                instant = token.expires;
            }
            return token.copy(string, instant);
        }

        @NotNull
        public String toString() {
            return "Token(value=" + this.value + ", expires=" + this.expires + ")";
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + this.expires.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)token.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expires, (Object)token.expires);
        }
    }
}

