/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.gui.common.MenuButton;
import gg.essential.gui.elementa.state.v2.CompatibilityKt;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.layoutdsl.EventsKt;
import gg.essential.gui.layoutdsl.LayoutKt;
import gg.essential.gui.layoutdsl.LayoutScope;
import gg.essential.gui.layoutdsl.Modifier;
import gg.essential.gui.layoutdsl.SizeKt;
import gg.essential.gui.util.ElementaExtensionsKt;
import gg.essential.universal.UMatrixStack;
import gg.essential.util.image.bitmap.Bitmap;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018Bc\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00122\u0010\b\u001a.\u0012\u0004\u0012\u00020\n\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u000bH\u0002R:\u0010\b\u001a.\u0012\u0004\u0012\u00020\n\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgg/essential/gui/common/StyledButton;", "Lgg/essential/elementa/UIComponent;", "style", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/common/StyledButton$Style;", "enableRetexturing", "", "disabled", "content", "Lkotlin/Function2;", "Lgg/essential/gui/layoutdsl/LayoutScope;", "Lgg/essential/gui/common/MenuButton$Style;", "Lkotlin/ParameterName;", "name", "", "Lkotlin/ExtensionFunctionType;", "(Lgg/essential/gui/elementa/state/v2/State;Lgg/essential/gui/elementa/state/v2/State;Lgg/essential/gui/elementa/state/v2/State;Lkotlin/jvm/functions/Function2;)V", "currentStyle", "hovered", "Lgg/essential/gui/elementa/state/v2/MutableState;", "draw", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawDefaultButton", "Style", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nstyledButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 styledButton.kt\ngg/essential/gui/common/StyledButton\n+ 2 Extensions.kt\ngg/essential/vigilance/utils/ExtensionsKt\n*L\n1#1,148:1\n22#2,5:149\n*S KotlinDebug\n*F\n+ 1 styledButton.kt\ngg/essential/gui/common/StyledButton\n*L\n69#1:149,5\n*E\n"})
public final class StyledButton
extends UIComponent {
    @NotNull
    private final State<Style> style;
    @NotNull
    private final State<Boolean> enableRetexturing;
    @NotNull
    private final State<Boolean> disabled;
    @NotNull
    private final Function2<LayoutScope, State<MenuButton.Style>, Unit> content;
    @NotNull
    private final MutableState<Boolean> hovered;
    @NotNull
    private final State<MenuButton.Style> currentStyle;

    public StyledButton(@NotNull State<Style> style, @NotNull State<Boolean> enableRetexturing, @NotNull State<Boolean> disabled2, @NotNull Function2<? super LayoutScope, ? super State<MenuButton.Style>, Unit> content) {
        Intrinsics.checkNotNullParameter(style, (String)"style");
        Intrinsics.checkNotNullParameter(enableRetexturing, (String)"enableRetexturing");
        Intrinsics.checkNotNullParameter(disabled2, (String)"disabled");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.style = style;
        this.enableRetexturing = enableRetexturing;
        this.disabled = disabled2;
        this.content = content;
        this.hovered = CompatibilityKt.toV2(ElementaExtensionsKt.hoverScope$default(this, false, 1, null));
        this.currentStyle = StateKt.memo((Function1)new Function1<Observer, MenuButton.Style>(this){
            final /* synthetic */ StyledButton this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final MenuButton.Style invoke(@NotNull Observer $this$memo) {
                Intrinsics.checkNotNullParameter((Object)$this$memo, (String)"$this$memo");
                Style style = (Style)$this$memo.invoke(StyledButton.access$getStyle$p(this.this$0));
                return (Boolean)$this$memo.invoke(StyledButton.access$getDisabled$p(this.this$0)) != false ? style.getDisabledStyle() : ((Boolean)$this$memo.invoke(StyledButton.access$getHovered$p(this.this$0)) != false ? style.getHoveredStyle() : style.getDefaultStyle());
            }
        });
        LayoutKt.layoutAsBox(this, EventsKt.hoverScope$default(SizeKt.childBasedHeight(SizeKt.childBasedWidth(Modifier.Companion, 5.0f), 6.0f), null, 1, null), (Function1<? super LayoutScope, Unit>)((Function1)new Function1<LayoutScope, Unit>(){

            public final void invoke(@NotNull LayoutScope $this$layoutAsBox) {
                Intrinsics.checkNotNullParameter((Object)$this$layoutAsBox, (String)"$this$layoutAsBox");
                content.invoke((Object)$this$layoutAsBox, (Object)currentStyle);
            }
        }));
        UIComponent $this$onLeftClick$iv = this;
        boolean $i$f$onLeftClick = false;
        $this$onLeftClick$iv.onMouseClick((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ StyledButton this$0;
            {
                this.this$0 = styledButton;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getMouseButton() == 0) {
                    UIClickEvent uIClickEvent = it;
                    UIComponent $this$_init__u24lambda_u240 = $this$onMouseClick;
                    boolean bl = false;
                    if (((Boolean)StyledButton.access$getDisabled$p(this.this$0).getUntracked()).booleanValue()) {
                        void event;
                        event.stopImmediatePropagation();
                    }
                }
            }
        });
    }

    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDraw(matrixStack);
        MenuButton.Style style = this.currentStyle.getUntracked();
        boolean hovered = (Boolean)this.hovered.getUntracked();
        if (style.getButtonColor().getAlpha() != 0) {
            if (this.enableRetexturing.getUntracked().booleanValue()) {
                Pair<MenuButton.ButtonTextures.Type, Bitmap> pair = MenuButton.ButtonTextures.INSTANCE.currentTexture(hovered);
                MenuButton.ButtonTextures.Type type = (MenuButton.ButtonTextures.Type)((Object)pair.component1());
                Bitmap texture = (Bitmap)pair.component2();
                if (texture == null) {
                    this.drawDefaultButton(matrixStack, style);
                } else {
                    boolean isDefaultOrHoveredBaseColor = Intrinsics.areEqual((Object)style.getButtonColor(), (Object)(hovered ? MenuButton.Companion.getGRAY() : MenuButton.Companion.getDARK_GRAY()).getButtonColor());
                    MenuButton.Companion.drawTexturedButton(matrixStack, this.getLeft(), this.getTop(), this.getRight(), this.getBottom(), style.getButtonColor(), isDefaultOrHoveredBaseColor, type == MenuButton.ButtonTextures.Type.Essential, texture);
                }
            } else {
                this.drawDefaultButton(matrixStack, style);
            }
        }
        super.draw(matrixStack);
    }

    private final void drawDefaultButton(UMatrixStack matrixStack, MenuButton.Style style) {
        double d = (double)this.getLeft() + 1.0;
        double d2 = (double)this.getTop() + 1.0;
        double d3 = (double)this.getRight() - 1.0;
        double d4 = (double)this.getBottom() - 1.0;
        Color color2 = style.getButtonColor();
        Color color3 = style.getHighlightColor();
        Color color4 = style.getButtonColor().darker().darker();
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"darker(...)");
        MenuButton.Companion.drawButton(matrixStack, d, d2, d3, d4, color2, color3, ExtensionsKt.withAlpha((Color)color4, (float)0.5f), style.getOutlineColor(), true, true, true, true);
    }

    public static final /* synthetic */ State access$getDisabled$p(StyledButton $this) {
        return $this.disabled;
    }

    public static final /* synthetic */ State access$getStyle$p(StyledButton $this) {
        return $this.style;
    }

    public static final /* synthetic */ MutableState access$getHovered$p(StyledButton $this) {
        return $this.hovered;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lgg/essential/gui/common/StyledButton$Style;", "", "defaultStyle", "Lgg/essential/gui/common/MenuButton$Style;", "hoveredStyle", "disabledStyle", "(Lgg/essential/gui/common/MenuButton$Style;Lgg/essential/gui/common/MenuButton$Style;Lgg/essential/gui/common/MenuButton$Style;)V", "getDefaultStyle", "()Lgg/essential/gui/common/MenuButton$Style;", "getDisabledStyle", "getHoveredStyle", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "essential-gui-essential"})
    public static final class Style {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MenuButton.Style defaultStyle;
        @NotNull
        private final MenuButton.Style hoveredStyle;
        @NotNull
        private final MenuButton.Style disabledStyle;
        @NotNull
        private static final Style GRAY = new Style(MenuButton.Companion.getDARK_GRAY(), MenuButton.Companion.getGRAY(), MenuButton.Companion.getGRAY_DISABLED());
        @NotNull
        private static final Style BLUE = new Style(MenuButton.Companion.getBLUE(), MenuButton.Companion.getLIGHT_BLUE(), MenuButton.Companion.getBLUE_DISABLED());
        @NotNull
        private static final Style RED = new Style(MenuButton.Companion.getRED(), MenuButton.Companion.getLIGHT_RED(), MenuButton.Companion.getRED_DISABLED());
        @NotNull
        private static final Style GREEN = new Style(MenuButton.Companion.getGREEN(), MenuButton.Companion.getLIGHT_GREEN(), MenuButton.Companion.getGREEN_DISABLED());

        public Style(@NotNull MenuButton.Style defaultStyle2, @NotNull MenuButton.Style hoveredStyle, @NotNull MenuButton.Style disabledStyle2) {
            Intrinsics.checkNotNullParameter((Object)defaultStyle2, (String)"defaultStyle");
            Intrinsics.checkNotNullParameter((Object)hoveredStyle, (String)"hoveredStyle");
            Intrinsics.checkNotNullParameter((Object)disabledStyle2, (String)"disabledStyle");
            this.defaultStyle = defaultStyle2;
            this.hoveredStyle = hoveredStyle;
            this.disabledStyle = disabledStyle2;
        }

        @NotNull
        public final MenuButton.Style getDefaultStyle() {
            return this.defaultStyle;
        }

        @NotNull
        public final MenuButton.Style getHoveredStyle() {
            return this.hoveredStyle;
        }

        @NotNull
        public final MenuButton.Style getDisabledStyle() {
            return this.disabledStyle;
        }

        @NotNull
        public final MenuButton.Style component1() {
            return this.defaultStyle;
        }

        @NotNull
        public final MenuButton.Style component2() {
            return this.hoveredStyle;
        }

        @NotNull
        public final MenuButton.Style component3() {
            return this.disabledStyle;
        }

        @NotNull
        public final Style copy(@NotNull MenuButton.Style defaultStyle2, @NotNull MenuButton.Style hoveredStyle, @NotNull MenuButton.Style disabledStyle2) {
            Intrinsics.checkNotNullParameter((Object)defaultStyle2, (String)"defaultStyle");
            Intrinsics.checkNotNullParameter((Object)hoveredStyle, (String)"hoveredStyle");
            Intrinsics.checkNotNullParameter((Object)disabledStyle2, (String)"disabledStyle");
            return new Style(defaultStyle2, hoveredStyle, disabledStyle2);
        }

        public static /* synthetic */ Style copy$default(Style style, MenuButton.Style style2, MenuButton.Style style3, MenuButton.Style style4, int n, Object object) {
            if ((n & 1) != 0) {
                style2 = style.defaultStyle;
            }
            if ((n & 2) != 0) {
                style3 = style.hoveredStyle;
            }
            if ((n & 4) != 0) {
                style4 = style.disabledStyle;
            }
            return style.copy(style2, style3, style4);
        }

        @NotNull
        public String toString() {
            return "Style(defaultStyle=" + this.defaultStyle + ", hoveredStyle=" + this.hoveredStyle + ", disabledStyle=" + this.disabledStyle + ')';
        }

        public int hashCode() {
            int result = this.defaultStyle.hashCode();
            result = result * 31 + this.hoveredStyle.hashCode();
            result = result * 31 + this.disabledStyle.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Style)) {
                return false;
            }
            Style style = (Style)other;
            if (!Intrinsics.areEqual((Object)this.defaultStyle, (Object)style.defaultStyle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hoveredStyle, (Object)style.hoveredStyle)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.disabledStyle, (Object)style.disabledStyle);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lgg/essential/gui/common/StyledButton$Style$Companion;", "", "()V", "BLUE", "Lgg/essential/gui/common/StyledButton$Style;", "getBLUE", "()Lgg/essential/gui/common/StyledButton$Style;", "GRAY", "getGRAY", "GREEN", "getGREEN", "RED", "getRED", "essential-gui-essential"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Style getGRAY() {
                return GRAY;
            }

            @NotNull
            public final Style getBLUE() {
                return BLUE;
            }

            @NotNull
            public final Style getRED() {
                return RED;
            }

            @NotNull
            public final Style getGREEN() {
                return GREEN;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

