/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common.shadow;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.font.FontProvider;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.LoadingIcon;
import gg.essential.gui.common.SequenceAnimatedUIImage;
import gg.essential.gui.common.shadow.EssentialUIText;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgg/essential/gui/common/shadow/ShadowEffect;", "Lgg/essential/elementa/effects/Effect;", "shadowColor", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "shadowColorState", "Lgg/essential/gui/elementa/state/v2/State;", "(Lgg/essential/gui/elementa/state/v2/State;)V", "beforeDraw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "getDebugInfo", "", "essential-gui-essential"})
public final class ShadowEffect
extends Effect {
    @NotNull
    private final State<Color> shadowColorState;

    public ShadowEffect(@NotNull State<? extends Color> shadowColorState2) {
        Intrinsics.checkNotNullParameter(shadowColorState2, (String)"shadowColorState");
        this.shadowColorState = shadowColorState2;
    }

    public ShadowEffect(@NotNull Color shadowColor2) {
        Intrinsics.checkNotNullParameter((Object)shadowColor2, (String)"shadowColor");
        this(StateKt.stateOf(shadowColor2));
    }

    public /* synthetic */ ShadowEffect(Color color2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            color2 = EssentialPalette.COMPONENT_BACKGROUND;
        }
        this(color2);
    }

    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Color shadowColor2 = this.shadowColorState.getUntracked();
        UIComponent boundComponent = this.getBoundComponent();
        if (boundComponent instanceof EssentialUIText) {
            String text2 = ((EssentialUIText)boundComponent).getText();
            if (((CharSequence)text2).length() == 0 || boundComponent.getColor().getAlpha() <= 10) {
                return;
            }
            UIConstraints constraints = boundComponent.getConstraints();
            float scale2 = constraints.getTextScale();
            FontProvider fontProvider = constraints.getFontProvider();
            float x = boundComponent.getLeft();
            float y = boundComponent.getTop() + (constraints.getY() instanceof CenterConstraint ? fontProvider.getBelowLineHeight() * scale2 : 0.0f);
            UGraphics.enableBlend();
            FontProvider.drawString$default((FontProvider)fontProvider, (UMatrixStack)matrixStack, (String)text2, (Color)shadowColor2, (float)(x + 1.0f), (float)(y + 1.0f), (float)10.0f, (float)scale2, (boolean)false, null, (int)256, null);
        } else if (boundComponent instanceof SequenceAnimatedUIImage) {
            UIImage uIImage = ((SequenceAnimatedUIImage)boundComponent).getCurrentFrameComponent();
            if (uIImage == null) {
                return;
            }
            UIImage child = uIImage;
            child.drawImage(matrixStack, (double)boundComponent.getLeft() + 1.0, (double)boundComponent.getTop() + 1.0, (double)boundComponent.getWidth(), (double)boundComponent.getHeight(), shadowColor2);
        } else if (boundComponent instanceof UIBlock ? true : boundComponent instanceof UIContainer) {
            if (boundComponent.getColor().getAlpha() == 0) {
                return;
            }
            double x = boundComponent.getLeft();
            double y = boundComponent.getTop();
            double x2 = boundComponent.getRight();
            double y2 = boundComponent.getBottom();
            UIBlock.Companion.drawBlock(matrixStack, shadowColor2, x + 1.0, y + 1.0, x2 + 1.0, y2 + 1.0);
        } else if (boundComponent instanceof UIImage) {
            ((UIImage)boundComponent).drawImage(matrixStack, (double)boundComponent.getLeft() + 1.0, (double)boundComponent.getTop() + 1.0, (double)boundComponent.getWidth(), (double)boundComponent.getHeight(), shadowColor2);
        } else if (boundComponent instanceof LoadingIcon) {
            float xCenter = (boundComponent.getLeft() + boundComponent.getRight()) / (float)2;
            float yCenter = (boundComponent.getTop() + boundComponent.getBottom()) / (float)2;
            LoadingIcon.Companion.draw(matrixStack, xCenter + (float)((int)((LoadingIcon)boundComponent).getScale()), yCenter + (float)((int)((LoadingIcon)boundComponent).getScale()), ((LoadingIcon)boundComponent).getScale(), ((LoadingIcon)boundComponent).getTime(), shadowColor2);
        } else {
            throw new UnsupportedOperationException("Shadow effect cannot be applied to " + this.getDebugInfo());
        }
    }

    private final String getDebugInfo() {
        return this.getBoundComponent().getComponentName() + ' ' + this.getBoundComponent().getClass().getName();
    }
}

