/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.effects;

import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.effects.Effect;
import gg.essential.gui.elementa.state.v2.CompatibilityKt;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.essential.universal.render.DrawCallBuilder;
import gg.essential.universal.render.URenderPipeline;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.vertex.UBufferBuilder;
import gg.essential.universal.vertex.UBuiltBuffer;
import gg.essential.universal.vertex.UVertexConsumer;
import gg.essential.util.GuiEssentialPlatform;
import gg.essential.util.image.GpuTexture;
import java.awt.Color;
import java.io.Closeable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgg/essential/gui/effects/AlphaEffect;", "Lgg/essential/elementa/effects/Effect;", "alphaState", "Lgg/essential/elementa/state/State;", "", "(Lgg/essential/elementa/state/State;)V", "Lgg/essential/gui/elementa/state/v2/State;", "(Lgg/essential/gui/elementa/state/v2/State;)V", "resources", "Lgg/essential/gui/effects/AlphaEffect$Resources;", "afterDraw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "beforeDraw", "cleanup", "clear", "setup", "Companion", "Resources", "essential-gui-essential"})
public final class AlphaEffect
extends Effect {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final State<Float> alphaState;
    private Resources resources;
    @NotNull
    private static final URenderPipeline CLEAR_PIPELINE;
    @NotNull
    private static final URenderPipeline MULTIPLY_PIPELINE;
    @NotNull
    private static final URenderPipeline COMPOSITE_PIPELINE;

    public AlphaEffect(@NotNull State<Float> alphaState) {
        Intrinsics.checkNotNullParameter(alphaState, (String)"alphaState");
        this.alphaState = alphaState;
    }

    public AlphaEffect(@NotNull gg.essential.elementa.state.State<Float> alphaState) {
        Intrinsics.checkNotNullParameter(alphaState, (String)"alphaState");
        this((State<Float>)CompatibilityKt.toV2(alphaState));
    }

    public void setup() {
        Resources.Companion.drainCleanupQueue();
        this.resources = new Resources(this);
    }

    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        Resources resources;
        int height2;
        int width2;
        int y;
        int x;
        block11: {
            Resources resources2;
            block10: {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                if (this.resources == null) {
                    throw new IllegalStateException("AlphaEffect has not yet been setup or has already been cleaned up! ElementaVersion.V4 or newer is required for proper operation!".toString());
                }
                double scale2 = UResolution.getScaleFactor();
                int left = RangesKt.coerceIn((int)((int)((double)this.getBoundComponent().getLeft() * scale2)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportWidth())));
                int right = RangesKt.coerceIn((int)((int)((double)this.getBoundComponent().getRight() * scale2)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportWidth())));
                int top = RangesKt.coerceIn((int)((int)((double)this.getBoundComponent().getTop() * scale2)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportHeight())));
                int bottom = RangesKt.coerceIn((int)((int)((double)this.getBoundComponent().getBottom() * scale2)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportHeight())));
                x = left;
                y = UResolution.getViewportHeight() - bottom;
                width2 = right - left;
                height2 = bottom - top;
                if (width2 == 0 || height2 == 0) {
                    return;
                }
                Resources resources3 = this.resources;
                if (resources3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
                    resources3 = null;
                }
                if (resources3.getTexture().getWidth() != width2) break block10;
                Resources resources4 = this.resources;
                if (resources4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
                    resources4 = null;
                }
                if (resources4.getTexture().getHeight() == height2) break block11;
            }
            if ((resources2 = this.resources) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
                resources2 = null;
            }
            resources2.getTexture().resize(width2, height2);
        }
        if ((resources = this.resources) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
            resources = null;
        }
        GpuTexture gpuTexture = resources.getTexture();
        GpuTexture gpuTexture2 = GuiEssentialPlatform.Companion.getPlatform().getOutputColorTextureOverride();
        if (gpuTexture2 == null) {
            gpuTexture2 = GuiEssentialPlatform.Companion.getPlatform().getMcFrameBufferColorTexture();
        }
        gpuTexture.copyFrom(CollectionsKt.listOf((Object)new GpuTexture.CopyOp(gpuTexture2, x, y, 0, 0, width2, height2)));
        this.clear(matrixStack);
    }

    private final void clear(UMatrixStack matrixStack) {
        block0: {
            UBufferBuilder uBufferBuilder;
            UBufferBuilder buffer = uBufferBuilder = UBufferBuilder.Companion.create(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
            boolean bl = false;
            UIBlock.Companion.drawBlock((UVertexConsumer)buffer, matrixStack, new Color(0, 0, 0, 255), (double)this.getBoundComponent().getLeft(), (double)this.getBoundComponent().getTop(), (double)this.getBoundComponent().getRight(), (double)this.getBoundComponent().getBottom());
            UBuiltBuffer uBuiltBuffer = uBufferBuilder.build();
            if (uBuiltBuffer == null) break block0;
            UBuiltBuffer.drawAndClose$default((UBuiltBuffer)uBuiltBuffer, (URenderPipeline)CLEAR_PIPELINE, null, (int)2, null);
        }
    }

    public void afterDraw(@NotNull UMatrixStack matrixStack) {
        block4: {
            UBufferBuilder buffer;
            UBufferBuilder uBufferBuilder;
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            double left = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.getBoundComponent().getLeft()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)((double)UResolution.getViewportWidth() / UResolution.getScaleFactor()))))).doubleValue();
            double right = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.getBoundComponent().getRight()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)((double)UResolution.getViewportWidth() / UResolution.getScaleFactor()))))).doubleValue();
            double top = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.getBoundComponent().getTop()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)((double)UResolution.getViewportHeight() / UResolution.getScaleFactor()))))).doubleValue();
            double bottom = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.getBoundComponent().getBottom()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)((double)UResolution.getViewportHeight() / UResolution.getScaleFactor()))))).doubleValue();
            double x = left;
            double y = top;
            double width2 = right - left;
            double height2 = bottom - top;
            if (width2 == 0.0 || height2 == 0.0) {
                return;
            }
            int alpha2 = (int)(((Number)this.alphaState.getUntracked()).floatValue() * (float)255);
            if (alpha2 != 0) {
                buffer = uBufferBuilder = UBufferBuilder.Companion.create(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
                boolean bl = false;
                UIBlock.Companion.drawBlock((UVertexConsumer)buffer, matrixStack, new Color(0, 0, 0, alpha2), left, top, right, bottom);
                UBuiltBuffer uBuiltBuffer = uBufferBuilder.build();
                if (uBuiltBuffer != null) {
                    UBuiltBuffer.drawAndClose$default((UBuiltBuffer)uBuiltBuffer, (URenderPipeline)MULTIPLY_PIPELINE, null, (int)2, null);
                }
            } else {
                this.clear(matrixStack);
            }
            buffer = uBufferBuilder = UBufferBuilder.Companion.create(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE);
            boolean bl = false;
            buffer.pos(matrixStack, x, y + height2, 0.0).tex(0.0, 0.0).endVertex();
            buffer.pos(matrixStack, x + width2, y + height2, 0.0).tex(1.0, 0.0).endVertex();
            buffer.pos(matrixStack, x + width2, y, 0.0).tex(1.0, 1.0).endVertex();
            buffer.pos(matrixStack, x, y, 0.0).tex(0.0, 1.0).endVertex();
            UBuiltBuffer uBuiltBuffer = uBufferBuilder.build();
            if (uBuiltBuffer == null) break block4;
            uBuiltBuffer.drawAndClose(COMPOSITE_PIPELINE, (Function1)new Function1<DrawCallBuilder, Unit>(this){
                final /* synthetic */ AlphaEffect this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull DrawCallBuilder $this$drawAndClose) {
                    Intrinsics.checkNotNullParameter((Object)$this$drawAndClose, (String)"$this$drawAndClose");
                    Resources resources = AlphaEffect.access$getResources$p(this.this$0);
                    if (resources == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
                        resources = null;
                    }
                    $this$drawAndClose.texture(0, resources.getTexture().getGlId());
                }
            });
        }
    }

    public final void cleanup() {
        Resources resources = this.resources;
        if (resources == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
            resources = null;
        }
        resources.close();
    }

    public static final /* synthetic */ Resources access$getResources$p(AlphaEffect $this) {
        return $this.resources;
    }

    static {
        URenderPipeline.Builder builder;
        Companion = new Companion(null);
        URenderPipeline.Builder $this$CLEAR_PIPELINE_u24lambda_u243 = builder = URenderPipeline.Companion.builderWithDefaultShader("elementa:alpha_effect/clear", UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        boolean bl = false;
        $this$CLEAR_PIPELINE_u24lambda_u243.setBlendState(new BlendState(BlendState.Equation.ADD, BlendState.Param.ZERO, BlendState.Param.ZERO, null, null, false, 56, null));
        CLEAR_PIPELINE = builder.build();
        URenderPipeline.Builder $this$MULTIPLY_PIPELINE_u24lambda_u244 = builder = URenderPipeline.Companion.builderWithDefaultShader("elementa:alpha_effect/multiply", UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        boolean bl2 = false;
        $this$MULTIPLY_PIPELINE_u24lambda_u244.setBlendState(new BlendState(BlendState.Equation.ADD, BlendState.Param.ZERO, BlendState.Param.SRC_ALPHA, null, null, false, 56, null));
        MULTIPLY_PIPELINE = builder.build();
        URenderPipeline.Builder $this$COMPOSITE_PIPELINE_u24lambda_u245 = builder = URenderPipeline.Companion.builderWithDefaultShader("elementa:alpha_effect/composite", UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE);
        boolean bl3 = false;
        $this$COMPOSITE_PIPELINE_u24lambda_u245.setBlendState(new BlendState(BlendState.Equation.ADD, BlendState.Param.ONE_MINUS_DST_ALPHA, BlendState.Param.ONE, null, null, false, 56, null));
        COMPOSITE_PIPELINE = builder.build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgg/essential/gui/effects/AlphaEffect$Companion;", "", "()V", "CLEAR_PIPELINE", "Lgg/essential/universal/render/URenderPipeline;", "COMPOSITE_PIPELINE", "MULTIPLY_PIPELINE", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000eB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lgg/essential/gui/effects/AlphaEffect$Resources;", "Ljava/lang/ref/PhantomReference;", "Lgg/essential/gui/effects/AlphaEffect;", "Ljava/io/Closeable;", "effect", "(Lgg/essential/gui/effects/AlphaEffect;)V", "closed", "", "texture", "Lgg/essential/util/image/GpuTexture;", "getTexture", "()Lgg/essential/util/image/GpuTexture;", "close", "", "Companion", "essential-gui-essential"})
    private static final class Resources
    extends PhantomReference<AlphaEffect>
    implements Closeable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final GpuTexture texture;
        private boolean closed;
        @NotNull
        private static final ReferenceQueue<AlphaEffect> referenceQueue = new ReferenceQueue();
        @NotNull
        private static final Set<Resources> toBeCleanedUp;

        public Resources(@NotNull AlphaEffect effect2) {
            Intrinsics.checkNotNullParameter((Object)((Object)effect2), (String)"effect");
            super(effect2, referenceQueue);
            this.texture = GuiEssentialPlatform.Companion.getPlatform().newGpuTexture(1, 1, GpuTexture.Format.RGBA8);
            toBeCleanedUp.add(this);
        }

        @NotNull
        public final GpuTexture getTexture() {
            return this.texture;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            toBeCleanedUp.remove(this);
            this.texture.delete();
        }

        static {
            Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
            Intrinsics.checkNotNullExpressionValue(set2, (String)"newSetFromMap(...)");
            toBeCleanedUp = set2;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lgg/essential/gui/effects/AlphaEffect$Resources$Companion;", "", "()V", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "Lgg/essential/gui/effects/AlphaEffect;", "getReferenceQueue", "()Ljava/lang/ref/ReferenceQueue;", "toBeCleanedUp", "", "Lgg/essential/gui/effects/AlphaEffect$Resources;", "getToBeCleanedUp", "()Ljava/util/Set;", "drainCleanupQueue", "", "essential-gui-essential"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ReferenceQueue<AlphaEffect> getReferenceQueue() {
                return referenceQueue;
            }

            @NotNull
            public final Set<Resources> getToBeCleanedUp() {
                return toBeCleanedUp;
            }

            public final void drainCleanupQueue() {
                while (true) {
                    Reference<AlphaEffect> reference = this.getReferenceQueue().poll();
                    if (reference == null) break;
                    ((Resources)reference).close();
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

