/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.state.v2.impl.minimal;

import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.ObserverImpl;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.impl.minimal.Node;
import gg.essential.gui.elementa.state.v2.impl.minimal.NodeKind;
import gg.essential.gui.elementa.state.v2.impl.minimal.NodeState;
import gg.essential.gui.elementa.state.v2.impl.minimal.Update;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\u00020\u0004:\u00015B8\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\b\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\rJ\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020$H\u0002J\u0013\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00020\u0003\u00a2\u0006\u0002\u0010(J\r\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\bH\u0002J\u0010\u0010/\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0002J\u0013\u00101\u001a\u00020$2\u0006\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J\u000e\u0010,\u001a\u00020$2\u0006\u0010,\u001a\u00020-J\u0011\u00104\u001a\u00028\u0000*\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010(R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u001f\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0000\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"\u00a8\u00066"}, d2={"Lgg/essential/gui/elementa/state/v2/impl/minimal/Node;", "T", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/elementa/state/v2/Observer;", "Lgg/essential/gui/elementa/state/v2/ObserverImpl;", "kind", "Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeKind;", "state", "Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeState;", "func", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "value", "(Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeKind;Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeState;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;)V", "allDependencies", "", "Lgg/essential/gui/elementa/state/v2/impl/minimal/Node$Edge;", "allDependents", "dependencies", "Lkotlin/sequences/Sequence;", "getDependencies", "()Lkotlin/sequences/Sequence;", "dependents", "getDependents", "getKind", "()Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeKind;", "observerImpl", "getObserverImpl", "()Lgg/essential/gui/elementa/state/v2/ObserverImpl;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "getReferenceQueue", "()Ljava/lang/ref/ReferenceQueue;", "referenceQueueField", "Ljava/lang/Object;", "cleanup", "", "cleanupStaleReferences", "getTracked", "observer", "(Lgg/essential/gui/elementa/state/v2/Observer;)Ljava/lang/Object;", "getUntracked", "()Ljava/lang/Object;", "mark", "update", "Lgg/essential/gui/elementa/state/v2/impl/minimal/Update;", "newState", "markDirty", "markToBeChecked", "set", "newValue", "(Ljava/lang/Object;)V", "get", "Edge", "essential-elementa-statev2"})
@SourceDebugExtension(value={"SMAP\nimpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 impl.kt\ngg/essential/gui/elementa/state/v2/impl/minimal/Node\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,377:1\n1#2:378\n*E\n"})
final class Node<T>
implements State<T>,
Observer,
ObserverImpl {
    @NotNull
    private final NodeKind kind;
    @NotNull
    private NodeState state;
    @NotNull
    private final Function1<Observer, T> func;
    @Nullable
    private T value;
    @NotNull
    private final List<Edge> allDependencies;
    @NotNull
    private final List<Edge> allDependents;
    @Nullable
    private ReferenceQueue<Node<?>> referenceQueueField;

    public Node(@NotNull NodeKind kind, @NotNull NodeState state2, @NotNull Function1<? super Observer, ? extends T> func, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        this.kind = kind;
        this.state = state2;
        this.func = func;
        this.value = value;
        this.allDependencies = new ArrayList();
        this.allDependents = new ArrayList();
    }

    @NotNull
    public final NodeKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public ObserverImpl getObserverImpl() {
        return this;
    }

    private final Sequence<Node<?>> getDependencies() {
        return SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)this.allDependencies), (Function1)dependencies.1.INSTANCE), (Function1)dependencies.2.INSTANCE);
    }

    private final Sequence<Node<?>> getDependents() {
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)this.allDependents), (Function1)dependents.1.INSTANCE), (Function1)dependents.2.INSTANCE);
    }

    @Override
    public T get(@NotNull Observer $this$get) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        return this.getTracked($this$get);
    }

    public final T getTracked(@NotNull Observer observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        ObserverImpl impl = observer.getObserverImpl();
        if (!(impl instanceof Node)) {
            return this.getUntracked();
        }
        if (((Node)impl).state == NodeState.Dead) {
            return this.getUntracked();
        }
        T value = this.getUntracked();
        Node dependency = this;
        ObserverImpl dependent = impl;
        List<Edge> listA = dependency.allDependents;
        List<Edge> listB = ((Node)dependent).allDependencies;
        for (Edge edge : listA.size() < listB.size() ? listA : listB) {
            if (!Intrinsics.areEqual(edge.getDependency(), (Object)dependency) || !Intrinsics.areEqual(edge.getDependent(), (Object)dependent)) continue;
            edge.setSuspended(false);
            return value;
        }
        Edge edge = new Edge(dependency, (Node)dependent, false, 4, null);
        dependency.allDependents.add(edge);
        ((Node)dependent).allDependencies.add(edge);
        this.cleanupStaleReferences();
        return value;
    }

    @Override
    public T getUntracked() {
        if (this.state != NodeState.Clean) {
            this.update(Update.Companion.get());
        }
        return this.value;
    }

    public final void set(T newValue) {
        boolean bl;
        boolean bl2 = bl = this.kind == NodeKind.Mutable;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (Intrinsics.areEqual(this.value, newValue)) {
            return;
        }
        this.value = newValue;
        Update update2 = Update.Companion.get();
        for (Node dep : this.getDependents()) {
            dep.markDirty(update2);
        }
        update2.flush();
    }

    private final void mark(Update update2, NodeState newState) {
        NodeState oldState = this.state;
        if (oldState.ordinal() >= newState.ordinal()) {
            return;
        }
        if (this.kind == NodeKind.Effect && oldState == NodeState.Clean) {
            update2.queueNode(this);
        }
        this.state = newState;
    }

    private final void markDirty(Update update2) {
        this.mark(update2, NodeState.Dirty);
        for (Node dep : this.getDependents()) {
            dep.markToBeChecked(update2);
        }
    }

    private final void markToBeChecked(Update update2) {
        if (this.state != NodeState.Clean) {
            return;
        }
        this.mark(update2, NodeState.ToBeChecked);
        for (Node dep : this.getDependents()) {
            dep.markToBeChecked(update2);
        }
    }

    public final void update(@NotNull Update update2) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        if (this.state == NodeState.Clean) {
            return;
        }
        if (this.state == NodeState.ToBeChecked) {
            for (Object dep : this.getDependencies()) {
                ((Node)dep).update(update2);
                if (this.state != NodeState.Dirty) continue;
            }
        }
        boolean wasDirty = this.state == NodeState.Dirty;
        this.state = NodeState.Clean;
        if (wasDirty) {
            for (Edge edge : this.allDependencies) {
                edge.setSuspended(true);
            }
            Object newValue = this.func.invoke((Object)this);
            if (this.state == NodeState.Dead) {
                return;
            }
            this.allDependencies.removeIf(arg_0 -> Node.update$lambda$0(update.1.INSTANCE, arg_0));
            if (!Intrinsics.areEqual(this.value, (Object)newValue)) {
                this.value = newValue;
                for (Node dep : this.getDependents()) {
                    dep.mark(update2, NodeState.Dirty);
                }
            }
        }
    }

    public final void cleanup() {
        boolean bl;
        boolean bl2 = bl = this.kind == NodeKind.Effect;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = this.allDependents.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        for (Edge edge : this.allDependencies) {
            edge.getDependency().allDependents.remove(edge);
        }
        this.allDependencies.clear();
        this.state = NodeState.Dead;
    }

    private final ReferenceQueue<Node<?>> getReferenceQueue() {
        ReferenceQueue<Node<Object>> referenceQueue = this.referenceQueueField;
        if (referenceQueue == null) {
            ReferenceQueue referenceQueue2;
            ReferenceQueue it = referenceQueue2 = new ReferenceQueue();
            boolean bl = false;
            this.referenceQueueField = it;
            referenceQueue = referenceQueue2;
        }
        return referenceQueue;
    }

    private final void cleanupStaleReferences() {
        ReferenceQueue<Node<?>> referenceQueue = this.referenceQueueField;
        if (referenceQueue == null) {
            return;
        }
        ReferenceQueue<Node<?>> queue = referenceQueue;
        if (queue.poll() == null) {
            return;
        }
        while (queue.poll() != null) {
        }
        this.allDependents.removeIf(arg_0 -> Node.cleanupStaleReferences$lambda$2(cleanupStaleReferences.1.INSTANCE, arg_0));
    }

    private static final boolean update$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanupStaleReferences$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getAllDependents$p(Node $this) {
        return $this.allDependents;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B'\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lgg/essential/gui/elementa/state/v2/impl/minimal/Node$Edge;", "Ljava/lang/ref/WeakReference;", "Lgg/essential/gui/elementa/state/v2/impl/minimal/Node;", "dependency", "dependent", "suspended", "", "(Lgg/essential/gui/elementa/state/v2/impl/minimal/Node;Lgg/essential/gui/elementa/state/v2/impl/minimal/Node;Z)V", "getDependency", "()Lgg/essential/gui/elementa/state/v2/impl/minimal/Node;", "getDependent", "getSuspended", "()Z", "setSuspended", "(Z)V", "essential-elementa-statev2"})
    public static final class Edge
    extends WeakReference<Node<?>> {
        @NotNull
        private final Node<?> dependency;
        private boolean suspended;

        public Edge(@NotNull Node<?> dependency, @NotNull Node<?> dependent, boolean suspended) {
            Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter(dependent, (String)"dependent");
            super(dependent, ((Node)dependency).getReferenceQueue());
            this.dependency = dependency;
            this.suspended = suspended;
        }

        public /* synthetic */ Edge(Node node, Node node2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(node, node2, bl);
        }

        @NotNull
        public final Node<?> getDependency() {
            return this.dependency;
        }

        public final boolean getSuspended() {
            return this.suspended;
        }

        public final void setSuspended(boolean bl) {
            this.suspended = bl;
        }

        @Nullable
        public final Node<?> getDependent() {
            return (Node)this.get();
        }
    }
}

