/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.friends.message.v2;

import com.sparkuniverse.toolbox.chat.enums.ChannelType;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.utils.ObservableList;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.FadeEffect;
import gg.essential.gui.elementa.state.v2.DelegatingState;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.elementa.state.v2.combinators.BooleansKt;
import gg.essential.gui.friends.message.v2.ClientMessage;
import gg.essential.gui.friends.message.v2.MessageLine;
import gg.essential.gui.friends.message.v2.MessengerElement;
import gg.essential.gui.friends.message.v2.SendState;
import gg.essential.util.USession;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H&J\b\u0010.\u001a\u00020+H&J\b\u0010/\u001a\u00020+H&J\u0018\u00100\u001a\u00020+2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020-H&J\u0006\u00104\u001a\u00020\u0007J\b\u00105\u001a\u00020+H&R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0016\u00a8\u00066"}, d2={"Lgg/essential/gui/friends/message/v2/MessageWrapper;", "Lgg/essential/gui/friends/message/v2/MessengerElement;", "message", "Lgg/essential/gui/friends/message/v2/ClientMessage;", "(Lgg/essential/gui/friends/message/v2/ClientMessage;)V", "actionButtonHovered", "Lgg/essential/gui/elementa/state/v2/DelegatingState;", "", "getActionButtonHovered", "()Lgg/essential/gui/elementa/state/v2/DelegatingState;", "appearHovered", "Lgg/essential/gui/elementa/state/v2/State;", "getAppearHovered", "()Lgg/essential/gui/elementa/state/v2/State;", "channelType", "Lcom/sparkuniverse/toolbox/chat/enums/ChannelType;", "Lorg/jetbrains/annotations/NotNull;", "getChannelType", "()Lcom/sparkuniverse/toolbox/chat/enums/ChannelType;", "dropdownOpen", "Lgg/essential/gui/elementa/state/v2/MutableState;", "getDropdownOpen", "()Lgg/essential/gui/elementa/state/v2/MutableState;", "getMessage", "()Lgg/essential/gui/friends/message/v2/ClientMessage;", "sendTime", "Ljava/time/Instant;", "getSendTime", "()Ljava/time/Instant;", "sender", "Ljava/util/UUID;", "getSender", "()Ljava/util/UUID;", "sendingMessageAlpha", "", "getSendingMessageAlpha", "()F", "sentByClient", "getSentByClient", "()Z", "showTimestamp", "getShowTimestamp", "addComponent", "", "line", "Lgg/essential/gui/friends/message/v2/MessageLine;", "delete", "flashHighlight", "openOptionMenu", "event", "Lgg/essential/elementa/events/UIClickEvent;", "component", "previousSiblingIsSameSenderWithinAMinute", "retrySend", "essential-gui-essential"})
public abstract class MessageWrapper
extends MessengerElement {
    @NotNull
    private final ClientMessage message;
    @NotNull
    private final MutableState<Boolean> showTimestamp;
    @NotNull
    private final UUID sender;
    private final boolean sentByClient;
    @NotNull
    private final Instant sendTime;
    @NotNull
    private final ChannelType channelType;
    private final float sendingMessageAlpha;
    @NotNull
    private final MutableState<Boolean> dropdownOpen;
    @NotNull
    private final DelegatingState<Boolean> actionButtonHovered;
    @NotNull
    private final State<Boolean> appearHovered;

    public MessageWrapper(@NotNull ClientMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        super(null);
        this.message = message2;
        this.showTimestamp = StateKt.mutableStateOf(true);
        this.sender = this.message.getSender();
        this.sentByClient = Intrinsics.areEqual((Object)this.sender, (Object)USession.Companion.activeNow().getUuid());
        this.sendTime = this.message.getSendTime();
        ChannelType channelType = this.message.getChannel().getType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)channelType), (String)"getType(...)");
        this.channelType = channelType;
        this.sendingMessageAlpha = 0.7f;
        this.dropdownOpen = StateKt.mutableStateOf(false);
        this.actionButtonHovered = StateKt.stateDelegatingTo((State)StateKt.mutableStateOf(false));
        this.appearHovered = BooleansKt.or((State<Boolean>)this.actionButtonHovered, (State<Boolean>)this.dropdownOpen);
        if (Intrinsics.areEqual((Object)this.message.getSendState(), (Object)SendState.Sending.INSTANCE)) {
            ComponentsKt.effect((UIComponent)((UIComponent)this), (Effect)new FadeEffect(EssentialPalette.GUI_BACKGROUND, this.sendingMessageAlpha));
        }
    }

    @NotNull
    public final ClientMessage getMessage() {
        return this.message;
    }

    @NotNull
    public final MutableState<Boolean> getShowTimestamp() {
        return this.showTimestamp;
    }

    @NotNull
    public final UUID getSender() {
        return this.sender;
    }

    public final boolean getSentByClient() {
        return this.sentByClient;
    }

    @NotNull
    public final Instant getSendTime() {
        return this.sendTime;
    }

    @NotNull
    public final ChannelType getChannelType() {
        return this.channelType;
    }

    public final float getSendingMessageAlpha() {
        return this.sendingMessageAlpha;
    }

    @NotNull
    protected final MutableState<Boolean> getDropdownOpen() {
        return this.dropdownOpen;
    }

    @NotNull
    protected final DelegatingState<Boolean> getActionButtonHovered() {
        return this.actionButtonHovered;
    }

    @NotNull
    public final State<Boolean> getAppearHovered() {
        return this.appearHovered;
    }

    public abstract void delete();

    public abstract void addComponent(@NotNull MessageLine var1);

    public final boolean previousSiblingIsSameSenderWithinAMinute() {
        ObservableList siblings = this.getParent().getChildren();
        long minute = TimeUnit.MINUTES.toMillis(1L);
        int indexInParent = siblings.indexOf((Object)this) - 1;
        boolean bl = 0 <= indexInParent ? indexInParent < siblings.size() : false;
        if (bl) {
            UIComponent comp = (UIComponent)siblings.get(indexInParent);
            return comp instanceof MessageWrapper && Intrinsics.areEqual((Object)((MessageWrapper)comp).message.getSender(), (Object)this.message.getSender()) && this.message.getSendTime().toEpochMilli() - ((MessageWrapper)comp).message.getSendTime().toEpochMilli() <= minute;
        }
        return false;
    }

    public abstract void openOptionMenu(@NotNull UIClickEvent var1, @NotNull MessageLine var2);

    public abstract void flashHighlight();

    public abstract void retrySend();
}

