/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot;

import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.ScreenshotIdKt;
import gg.essential.media.model.Media;
import gg.essential.media.model.MediaVariant;
import gg.essential.util.HttpUtils;
import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lgg/essential/gui/screenshot/RemoteScreenshot;", "Lgg/essential/gui/screenshot/ScreenshotId;", "media", "Lgg/essential/media/model/Media;", "(Lgg/essential/media/model/Media;)V", "getMedia", "()Lgg/essential/media/model/Media;", "name", "", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "open", "Ljava/io/InputStream;", "toString", "essential-gui-essential"})
public final class RemoteScreenshot
implements ScreenshotId {
    @NotNull
    private final Media media;

    public RemoteScreenshot(@NotNull Media media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        this.media = media;
    }

    @NotNull
    public final Media getMedia() {
        return this.media;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ScreenshotIdKt.getSCREENSHOT_DATETIME_FORMAT().format(this.media.getCreatedAt());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @Override
    @NotNull
    public InputStream open() {
        Map<String, MediaVariant> map2 = this.media.getVariants();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getVariants(...)");
        String string = ((MediaVariant)MapsKt.getValue(map2, (Object)"original")).getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        return HttpUtils.httpGetToInputStreamBlocking$default(string, null, 2, null);
    }

    public int hashCode() {
        return this.media.getId().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type gg.essential.gui.screenshot.RemoteScreenshot");
        RemoteScreenshot cfr_ignored_0 = (RemoteScreenshot)other;
        return Intrinsics.areEqual((Object)this.media.getId(), (Object)((RemoteScreenshot)other).media.getId());
    }

    @NotNull
    public final Media component1() {
        return this.media;
    }

    @NotNull
    public final RemoteScreenshot copy(@NotNull Media media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        return new RemoteScreenshot(media);
    }

    public static /* synthetic */ RemoteScreenshot copy$default(RemoteScreenshot remoteScreenshot, Media media, int n, Object object) {
        if ((n & 1) != 0) {
            media = remoteScreenshot.media;
        }
        return remoteScreenshot.copy(media);
    }

    @NotNull
    public String toString() {
        return "RemoteScreenshot(media=" + this.media + ')';
    }
}

