/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.image;

import gg.essential.clipboard.AWTClipboard;
import gg.essential.clipboard.Clipboard;
import gg.essential.gui.screenshot.image.ForkedImageClipboard;
import gg.essential.util.ForkedJvm;
import gg.essential.util.OperatingSystem;
import gg.essential.util.OperatingSystemKt;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgg/essential/gui/screenshot/image/ForkedImageClipboard;", "Ljava/lang/AutoCloseable;", "()V", "inputStream", "Ljava/io/DataInputStream;", "jvm", "Lgg/essential/util/ForkedJvm;", "close", "", "copy", "", "file", "Ljava/io/File;", "Companion", "essential-gui-essential"})
public final class ForkedImageClipboard
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ForkedJvm jvm;
    @NotNull
    private final DataInputStream inputStream;
    @NotNull
    private static final Lazy<Path> extractedClipboardJar$delegate = LazyKt.lazy((Function0)Companion.extractedClipboardJar.2.INSTANCE);

    public ForkedImageClipboard() {
        String string = ForkedImageClipboard.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.jvm = new ForkedJvm(string, ForkedImageClipboard.Companion.classpath(), null, 4, null);
        this.inputStream = new DataInputStream(this.jvm.getProcess().getInputStream());
    }

    @Override
    public void close() {
        if (OperatingSystemKt.getOs() != OperatingSystem.LINUX) {
            this.jvm.close();
        }
    }

    public final boolean copy(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OutputStream outputStream = this.jvm.getProcess().getOutputStream();
        String string = file.getAbsoluteFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        outputStream.write(StringsKt.encodeToByteArray((String)string));
        this.jvm.getProcess().getOutputStream().flush();
        this.jvm.getProcess().getOutputStream().close();
        return this.inputStream.read() == 1;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u001b\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lgg/essential/gui/screenshot/image/ForkedImageClipboard$Companion;", "", "()V", "extractedClipboardJar", "Ljava/nio/file/Path;", "getExtractedClipboardJar", "()Ljava/nio/file/Path;", "extractedClipboardJar$delegate", "Lkotlin/Lazy;", "classpath", "", "main", "", "args", "", "([Ljava/lang/String;)V", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getExtractedClipboardJar() {
            Lazy lazy2 = extractedClipboardJar$delegate;
            Object object = lazy2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Path)object;
        }

        private final String classpath() {
            return this.getExtractedClipboardJar() + System.getProperty("path.separator") + ForkedJvm.Companion.defaultClassPath(new Class[0]);
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"in");
            File file = new File(StringsKt.decodeToString((byte[])ByteStreamsKt.readBytes((InputStream)inputStream)));
            if (!file.exists()) {
                System.out.write(0);
                System.out.close();
                return;
            }
            Clipboard clipboard = Clipboard.Companion.current();
            boolean success = clipboard.copyPNG(file);
            System.out.write(success ? 1 : 0);
            System.out.close();
            if (OperatingSystemKt.getOs() == OperatingSystem.LINUX && clipboard instanceof AWTClipboard) {
                ((AWTClipboard)clipboard).getLostOwnership().acquire();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

