/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers.screenshot;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ/\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lgg/essential/handlers/screenshot/ScreenshotUploadUtil;", "", "<init>", "()V", "Ljava/io/PrintWriter;", "body", "", "boundary", "", "addCloseDelimiter", "(Ljava/io/PrintWriter;Ljava/lang/String;)V", "", "byteStream", "Ljava/io/OutputStream;", "directOutput", "addFileData", "([BLjava/io/PrintWriter;Ljava/io/OutputStream;Ljava/lang/String;)V", "url", "fileData", "", "httpUpload", "(Ljava/lang/String;[B)Z", "CRLF", "Ljava/lang/String;", "Essential 1.21.9-fabric"})
public final class ScreenshotUploadUtil {
    @NotNull
    public static final ScreenshotUploadUtil INSTANCE = new ScreenshotUploadUtil();
    @NotNull
    private static final String CRLF = "\r\n";

    private ScreenshotUploadUtil() {
    }

    public final boolean httpUpload(@NotNull String url, @NotNull byte[] fileData) throws MalformedURLException, IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        URLConnection uRLConnection = new URL(url).openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        String string = Long.toString(System.currentTimeMillis(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String boundary = "---------------" + string;
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(true);
        connection.setRequestMethod("POST");
        connection.addRequestProperty("User-Agent", "Essential");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        OutputStream directOutput = connection.getOutputStream();
        Intrinsics.checkNotNull((Object)directOutput);
        OutputStream outputStream = directOutput;
        Charset charset = Charsets.UTF_8;
        PrintWriter body = new PrintWriter((Writer)new OutputStreamWriter(outputStream, charset), true);
        body.append(CRLF);
        this.addFileData(fileData, body, directOutput, boundary);
        this.addCloseDelimiter(body, boundary);
        return connection.getResponseCode() / 100 == 2;
    }

    private final void addFileData(byte[] byteStream, PrintWriter body, OutputStream directOutput, String boundary) throws IOException {
        body.append("--").append(boundary).append(CRLF);
        body.append("Content-Disposition: form-data; name=\"file\"; filename=\"file\"").append(CRLF);
        body.append("Content-Type: image/png").append(CRLF);
        body.append("Content-Transfer-Encoding: binary").append(CRLF);
        body.append(CRLF);
        body.flush();
        directOutput.write(byteStream);
        directOutput.flush();
        body.append(CRLF);
        body.flush();
    }

    private final void addCloseDelimiter(PrintWriter body, String boundary) {
        body.append("--").append(boundary).append("--").append(CRLF);
        body.flush();
    }
}

