/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.ice;

import gg.essential.ice.CandidateType;
import gg.essential.ice.LocalCandidate;
import gg.essential.ice.stun.StunSocket;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001c\u001a\u00020\u000eH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lgg/essential/ice/LocalCandidateImpl;", "Lgg/essential/ice/LocalCandidate;", "type", "Lgg/essential/ice/CandidateType;", "socket", "Lgg/essential/ice/stun/StunSocket;", "relay", "Lgg/essential/ice/stun/StunSocket$RelayAllocation;", "address", "Ljava/net/InetSocketAddress;", "preference", "", "onClose", "Lkotlin/Function0;", "", "(Lgg/essential/ice/CandidateType;Lgg/essential/ice/stun/StunSocket;Lgg/essential/ice/stun/StunSocket$RelayAllocation;Ljava/net/InetSocketAddress;ILkotlin/jvm/functions/Function0;)V", "getAddress", "()Ljava/net/InetSocketAddress;", "base", "getBase", "getPreference", "()I", "getRelay", "()Lgg/essential/ice/stun/StunSocket$RelayAllocation;", "getSocket", "()Lgg/essential/ice/stun/StunSocket;", "getType", "()Lgg/essential/ice/CandidateType;", "close", "send", "", "packet", "Ljava/net/DatagramPacket;", "(Ljava/net/DatagramPacket;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendUnchecked", "toString", "", "ice"})
public class LocalCandidateImpl
implements LocalCandidate {
    @NotNull
    private final CandidateType type;
    @NotNull
    private final StunSocket socket;
    @Nullable
    private final StunSocket.RelayAllocation relay;
    @NotNull
    private final InetSocketAddress address;
    private final int preference;
    @NotNull
    private final Function0<Unit> onClose;
    @NotNull
    private final InetSocketAddress base;

    public LocalCandidateImpl(@NotNull CandidateType type, @NotNull StunSocket socket, @Nullable StunSocket.RelayAllocation relay, @NotNull InetSocketAddress address, int preference, @NotNull Function0<Unit> onClose) {
        InetSocketAddress inetSocketAddress;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
        this.type = type;
        this.socket = socket;
        this.relay = relay;
        this.address = address;
        this.preference = preference;
        this.onClose = onClose;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: 
            case 2: {
                inetSocketAddress = this.address;
                break;
            }
            case 3: 
            case 4: {
                inetSocketAddress = this.socket.getHostAddress();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.base = inetSocketAddress;
    }

    @Override
    @NotNull
    public final CandidateType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public final StunSocket getSocket() {
        return this.socket;
    }

    @Override
    @Nullable
    public final StunSocket.RelayAllocation getRelay() {
        return this.relay;
    }

    @Override
    @NotNull
    public final InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public final int getPreference() {
        return this.preference;
    }

    @Override
    @NotNull
    public InetSocketAddress getBase() {
        return this.base;
    }

    @NotNull
    public String toString() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                string = String.valueOf(this.address);
                break;
            }
            case 3: {
                string = this.address + " (peer-reflexive for " + this.socket.getHostAddress() + ')';
                break;
            }
            case 4: {
                string = this.address + " (server-reflexive for " + this.socket.getHostAddress() + ')';
                break;
            }
            case 2: {
                string = this.address + " (relayed for " + this.socket.getHostAddress() + ')';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @Nullable
    public Object send(@NotNull DatagramPacket packet2, @NotNull Continuation<? super Boolean> $completion) {
        return LocalCandidateImpl.send$suspendImpl(this, packet2, $completion);
    }

    static /* synthetic */ Object send$suspendImpl(LocalCandidateImpl $this, DatagramPacket packet2, Continuation<? super Boolean> $completion) {
        if ($this.relay != null) {
            $this.relay.getSendChannel().trySend-JP2dKIU((Object)packet2);
            return Boxing.boxBoolean((boolean)true);
        }
        return $this.socket.send(packet2, $completion);
    }

    @Override
    public void sendUnchecked(@NotNull DatagramPacket packet2) {
        Intrinsics.checkNotNullParameter((Object)packet2, (String)"packet");
        if (this.relay != null) {
            this.relay.getSendChannel().trySend-JP2dKIU((Object)packet2);
        } else {
            this.socket.sendUnchecked(packet2);
        }
    }

    @Override
    public void close() {
        this.onClose.invoke();
    }

    @Override
    public int getPriority() {
        return LocalCandidate.DefaultImpls.getPriority(this);
    }

    @Override
    public boolean isRelay() {
        return LocalCandidate.DefaultImpls.isRelay(this);
    }

    @Override
    public boolean isIPv6() {
        return LocalCandidate.DefaultImpls.isIPv6(this);
    }

    @Override
    public boolean isLinkLocal() {
        return LocalCandidate.DefaultImpls.isLinkLocal(this);
    }

    @Override
    public boolean isSiteLocal() {
        return LocalCandidate.DefaultImpls.isSiteLocal(this);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CandidateType.values().length];
            try {
                nArray[CandidateType.Host.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateType.Relayed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateType.PeerReflexive.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateType.ServerReflexive.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

