/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.image.imagescaling;

import java.awt.Dimension;

public class DimensionConstrain {
    protected DimensionConstrain() {
    }

    public Dimension getDimension(Dimension dimension) {
        return dimension;
    }

    public DimensionConstrain coerceAtLeast(final int min) {
        return new DimensionConstrain(){

            @Override
            public Dimension getDimension(Dimension dimension) {
                Dimension dim = DimensionConstrain.this.getDimension(dimension);
                return new Dimension(Math.max(dim.width, min), Math.max(dim.height, min));
            }
        };
    }

    public static DimensionConstrain createAbsolutionDimension(final int width2, final int height2) {
        assert (width2 > 0 && height2 > 0) : "Dimension must be a positive integer";
        return new DimensionConstrain(){

            @Override
            public Dimension getDimension(Dimension dimension) {
                return new Dimension(width2, height2);
            }
        };
    }

    public static DimensionConstrain createMaxDimension(int width2, int height2) {
        return DimensionConstrain.createMaxDimension(width2, height2, false);
    }

    public static DimensionConstrain createMaxDimension(final int width2, final int height2, final boolean neverEnlargeImage) {
        assert (width2 > 0 && height2 > 0) : "Dimension must be larger that 0";
        final double scaleFactor = (double)width2 / (double)height2;
        return new DimensionConstrain(){

            @Override
            public Dimension getDimension(Dimension dimension) {
                double srcScaleFactor = (double)dimension.width / (double)dimension.height;
                double scale2 = srcScaleFactor > scaleFactor ? (double)width2 / (double)dimension.width : (double)height2 / (double)dimension.height;
                if (neverEnlargeImage) {
                    scale2 = Math.min(scale2, 1.0);
                }
                int dstWidth = (int)Math.round((double)dimension.width * scale2);
                int dstHeight = (int)Math.round((double)dimension.height * scale2);
                return new Dimension(dstWidth, dstHeight);
            }
        };
    }
}

