/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.pseudotcp.util;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public class ByteFifoBuffer {
    private byte[] array;
    private int write_pos = 0;
    private int buffered = 0;
    private int read_pos = 0;

    public ByteFifoBuffer(int len) {
        this.array = new byte[len];
    }

    public int length() {
        return this.array.length;
    }

    public int read(byte[] out_buffer, int count) {
        return this.read(out_buffer, 0, count);
    }

    public int read(byte[] out_buffer, int buff_offset, int count) {
        if ((count = this.readLimit(count)) > 0) {
            ByteFifoBuffer.readOp(out_buffer, buff_offset, count, this.array, this.read_pos, this.array.length);
            this.read_pos = (this.read_pos + count) % this.array.length;
            this.buffered -= count;
        }
        return count;
    }

    private int readLimit(int desiredReadCount) {
        return desiredReadCount > this.buffered ? this.buffered : desiredReadCount;
    }

    private static void readOp(byte[] outBuffer, int dst_buff_offset, int count, byte[] srcBuffer, int read_pos, int buff_len) {
        if (read_pos + count <= buff_len) {
            System.arraycopy(srcBuffer, read_pos, outBuffer, dst_buff_offset, count);
        } else {
            int tillEndCount = buff_len - read_pos;
            System.arraycopy(srcBuffer, read_pos, outBuffer, dst_buff_offset, tillEndCount);
            int fromStartCount = count - tillEndCount;
            System.arraycopy(srcBuffer, 0, outBuffer, dst_buff_offset + tillEndCount, fromStartCount);
        }
    }

    public int getWriteRemaining() {
        return this.array.length - this.buffered;
    }

    public int getBuffered() {
        return this.buffered;
    }

    public int write(byte[] buffer, int count) {
        return this.write(buffer, 0, count);
    }

    public int write(byte[] data, int offset, int count) {
        count = this.writeLimit(count);
        ByteFifoBuffer.writeOp(data, offset, count, this.array, this.write_pos, this.array.length);
        this.write_pos = (this.write_pos + count) % this.array.length;
        this.buffered += count;
        return count;
    }

    private static void writeOp(byte[] inBuffer, int inOffset, int count, byte[] outBuffer, int write_pos, int buff_len) {
        if (write_pos + count <= buff_len) {
            System.arraycopy(inBuffer, inOffset, outBuffer, write_pos, count);
        } else {
            int tillEndCount = buff_len - write_pos;
            int fromStartCount = count - tillEndCount;
            System.arraycopy(inBuffer, inOffset, outBuffer, write_pos, tillEndCount);
            System.arraycopy(inBuffer, inOffset + tillEndCount, outBuffer, 0, fromStartCount);
        }
    }

    private int writeLimit(int desiredWriteCount) {
        return desiredWriteCount > this.array.length - this.buffered ? this.array.length - this.buffered : desiredWriteCount;
    }

    private void assertWriteLimit(int newWrPos) throws IllegalArgumentException {
        int availSpace;
        int spaceReq = newWrPos < this.write_pos ? newWrPos + (this.array.length - this.write_pos) : newWrPos - this.write_pos;
        if (spaceReq > (availSpace = this.getWriteRemaining())) {
            throw new IllegalArgumentException();
        }
    }

    public void consumeWriteBuffer(int count) throws IllegalArgumentException, BufferOverflowException {
        if (count > this.getWriteRemaining()) {
            throw new BufferOverflowException();
        }
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        int newPos = (this.write_pos + count) % this.array.length;
        this.assertWriteLimit(newPos);
        this.write_pos = newPos;
        this.buffered += count;
    }

    public boolean setCapacity(int new_size) {
        if (new_size < this.getBuffered()) {
            return false;
        }
        byte[] newBuff = new byte[new_size];
        ByteFifoBuffer.readOp(newBuff, 0, this.buffered, this.array, this.read_pos, this.array.length);
        this.array = newBuff;
        return true;
    }

    public void consumeReadData(int count) throws IllegalArgumentException, BufferUnderflowException {
        if (count > this.buffered) {
            throw new BufferUnderflowException();
        }
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        this.read_pos = (this.read_pos + count) % this.array.length;
        this.buffered -= count;
    }

    public int readOffset(byte[] dst_buff, int dst_buff_offset, int count, int offset) {
        int read_offset = (this.read_pos + offset) % this.array.length;
        ByteFifoBuffer.readOp(dst_buff, dst_buff_offset, count, this.array, read_offset, this.array.length);
        return count;
    }

    public int writeOffset(byte[] data, int count, int nOffset) throws BufferOverflowException {
        if (count > this.getWriteRemaining()) {
            throw new BufferOverflowException();
        }
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        int offWritePos = (this.write_pos + nOffset) % this.array.length;
        count = this.writeLimit(count);
        this.assertWriteLimit(offWritePos + count);
        ByteFifoBuffer.writeOp(data, 0, count, this.array, offWritePos, this.array.length);
        return count;
    }

    public void resetReadPosition() {
        this.read_pos = 0;
    }

    public void resetWritePosition() {
        this.write_pos = 0;
        this.buffered = 0;
    }
}

