/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3;

import gg.essential.lib.okhttp3.internal.Util;
import gg.essential.lib.okhttp3.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;

public final class Headers {
    private final String[] namesAndValues;

    Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] namesAndValues) {
        this.namesAndValues = namesAndValues;
    }

    @Nullable
    public String get(String name2) {
        return Headers.get(this.namesAndValues, name2);
    }

    @Nullable
    public Date getDate(String name2) {
        String value = this.get(name2);
        return value != null ? HttpDate.parse(value) : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int index2) {
        return this.namesAndValues[index2 * 2];
    }

    public String value(int index2) {
        return this.namesAndValues[index2 * 2 + 1];
    }

    public Set<String> names() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int size = this.size();
        for (int i2 = 0; i2 < size; ++i2) {
            result.add(this.name(i2));
        }
        return Collections.unmodifiableSet(result);
    }

    public List<String> values(String name2) {
        ArrayList<String> result = null;
        int size = this.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!name2.equalsIgnoreCase(this.name(i2))) continue;
            if (result == null) {
                result = new ArrayList<String>(2);
            }
            result.add(this.value(i2));
        }
        return result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
    }

    public long byteCount() {
        long result = this.namesAndValues.length * 2;
        int size = this.namesAndValues.length;
        for (int i2 = 0; i2 < size; ++i2) {
            result += (long)this.namesAndValues[i2].length();
        }
        return result;
    }

    public Builder newBuilder() {
        Builder result = new Builder();
        Collections.addAll(result.namesAndValues, this.namesAndValues);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Headers && Arrays.equals(((Headers)other).namesAndValues, this.namesAndValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int size = this.size();
        for (int i2 = 0; i2 < size; ++i2) {
            result.append(this.name(i2)).append(": ").append(this.value(i2)).append("\n");
        }
        return result.toString();
    }

    public Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int size = this.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String name2 = this.name(i2).toLowerCase(Locale.US);
            ArrayList<String> values = (ArrayList<String>)result.get(name2);
            if (values == null) {
                values = new ArrayList<String>(2);
                result.put(name2, values);
            }
            values.add(this.value(i2));
        }
        return result;
    }

    private static String get(String[] namesAndValues, String name2) {
        for (int i2 = namesAndValues.length - 2; i2 >= 0; i2 -= 2) {
            if (!name2.equalsIgnoreCase(namesAndValues[i2])) continue;
            return namesAndValues[i2 + 1];
        }
        return null;
    }

    public static Headers of(String ... namesAndValues) {
        int i2;
        if (namesAndValues == null) {
            throw new NullPointerException("namesAndValues == null");
        }
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        namesAndValues = (String[])namesAndValues.clone();
        for (i2 = 0; i2 < namesAndValues.length; ++i2) {
            if (namesAndValues[i2] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            namesAndValues[i2] = namesAndValues[i2].trim();
        }
        for (i2 = 0; i2 < namesAndValues.length; i2 += 2) {
            String name2 = namesAndValues[i2];
            String value = namesAndValues[i2 + 1];
            if (name2.length() != 0 && name2.indexOf(0) == -1 && value.indexOf(0) == -1) continue;
            throw new IllegalArgumentException("Unexpected header: " + name2 + ": " + value);
        }
        return new Headers(namesAndValues);
    }

    public static Headers of(Map<String, String> headers) {
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        String[] namesAndValues = new String[headers.size() * 2];
        int i2 = 0;
        for (Map.Entry<String, String> header2 : headers.entrySet()) {
            if (header2.getKey() == null || header2.getValue() == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            String name2 = header2.getKey().trim();
            String value = header2.getValue().trim();
            if (name2.length() == 0 || name2.indexOf(0) != -1 || value.indexOf(0) != -1) {
                throw new IllegalArgumentException("Unexpected header: " + name2 + ": " + value);
            }
            namesAndValues[i2] = name2;
            namesAndValues[i2 + 1] = value;
            i2 += 2;
        }
        return new Headers(namesAndValues);
    }

    public static final class Builder {
        final List<String> namesAndValues = new ArrayList<String>(20);

        Builder addLenient(String line) {
            int index2 = line.indexOf(":", 1);
            if (index2 != -1) {
                return this.addLenient(line.substring(0, index2), line.substring(index2 + 1));
            }
            if (line.startsWith(":")) {
                return this.addLenient("", line.substring(1));
            }
            return this.addLenient("", line);
        }

        public Builder add(String line) {
            int index2 = line.indexOf(":");
            if (index2 == -1) {
                throw new IllegalArgumentException("Unexpected header: " + line);
            }
            return this.add(line.substring(0, index2).trim(), line.substring(index2 + 1));
        }

        public Builder add(String name2, String value) {
            this.checkNameAndValue(name2, value);
            return this.addLenient(name2, value);
        }

        Builder addLenient(String name2, String value) {
            this.namesAndValues.add(name2);
            this.namesAndValues.add(value.trim());
            return this;
        }

        public Builder removeAll(String name2) {
            for (int i2 = 0; i2 < this.namesAndValues.size(); i2 += 2) {
                if (!name2.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                this.namesAndValues.remove(i2);
                this.namesAndValues.remove(i2);
                i2 -= 2;
            }
            return this;
        }

        public Builder set(String name2, String value) {
            this.checkNameAndValue(name2, value);
            this.removeAll(name2);
            this.addLenient(name2, value);
            return this;
        }

        private void checkNameAndValue(String name2, String value) {
            char c;
            int i2;
            if (name2 == null) {
                throw new NullPointerException("name == null");
            }
            if (name2.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            int length = name2.length();
            for (i2 = 0; i2 < length; ++i2) {
                c = name2.charAt(i2);
                if (c > ' ' && c < '\u007f') continue;
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in header name: %s", c, i2, name2));
            }
            if (value == null) {
                throw new NullPointerException("value for name " + name2 + " == null");
            }
            length = value.length();
            for (i2 = 0; i2 < length; ++i2) {
                c = value.charAt(i2);
                if ((c > '\u001f' || c == '\t') && c < '\u007f') continue;
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in %s value: %s", c, i2, name2, value));
            }
        }

        public String get(String name2) {
            for (int i2 = this.namesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
                if (!name2.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                return this.namesAndValues.get(i2 + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

