/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3.internal.http2;

import gg.essential.lib.okhttp3.Headers;
import gg.essential.lib.okhttp3.Interceptor;
import gg.essential.lib.okhttp3.OkHttpClient;
import gg.essential.lib.okhttp3.Protocol;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.Response;
import gg.essential.lib.okhttp3.ResponseBody;
import gg.essential.lib.okhttp3.internal.Internal;
import gg.essential.lib.okhttp3.internal.Util;
import gg.essential.lib.okhttp3.internal.connection.StreamAllocation;
import gg.essential.lib.okhttp3.internal.http.HttpCodec;
import gg.essential.lib.okhttp3.internal.http.HttpHeaders;
import gg.essential.lib.okhttp3.internal.http.RealResponseBody;
import gg.essential.lib.okhttp3.internal.http.RequestLine;
import gg.essential.lib.okhttp3.internal.http.StatusLine;
import gg.essential.lib.okhttp3.internal.http2.ErrorCode;
import gg.essential.lib.okhttp3.internal.http2.Header;
import gg.essential.lib.okhttp3.internal.http2.Http2Connection;
import gg.essential.lib.okhttp3.internal.http2.Http2Stream;
import gg.essential.lib.okio.Buffer;
import gg.essential.lib.okio.ByteString;
import gg.essential.lib.okio.ForwardingSource;
import gg.essential.lib.okio.Okio;
import gg.essential.lib.okio.Sink;
import gg.essential.lib.okio.Source;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2Codec
implements HttpCodec {
    private static final ByteString CONNECTION = ByteString.encodeUtf8("connection");
    private static final ByteString HOST = ByteString.encodeUtf8("host");
    private static final ByteString KEEP_ALIVE = ByteString.encodeUtf8("keep-alive");
    private static final ByteString PROXY_CONNECTION = ByteString.encodeUtf8("proxy-connection");
    private static final ByteString TRANSFER_ENCODING = ByteString.encodeUtf8("transfer-encoding");
    private static final ByteString TE = ByteString.encodeUtf8("te");
    private static final ByteString ENCODING = ByteString.encodeUtf8("encoding");
    private static final ByteString UPGRADE = ByteString.encodeUtf8("upgrade");
    private static final List<ByteString> HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY);
    private static final List<ByteString> HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE);
    private final OkHttpClient client;
    private final Interceptor.Chain chain;
    final StreamAllocation streamAllocation;
    private final Http2Connection connection;
    private Http2Stream stream;

    public Http2Codec(OkHttpClient client, Interceptor.Chain chain, StreamAllocation streamAllocation, Http2Connection connection) {
        this.client = client;
        this.chain = chain;
        this.streamAllocation = streamAllocation;
        this.connection = connection;
    }

    @Override
    public Sink createRequestBody(Request request2, long contentLength) {
        return this.stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request request2) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request2.body() != null;
        List<Header> requestHeaders = Http2Codec.http2HeadersList(request2);
        this.stream = this.connection.newStream(requestHeaders, hasRequestBody);
        this.stream.readTimeout().timeout(this.chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout(this.chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void flushRequest() throws IOException {
        this.connection.flush();
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean expectContinue) throws IOException {
        List<Header> headers = this.stream.takeResponseHeaders();
        Response.Builder responseBuilder = Http2Codec.readHttp2HeadersList(headers);
        if (expectContinue && Internal.instance.code(responseBuilder) == 100) {
            return null;
        }
        return responseBuilder;
    }

    public static List<Header> http2HeadersList(Request request2) {
        Headers headers = request2.headers();
        ArrayList<Header> result = new ArrayList<Header>(headers.size() + 4);
        result.add(new Header(Header.TARGET_METHOD, request2.method()));
        result.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request2.url())));
        String host = request2.header("Host");
        if (host != null) {
            result.add(new Header(Header.TARGET_AUTHORITY, host));
        }
        result.add(new Header(Header.TARGET_SCHEME, request2.url().scheme()));
        int size = headers.size();
        for (int i2 = 0; i2 < size; ++i2) {
            ByteString name2 = ByteString.encodeUtf8(headers.name(i2).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name2)) continue;
            result.add(new Header(name2, headers.value(i2)));
        }
        return result;
    }

    public static Response.Builder readHttp2HeadersList(List<Header> headerBlock) throws IOException {
        StatusLine statusLine = null;
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headerBlock.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Header header2 = headerBlock.get(i2);
            if (header2 == null) {
                if (statusLine == null || statusLine.code != 100) continue;
                statusLine = null;
                headersBuilder = new Headers.Builder();
                continue;
            }
            ByteString name2 = header2.name;
            String value = header2.value.utf8();
            if (name2.equals(Header.RESPONSE_STATUS)) {
                statusLine = StatusLine.parse("HTTP/1.1 " + value);
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name2)) continue;
            Internal.instance.addLenient(headersBuilder, name2.utf8(), value);
        }
        if (statusLine == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        return new Response.Builder().protocol(Protocol.HTTP_2).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        this.streamAllocation.eventListener.responseBodyStart(this.streamAllocation.call);
        String contentType = response.header("Content-Type");
        long contentLength = HttpHeaders.contentLength(response);
        StreamFinishingSource source = new StreamFinishingSource(this.stream.getSource());
        return new RealResponseBody(contentType, contentLength, Okio.buffer(source));
    }

    @Override
    public void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    class StreamFinishingSource
    extends ForwardingSource {
        boolean completed;
        long bytesRead;

        StreamFinishingSource(Source delegate2) {
            super(delegate2);
            this.completed = false;
            this.bytesRead = 0L;
        }

        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            try {
                long read2 = this.delegate().read(sink, byteCount);
                if (read2 > 0L) {
                    this.bytesRead += read2;
                }
                return read2;
            }
            catch (IOException e) {
                this.endOfInput(e);
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.endOfInput(null);
        }

        private void endOfInput(IOException e) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            Http2Codec.this.streamAllocation.streamFinished(false, Http2Codec.this, this.bytesRead, e);
        }
    }
}

