/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3.internal.ws;

import gg.essential.lib.okhttp3.internal.ws.WebSocketProtocol;
import gg.essential.lib.okio.Buffer;
import gg.essential.lib.okio.BufferedSink;
import gg.essential.lib.okio.ByteString;
import gg.essential.lib.okio.Sink;
import gg.essential.lib.okio.Timeout;
import java.io.IOException;
import java.util.Random;

final class WebSocketWriter {
    final boolean isClient;
    final Random random;
    final BufferedSink sink;
    boolean writerClosed;
    final Buffer buffer = new Buffer();
    final FrameSink frameSink = new FrameSink();
    boolean activeWriter;
    final byte[] maskKey;
    final byte[] maskBuffer;

    WebSocketWriter(boolean isClient, BufferedSink sink, Random random) {
        if (sink == null) {
            throw new NullPointerException("sink == null");
        }
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        this.isClient = isClient;
        this.sink = sink;
        this.random = random;
        this.maskKey = isClient ? new byte[4] : null;
        this.maskBuffer = isClient ? new byte[8192] : null;
    }

    void writePing(ByteString payload) throws IOException {
        this.writeControlFrame(9, payload);
    }

    void writePong(ByteString payload) throws IOException {
        this.writeControlFrame(10, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClose(int code, ByteString reason2) throws IOException {
        ByteString payload = ByteString.EMPTY;
        if (code != 0 || reason2 != null) {
            if (code != 0) {
                WebSocketProtocol.validateCloseCode(code);
            }
            Buffer buffer = new Buffer();
            buffer.writeShort(code);
            if (reason2 != null) {
                buffer.write(reason2);
            }
            payload = buffer.readByteString();
        }
        try {
            this.writeControlFrame(8, payload);
        }
        finally {
            this.writerClosed = true;
        }
    }

    private void writeControlFrame(int opcode, ByteString payload) throws IOException {
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int length = payload.size();
        if ((long)length > 125L) {
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        int b0 = 0x80 | opcode;
        this.sink.writeByte(b0);
        int b1 = length;
        if (this.isClient) {
            this.sink.writeByte(b1 |= 0x80);
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            byte[] bytes = payload.toByteArray();
            WebSocketProtocol.toggleMask(bytes, bytes.length, this.maskKey, 0L);
            this.sink.write(bytes);
        } else {
            this.sink.writeByte(b1);
            this.sink.write(payload);
        }
        this.sink.flush();
    }

    Sink newMessageSink(int formatOpcode, long contentLength) {
        if (this.activeWriter) {
            throw new IllegalStateException("Another message writer is active. Did you call close()?");
        }
        this.activeWriter = true;
        this.frameSink.formatOpcode = formatOpcode;
        this.frameSink.contentLength = contentLength;
        this.frameSink.isFirstFrame = true;
        this.frameSink.closed = false;
        return this.frameSink;
    }

    void writeMessageFrame(int formatOpcode, long byteCount, boolean isFirstFrame, boolean isFinal) throws IOException {
        int b0;
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n = b0 = isFirstFrame ? formatOpcode : 0;
        if (isFinal) {
            b0 |= 0x80;
        }
        this.sink.writeByte(b0);
        int b1 = 0;
        if (this.isClient) {
            b1 |= 0x80;
        }
        if (byteCount <= 125L) {
            this.sink.writeByte(b1 |= (int)byteCount);
        } else if (byteCount <= 65535L) {
            this.sink.writeByte(b1 |= 0x7E);
            this.sink.writeShort((int)byteCount);
        } else {
            this.sink.writeByte(b1 |= 0x7F);
            this.sink.writeLong(byteCount);
        }
        if (this.isClient) {
            int read2;
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            for (long written = 0L; written < byteCount; written += (long)read2) {
                int toRead = (int)Math.min(byteCount, (long)this.maskBuffer.length);
                read2 = this.buffer.read(this.maskBuffer, 0, toRead);
                if (read2 == -1) {
                    throw new AssertionError();
                }
                WebSocketProtocol.toggleMask(this.maskBuffer, read2, this.maskKey, written);
                this.sink.write(this.maskBuffer, 0, read2);
            }
        } else {
            this.sink.write(this.buffer, byteCount);
        }
        this.sink.emit();
    }

    final class FrameSink
    implements Sink {
        int formatOpcode;
        long contentLength;
        boolean isFirstFrame;
        boolean closed;

        FrameSink() {
        }

        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.buffer.write(source, byteCount);
            boolean deferWrite = this.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.buffer.size() > this.contentLength - 8192L;
            long emitCount = WebSocketWriter.this.buffer.completeSegmentByteCount();
            if (emitCount > 0L && !deferWrite) {
                WebSocketWriter.this.writeMessageFrame(this.formatOpcode, emitCount, this.isFirstFrame, false);
                this.isFirstFrame = false;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, false);
            this.isFirstFrame = false;
        }

        @Override
        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, true);
            this.closed = true;
            WebSocketWriter.this.activeWriter = false;
        }
    }
}

