/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.minecraftauth.microsoft;

import gg.essential.lib.okhttp3.FormBody;
import gg.essential.lib.okhttp3.HttpUrl;
import gg.essential.lib.okhttp3.Request;
import gg.essential.minecraftauth.exception.AuthenticationException;
import gg.essential.minecraftauth.exception.MicrosoftAuthenticationException;
import gg.essential.minecraftauth.microsoft.response.MicrosoftAccessTokenResponse;
import gg.essential.minecraftauth.microsoft.response.MicrosoftAuthorizationErrorResponse;
import gg.essential.minecraftauth.util.HttpKt;
import gg.essential.minecraftauth.util.JsonKt;
import gg.essential.util.Sha256;
import java.net.URI;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0004J)\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00042\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgg/essential/minecraftauth/microsoft/MicrosoftAuthenticationService;", "", "()V", "CLIENT_ID", "", "OAUTH_AUTHORIZATION_URL", "OAUTH_EXCHANGE_URL", "SCOPE", "exchangeCodeForAccessToken", "Lgg/essential/minecraftauth/microsoft/response/MicrosoftAccessTokenResponse;", "code", "verifier", "redirectUri", "generateAuthorizationURI", "Ljava/net/URI;", "refreshAccessToken", "refreshToken", "requestAccessToken", "grantType", "bodyBuilder", "Lkotlin/Function1;", "Lgg/essential/lib/okhttp3/FormBody$Builder;", "", "Lkotlin/ExtensionFunctionType;", "minecraft-auth"})
@SourceDebugExtension(value={"SMAP\nMicrosoftAuthenticationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicrosoftAuthenticationService.kt\ngg/essential/minecraftauth/microsoft/MicrosoftAuthenticationService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,140:1\n215#2,2:141\n1#3:143\n96#4:144\n96#4:145\n*S KotlinDebug\n*F\n+ 1 MicrosoftAuthenticationService.kt\ngg/essential/minecraftauth/microsoft/MicrosoftAuthenticationService\n*L\n92#1:141,2\n122#1:144\n128#1:145\n*E\n"})
public final class MicrosoftAuthenticationService {
    @NotNull
    public static final MicrosoftAuthenticationService INSTANCE = new MicrosoftAuthenticationService();
    @NotNull
    private static final String CLIENT_ID = "e39cc675-eb52-4475-b5f8-82aaae14eeba";
    @NotNull
    private static final String SCOPE = "XboxLive.signin XboxLive.offline_access";
    @NotNull
    private static final String OAUTH_AUTHORIZATION_URL = "https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize";
    @NotNull
    private static final String OAUTH_EXCHANGE_URL = "https://login.microsoftonline.com/consumers/oauth2/v2.0/token";

    private MicrosoftAuthenticationService() {
    }

    @NotNull
    public final MicrosoftAccessTokenResponse exchangeCodeForAccessToken(@NotNull String code, @NotNull String verifier, @NotNull String redirectUri) throws AuthenticationException, MicrosoftAuthenticationException {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        return this.requestAccessToken("authorization_code", (Function1<? super FormBody.Builder, Unit>)((Function1)new Function1<FormBody.Builder, Unit>(code, redirectUri, verifier){
            final /* synthetic */ String $code;
            final /* synthetic */ String $redirectUri;
            final /* synthetic */ String $verifier;
            {
                this.$code = $code;
                this.$redirectUri = $redirectUri;
                this.$verifier = $verifier;
                super(1);
            }

            public final void invoke(@NotNull FormBody.Builder $this$requestAccessToken) {
                Intrinsics.checkNotNullParameter((Object)$this$requestAccessToken, (String)"$this$requestAccessToken");
                $this$requestAccessToken.add("code", this.$code);
                $this$requestAccessToken.add("redirect_uri", this.$redirectUri);
                $this$requestAccessToken.add("code_verifier", this.$verifier);
            }
        }));
    }

    @NotNull
    public final MicrosoftAccessTokenResponse refreshAccessToken(@NotNull String refreshToken) throws AuthenticationException, MicrosoftAuthenticationException {
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        return this.requestAccessToken("refresh_token", (Function1<? super FormBody.Builder, Unit>)((Function1)new Function1<FormBody.Builder, Unit>(refreshToken){
            final /* synthetic */ String $refreshToken;
            {
                this.$refreshToken = $refreshToken;
                super(1);
            }

            public final void invoke(@NotNull FormBody.Builder $this$requestAccessToken) {
                Intrinsics.checkNotNullParameter((Object)$this$requestAccessToken, (String)"$this$requestAccessToken");
                $this$requestAccessToken.add("refresh_token", this.$refreshToken);
            }
        }));
    }

    @NotNull
    public final URI generateAuthorizationURI(@NotNull String verifier, @NotNull String redirectUri) {
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)"client_id", (Object)CLIENT_ID);
        pairArray[1] = TuplesKt.to((Object)"response_type", (Object)"code");
        pairArray[2] = TuplesKt.to((Object)"prompt", (Object)"select_account");
        pairArray[3] = TuplesKt.to((Object)"redirect_uri", (Object)redirectUri);
        pairArray[4] = TuplesKt.to((Object)"scope", (Object)SCOPE);
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        String string = verifier;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        pairArray[5] = TuplesKt.to((Object)"code_challenge", (Object)encoder.encodeToString(Sha256.Companion.compute(byArray).getBytes()));
        pairArray[6] = TuplesKt.to((Object)"code_challenge_method", (Object)"S256");
        Map parameters = MapsKt.mapOf((Pair[])pairArray);
        HttpUrl httpUrl = HttpUrl.parse(OAUTH_AUTHORIZATION_URL);
        Intrinsics.checkNotNull((Object)httpUrl);
        HttpUrl.Builder httpBuilder = httpUrl.newBuilder();
        Map $this$forEach$iv = parameters;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            httpBuilder.addQueryParameter((String)it.getKey(), (String)it.getValue());
        }
        URI uRI = httpBuilder.build().uri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri(...)");
        return uRI;
    }

    private final MicrosoftAccessTokenResponse requestAccessToken(String grantType, Function1<? super FormBody.Builder, Unit> bodyBuilder) throws AuthenticationException, MicrosoftAuthenticationException {
        Object $this$requestAccessToken_u24lambda_u243;
        FormBody.Builder body = new FormBody.Builder();
        bodyBuilder.invoke((Object)body);
        Request request2 = new Request.Builder().url(OAUTH_EXCHANGE_URL).header("Accept", "application/json").post(body.add("client_id", CLIENT_ID).add("scope", SCOPE).add("grant_type", grantType).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"build(...)");
        Pair<Integer, String> pair = HttpKt.execute(request2);
        int status2 = ((Number)pair.component1()).intValue();
        String content = (String)pair.component2();
        if (status2 == 200) {
            Object $this$requestAccessToken_u24lambda_u241;
            Object object = this;
            try {
                $this$requestAccessToken_u24lambda_u241 = object;
                boolean bl = false;
                Json this_$iv = JsonKt.getJSON();
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                $this$requestAccessToken_u24lambda_u241 = Result.constructor-impl((Object)((MicrosoftAccessTokenResponse)this_$iv.decodeFromString((DeserializationStrategy)MicrosoftAccessTokenResponse.Companion.serializer(), content)));
            }
            catch (Throwable bl) {
                $this$requestAccessToken_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$requestAccessToken_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw new AuthenticationException.InvalidResponse(status2, content);
            }
            return (MicrosoftAccessTokenResponse)object;
        }
        Object object = this;
        try {
            $this$requestAccessToken_u24lambda_u243 = object;
            boolean bl = false;
            Json this_$iv = JsonKt.getJSON();
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            $this$requestAccessToken_u24lambda_u243 = Result.constructor-impl((Object)((MicrosoftAuthorizationErrorResponse)this_$iv.decodeFromString((DeserializationStrategy)MicrosoftAuthorizationErrorResponse.Companion.serializer(), content)));
        }
        catch (Throwable bl) {
            $this$requestAccessToken_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$requestAccessToken_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new AuthenticationException.InvalidResponse(status2, content);
        }
        MicrosoftAuthorizationErrorResponse errorResponse = (MicrosoftAuthorizationErrorResponse)object;
        if (Intrinsics.areEqual((Object)errorResponse.getError(), (Object)"invalid_grant")) {
            throw new AuthenticationException.InvalidCredentials();
        }
        throw new MicrosoftAuthenticationException(errorResponse);
    }
}

