/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins;

import gg.essential.mixins.Plugin;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class IntegrationTestsPlugin
implements IMixinConfigPlugin {
    public static final boolean ENABLED = System.getProperty("essential.integrationTest") != null;
    private static final Set<IMixinConfig> injectionCountingEnabled = Collections.newSetFromMap(new IdentityHashMap());

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!ENABLED) {
            return false;
        }
        return !mixinClassName.endsWith("_Emojiful") || Plugin.hasClass(targetClassName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (ENABLED) {
            IntegrationTestsPlugin.enableInjectionCounting(mixinInfo);
        }
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public static void enableInjectionCounting(IMixinInfo mixinInfo) {
        IMixinConfig config = mixinInfo.getConfig();
        if (!injectionCountingEnabled.add(config)) {
            return;
        }
        try {
            Field injectorOptionsField = config.getClass().getDeclaredField("injectorOptions");
            injectorOptionsField.setAccessible(true);
            Object injectorOptions = injectorOptionsField.get(config);
            Field defaultRequireValueField = injectorOptions.getClass().getDeclaredField("defaultRequireValue");
            defaultRequireValueField.setAccessible(true);
            defaultRequireValueField.set(injectorOptions, 1);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerUncaughtExceptionHandler() {
        if (!ENABLED) {
            return;
        }
        if (Thread.getDefaultUncaughtExceptionHandler() != null) {
            return;
        }
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            try {
                LoggerFactory.getLogger((String)"UncaughtExceptionHandler").error("Uncaught exception in thread \"{}\"", (Object)thread.getName(), (Object)throwable);
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
                throwable.printStackTrace();
            }
        });
    }
}

