/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.lib.kotgl.matrix.vectors.Vec2;
import gg.essential.lib.kotgl.matrix.vectors.Vec3;
import gg.essential.lib.kotgl.matrix.vectors.Vec4;
import gg.essential.lib.kotgl.matrix.vectors.Vectors;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec2;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec3;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVectors;
import gg.essential.model.CurveVariables;
import gg.essential.model.ModelAnimationState;
import gg.essential.model.ParticleEffect;
import gg.essential.model.ParticleEffectWithReferencedEffects;
import gg.essential.model.ParticleSystem;
import gg.essential.model.ParticleSystemKt;
import gg.essential.model.SoundEffect;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.collision.CollisionProvider;
import gg.essential.model.file.ParticleEffectComponents;
import gg.essential.model.file.ParticlesFile;
import gg.essential.model.light.Light;
import gg.essential.model.light.LightProvider;
import gg.essential.model.molang.Molang;
import gg.essential.model.molang.MolangContext;
import gg.essential.model.molang.MolangQuery;
import gg.essential.model.molang.MolangQueryEntity;
import gg.essential.model.molang.MolangQueryTime;
import gg.essential.model.molang.Variables;
import gg.essential.model.molang.VariablesMap;
import gg.essential.model.util.Color;
import gg.essential.model.util.KotglKt;
import gg.essential.model.util.Quaternion;
import gg.essential.model.util.UMatrixStack;
import gg.essential.model.util.UVertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\b\u0018\u00002\u00020\u0001:\u000501234B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016JJ\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00162\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\"J\u000e\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(J4\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110*2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110-H\u0002J\u0006\u0010.\u001a\u00020\u000bJ\u0014\u0010.\u001a\u00020\u000b2\n\u0010/\u001a\u00060\u0014R\u00020\u0000H\u0002R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u00060\u0014R\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lgg/essential/model/ParticleSystem;", "", "random", "Lkotlin/random/Random;", "collisionProvider", "Lgg/essential/model/collision/CollisionProvider;", "lightProvider", "Lgg/essential/model/light/LightProvider;", "playSound", "Lkotlin/Function1;", "Lgg/essential/model/ModelAnimationState$SoundEvent;", "", "(Lkotlin/random/Random;Lgg/essential/model/collision/CollisionProvider;Lgg/essential/model/light/LightProvider;Lkotlin/jvm/functions/Function1;)V", "billboardRenderPasses", "", "Lgg/essential/model/ParticleEffect$RenderPass;", "", "Lgg/essential/model/ParticleSystem$Particle;", "universes", "Lgg/essential/model/molang/MolangQueryTime;", "Lgg/essential/model/ParticleSystem$Universe;", "hasAnythingToRender", "", "isEmpty", "render", "matrixStack", "Lgg/essential/model/util/UMatrixStack;", "cameraPos", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "cameraRot", "Lgg/essential/model/util/Quaternion;", "particleVertexConsumerProvider", "Lgg/essential/model/ParticleSystem$VertexConsumerProvider;", "cameraUuid", "Ljava/util/UUID;", "cameraFirstPerson", "hideParticlesInFirstPerson", "onlyRenderFromSource", "spawn", "event", "Lgg/essential/model/ModelAnimationState$ParticleEvent;", "translucencySortBillboardParticles", "", "cameraFacing", "particles", "", "update", "universe", "Emitter", "Locator", "Particle", "Universe", "VertexConsumerProvider", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nParticleSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleSystem.kt\ngg/essential/model/ParticleSystem\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1560:1\n357#2,7:1561\n1043#3:1568\n764#3:1569\n855#3,2:1570\n1849#3,2:1572\n1547#3:1574\n1618#3,3:1575\n1043#3:1578\n1000#3,2:1580\n1#4:1579\n*S KotlinDebug\n*F\n+ 1 ParticleSystem.kt\ngg/essential/model/ParticleSystem\n*L\n141#1:1561,7\n259#1:1568\n263#1:1569\n263#1:1570,2\n451#1:1572,2\n458#1:1574\n458#1:1575,3\n467#1:1578\n582#1:1580,2\n*E\n"})
public final class ParticleSystem {
    @NotNull
    private final Random random;
    @NotNull
    private final CollisionProvider collisionProvider;
    @NotNull
    private final LightProvider lightProvider;
    @NotNull
    private final Function1<ModelAnimationState.SoundEvent, Unit> playSound;
    @NotNull
    private final Map<MolangQueryTime, Universe> universes;
    @NotNull
    private final Map<ParticleEffect.RenderPass, Set<Particle>> billboardRenderPasses;

    public ParticleSystem(@NotNull Random random, @NotNull CollisionProvider collisionProvider, @NotNull LightProvider lightProvider, @NotNull Function1<? super ModelAnimationState.SoundEvent, Unit> playSound2) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)collisionProvider, (String)"collisionProvider");
        Intrinsics.checkNotNullParameter((Object)lightProvider, (String)"lightProvider");
        Intrinsics.checkNotNullParameter(playSound2, (String)"playSound");
        this.random = random;
        this.collisionProvider = collisionProvider;
        this.lightProvider = lightProvider;
        this.playSound = playSound2;
        this.universes = new LinkedHashMap();
        this.billboardRenderPasses = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public final void spawn(@NotNull ModelAnimationState.ParticleEvent event) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Map<MolangQueryTime, Universe> map2 = this.universes;
        MolangQueryTime key$iv = event.getTimeSource();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Universe answer$iv = new Universe(event.getTimeSource());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Universe universe = (Universe)object;
        map2 = event.getLocator().getPositionAndRotation();
        Vec3 position2 = (Vec3)map2.component1();
        Quaternion rotation = (Quaternion)map2.component2();
        Emitter emitter = new Emitter(this, universe, event.getEffect(), event.getTextureSource(), event.getSourceEntity(), position2, rotation, Vectors.vec3(), event.getLocator(), Vectors.vec3());
        Molang molang = event.getPreEffectScript();
        if (molang != null) {
            molang.eval(emitter.getMolang());
        }
        universe.getEmitters().add(emitter);
        float dt = RangesKt.coerceAtLeast((float)(universe.getLastUpdate() - event.getTime()), (float)0.0f);
        emitter.startLoop(dt);
        float maxSimTime = 10.0f;
        if (dt > maxSimTime) {
            emitter.skip(dt - maxSimTime);
            emitter.update(maxSimTime);
        } else {
            emitter.update(dt);
        }
    }

    public final void update() {
        boolean cleanup2 = false;
        for (Universe universe : this.universes.values()) {
            this.update(universe);
            if (!universe.getEmitters().isEmpty() || !universe.getParticles().isEmpty()) continue;
            cleanup2 = true;
        }
        if (cleanup2) {
            CollectionsKt.removeAll((Iterable)this.universes.values(), (Function1)update.1.INSTANCE);
        }
    }

    private final void update(Universe universe) {
        int expiredParticles;
        int expiredEmitters;
        List<Particle> particles;
        List<Emitter> emitters;
        block13: {
            int i2;
            int lastParticleIndex;
            float dt;
            block10: {
                float now2 = universe.getTimeSource().getTime();
                dt = now2 - universe.getLastUpdate();
                universe.setLastUpdate(now2);
                emitters = universe.getEmitters();
                particles = universe.getParticles();
                int lastEmitterIndex = CollectionsKt.getLastIndex(emitters);
                lastParticleIndex = CollectionsKt.getLastIndex(particles);
                expiredEmitters = 0;
                expiredParticles = 0;
                i2 = 0;
                if (i2 > lastEmitterIndex) break block10;
                while (true) {
                    block12: {
                        block11: {
                            Emitter emitter;
                            if ((emitter = emitters.get(i2)) == null) break block11;
                            if (emitter.update(dt)) break block12;
                            emitters.set(i2, null);
                        }
                        ++expiredEmitters;
                    }
                    if (i2 == lastEmitterIndex) break;
                    ++i2;
                }
            }
            if ((i2 = 0) > lastParticleIndex) break block13;
            while (true) {
                block15: {
                    block14: {
                        Particle particle;
                        if ((particle = particles.get(i2)) == null) break block14;
                        if (particle.update(dt)) break block15;
                        universe.removeParticleAt(i2);
                        Emitter emitter = particle.getEmitter();
                        int n = emitter.getActiveParticles();
                        emitter.setActiveParticles(n + -1);
                    }
                    ++expiredParticles;
                }
                if (i2 == lastParticleIndex) break;
                ++i2;
            }
        }
        if (expiredEmitters > 64 || expiredEmitters == emitters.size()) {
            CollectionsKt.removeAll(emitters, (Function1)update.2.INSTANCE);
        }
        if (expiredParticles > 64 || expiredParticles == particles.size()) {
            CollectionsKt.removeAll(particles, (Function1)update.3.INSTANCE);
        }
    }

    public final boolean isEmpty() {
        return this.universes.isEmpty();
    }

    public final boolean hasAnythingToRender() {
        return !this.billboardRenderPasses.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void render(@NotNull UMatrixStack matrixStack, @NotNull Vec3 cameraPos, @NotNull Quaternion cameraRot, @NotNull VertexConsumerProvider particleVertexConsumerProvider, @NotNull UUID cameraUuid, boolean cameraFirstPerson, boolean hideParticlesInFirstPerson, @Nullable UUID onlyRenderFromSource) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)cameraPos, (String)"cameraPos");
        Intrinsics.checkNotNullParameter((Object)cameraRot, (String)"cameraRot");
        Intrinsics.checkNotNullParameter((Object)particleVertexConsumerProvider, (String)"particleVertexConsumerProvider");
        Intrinsics.checkNotNullParameter((Object)cameraUuid, (String)"cameraUuid");
        MutableVec3 cameraFacing = KotglKt.rotateBy(Vectors.vec3(0.0f, 0.0f, -1.0f), cameraRot);
        Iterable $this$sortedBy$iv = this.billboardRenderPasses.entrySet();
        boolean $i$f$sortedBy = false;
        for (Map.Entry entry2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(((ParticleEffect.RenderPass)it.getKey()).getMaterial().getNeedsSorting());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(((ParticleEffect.RenderPass)it.getKey()).getMaterial().getNeedsSorting()));
            }
        })) {
            Collection collection;
            ParticleEffect.RenderPass renderPass = (ParticleEffect.RenderPass)entry2.getKey();
            Set allParticles = (Set)entry2.getValue();
            if (onlyRenderFromSource != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = allParticles;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Particle it = (Particle)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getEmitter().getSourceEntity().getUuid(), (Object)onlyRenderFromSource)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List particlesFromSource = (List)destination$iv$iv;
                if (particlesFromSource.isEmpty()) continue;
                collection = particlesFromSource;
            } else {
                collection = allParticles;
            }
            Collection particles = collection;
            particleVertexConsumerProvider.provide(renderPass, (Function1<? super UVertexConsumer, Unit>)((Function1)new Function1<UVertexConsumer, Unit>(renderPass, (Collection<Particle>)particles, cameraPos, cameraRot, matrixStack, cameraFacing, cameraUuid, cameraFirstPerson, hideParticlesInFirstPerson, this){
                final /* synthetic */ ParticleEffect.RenderPass $renderPass;
                final /* synthetic */ Collection<Particle> $particles;
                final /* synthetic */ Vec3 $cameraPos;
                final /* synthetic */ Quaternion $cameraRot;
                final /* synthetic */ UMatrixStack $matrixStack;
                final /* synthetic */ MutableVec3 $cameraFacing;
                final /* synthetic */ UUID $cameraUuid;
                final /* synthetic */ boolean $cameraFirstPerson;
                final /* synthetic */ boolean $hideParticlesInFirstPerson;
                final /* synthetic */ ParticleSystem this$0;
                {
                    this.$renderPass = $renderPass;
                    this.$particles = $particles;
                    this.$cameraPos = $cameraPos;
                    this.$cameraRot = $cameraRot;
                    this.$matrixStack = $matrixStack;
                    this.$cameraFacing = $cameraFacing;
                    this.$cameraUuid = $cameraUuid;
                    this.$cameraFirstPerson = $cameraFirstPerson;
                    this.$hideParticlesInFirstPerson = $hideParticlesInFirstPerson;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull UVertexConsumer vertexConsumer) {
                    Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
                    if (!this.$renderPass.getMaterial().getNeedsSorting()) {
                        for (Particle particle : this.$particles) {
                            particle.prepareBillboard(this.$cameraPos, this.$cameraRot);
                            particle.renderBillboard(this.$matrixStack, vertexConsumer, this.$cameraFacing, this.$cameraUuid, this.$cameraFirstPerson, this.$hideParticlesInFirstPerson);
                        }
                        return;
                    }
                    boolean allAligned = true;
                    Vec3 firstNormal = null;
                    for (Particle particle : this.$particles) {
                        particle.prepareBillboard(this.$cameraPos, this.$cameraRot);
                        particle.setNormal(KotglKt.rotateSelfBy(MutableVectors.mutableVec3(0.0f, 0.0f, -1.0f), particle.getBillboardRotation()));
                        if (allAligned) {
                            if (firstNormal == null) {
                                firstNormal = particle.getNormal();
                            } else if (!Intrinsics.areEqual((Object)firstNormal, (Object)particle.getNormal())) {
                                allAligned = false;
                            }
                        }
                        particle.setDistance(Vectors.dot(MutableVectors.minus(this.$cameraPos, particle.getBillboardPosition()), particle.getNormal()));
                    }
                    if (allAligned) {
                        Iterable $this$sortedByDescending$iv = this.$particles;
                        boolean $i$f$sortedByDescending = false;
                        for (Particle particle : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                Particle it = (Particle)b;
                                boolean bl = false;
                                Comparable comparable = Float.valueOf(it.getDistance());
                                it = (Particle)a;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getDistance()));
                            }
                        })) {
                            particle.renderBillboard(this.$matrixStack, vertexConsumer, this.$cameraFacing, this.$cameraUuid, this.$cameraFirstPerson, this.$hideParticlesInFirstPerson);
                        }
                        return;
                    }
                    for (Particle p : ParticleSystem.access$translucencySortBillboardParticles(this.this$0, this.$cameraFacing, this.$cameraPos, this.$cameraRot, this.$particles)) {
                        p.renderBillboard(this.$matrixStack, vertexConsumer, this.$cameraFacing, this.$cameraUuid, this.$cameraFirstPerson, this.$hideParticlesInFirstPerson);
                    }
                }
            }));
        }
    }

    public static /* synthetic */ void render$default(ParticleSystem particleSystem2, UMatrixStack uMatrixStack, Vec3 vec3, Quaternion quaternion, VertexConsumerProvider vertexConsumerProvider, UUID uUID, boolean bl, boolean bl2, UUID uUID2, int n, Object object) {
        if ((n & 0x80) != 0) {
            uUID2 = null;
        }
        particleSystem2.render(uMatrixStack, vec3, quaternion, vertexConsumerProvider, uUID, bl, bl2, uUID2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Particle> translucencySortBillboardParticles(Vec3 cameraFacing, Vec3 cameraPos, Quaternion cameraRot, Collection<Particle> particles) {
        MutableVec3 cameraUp = KotglKt.rotateSelfBy(MutableVectors.mutableVec3(0.0f, 1.0f, 0.0f), cameraRot);
        MutableVec3 cameraRight = KotglKt.rotateSelfBy(MutableVectors.mutableVec3(1.0f, 0.0f, 0.0f), cameraRot);
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000O\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0000\u00a2\u0006\u0002\u0010:J\u001a\u0010;\u001a\u00020<2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020<0>J\u0013\u0010?\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u0000\u00a2\u0006\u0002\u0010@J\u0013\u0010A\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u0000\u00a2\u0006\u0002\u0010@J\u0018\u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bH\u0002J\u0013\u0010E\u001a\u00020<2\u0006\u00109\u001a\u00020\u0000\u00a2\u0006\u0002\u0010FR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\n\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\u001eR\u000e\u0010$\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0016\"\u0004\b(\u0010)R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0013\"\u0004\b.\u0010\u001aR\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00104\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006G"}, d2={"gg/essential/model/ParticleSystem$translucencySortBillboardParticles$Billboard", "", "index", "", "particle", "Lgg/essential/model/ParticleSystem$Particle;", "(Ldev/folomeev/kotgl/matrix/vectors/Vec3;Ldev/folomeev/kotgl/matrix/vectors/mutables/MutableVec3;Ldev/folomeev/kotgl/matrix/vectors/mutables/MutableVec3;Ldev/folomeev/kotgl/matrix/vectors/Vec3;ILgg/essential/model/ParticleSystem$Particle;)V", "alignedDistance", "", "getAlignedDistance", "()F", "dependantsArray", "", "dependantsSize", "depthFactor", "getDepthFactor", "fallbackSortZ", "getFallbackSortZ", "getIndex", "()I", "isFullyBehindCamera", "", "()Z", "lowLink", "getLowLink", "setLowLink", "(I)V", "maxX", "getMaxX", "setMaxX", "(F)V", "maxY", "maxZ", "minX", "getMinX", "setMinX", "minY", "minZ", "onStack", "getOnStack", "setOnStack", "(Z)V", "getParticle", "()Lgg/essential/model/ParticleSystem$Particle;", "sortIndex", "getSortIndex", "setSortIndex", "vert0", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "vert1", "vert2", "vert3", "worldNormal", "getWorldNormal", "()Ldev/folomeev/kotgl/matrix/vectors/Vec3;", "centerOfOverlap", "Lgg/essential/lib/kotgl/matrix/vectors/Vec2;", "other", "(Lgg/essential/model/ParticleSystem$translucencySortBillboardParticles$Billboard;)Ldev/folomeev/kotgl/matrix/vectors/Vec2;", "forEachDependant", "", "action", "Lkotlin/Function1;", "isFullyBehind", "(Lgg/essential/model/ParticleSystem$translucencySortBillboardParticles$Billboard;)Z", "overlapsVerticallyWith", "pos", "x", "y", "setBehind", "(Lgg/essential/model/ParticleSystem$translucencySortBillboardParticles$Billboard;)V", "cosmetics"})
        @SourceDebugExtension(value={"SMAP\nParticleSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleSystem.kt\ngg/essential/model/ParticleSystem$translucencySortBillboardParticles$Billboard\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1560:1\n1#2:1561\n*E\n"})
        public final class Billboard {
            private final int index;
            @NotNull
            private final Particle particle;
            private int lowLink;
            private int sortIndex;
            private boolean onStack;
            @Nullable
            private int[] dependantsArray;
            private int dependantsSize;
            @NotNull
            private final Vec3 vert0;
            @NotNull
            private final Vec3 vert1;
            @NotNull
            private final Vec3 vert2;
            @NotNull
            private final Vec3 vert3;
            private float minZ;
            private float maxZ;
            private float minX;
            private float maxX;
            private float minY;
            private float maxY;
            private final float depthFactor;
            final /* synthetic */ Vec3 $cameraPos;
            final /* synthetic */ MutableVec3 $cameraRight;
            final /* synthetic */ MutableVec3 $cameraUp;
            final /* synthetic */ Vec3 $cameraFacing;

            public Billboard(@NotNull Vec3 $cameraPos, @NotNull MutableVec3 $cameraRight, @NotNull MutableVec3 $cameraUp, @NotNull Vec3 $cameraFacing, int index2, @NotNull Particle particle) {
                Intrinsics.checkNotNullParameter((Object)$cameraPos, (String)"$cameraPos");
                Intrinsics.checkNotNullParameter((Object)$cameraRight, (String)"$cameraRight");
                Intrinsics.checkNotNullParameter((Object)$cameraUp, (String)"$cameraUp");
                Intrinsics.checkNotNullParameter((Object)$cameraFacing, (String)"$cameraFacing");
                Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
                this.$cameraPos = $cameraPos;
                this.$cameraRight = $cameraRight;
                this.$cameraUp = $cameraUp;
                this.$cameraFacing = $cameraFacing;
                this.index = index2;
                this.particle = particle;
                this.sortIndex = -1;
                this.vert0 = this.pos(-this.particle.getBillboardSize().getX(), -this.particle.getBillboardSize().getY());
                this.vert1 = this.pos(-this.particle.getBillboardSize().getX(), this.particle.getBillboardSize().getY());
                this.vert2 = this.pos(this.particle.getBillboardSize().getX(), this.particle.getBillboardSize().getY());
                this.vert3 = this.pos(this.particle.getBillboardSize().getX(), -this.particle.getBillboardSize().getY());
                this.minZ = Float.POSITIVE_INFINITY;
                this.maxZ = Float.NEGATIVE_INFINITY;
                this.minX = Float.POSITIVE_INFINITY;
                this.maxX = Float.NEGATIVE_INFINITY;
                this.minY = Float.POSITIVE_INFINITY;
                this.maxY = Float.NEGATIVE_INFINITY;
                Vec3[] vec3Array = new Vec3[]{this.vert0, this.vert1, this.vert2, this.vert3};
                for (Vec3 v : vec3Array) {
                    if (v.getX() < this.minX) {
                        this.minX = v.getX();
                    }
                    if (v.getX() > this.maxX) {
                        this.maxX = v.getX();
                    }
                    if (v.getY() < this.minY) {
                        this.minY = v.getY();
                    }
                    if (v.getY() > this.maxY) {
                        this.maxY = v.getY();
                    }
                    if (v.getZ() < this.minZ) {
                        this.minZ = v.getZ();
                    }
                    if (!(v.getZ() > this.maxZ)) continue;
                    this.maxZ = v.getZ();
                }
                this.depthFactor = Vectors.dot(MutableVectors.minus(this.particle.getBillboardPosition(), $cameraPos), this.particle.getNormal());
            }

            public final int getIndex() {
                return this.index;
            }

            @NotNull
            public final Particle getParticle() {
                return this.particle;
            }

            public final int getLowLink() {
                return this.lowLink;
            }

            public final void setLowLink(int n) {
                this.lowLink = n;
            }

            public final int getSortIndex() {
                return this.sortIndex;
            }

            public final void setSortIndex(int n) {
                this.sortIndex = n;
            }

            public final boolean getOnStack() {
                return this.onStack;
            }

            public final void setOnStack(boolean bl) {
                this.onStack = bl;
            }

            public final void forEachDependant(@NotNull Function1<? super Integer, Unit> action2) {
                Intrinsics.checkNotNullParameter(action2, (String)"action");
                int n = this.dependantsSize;
                for (int i2 = 0; i2 < n; ++i2) {
                    Intrinsics.checkNotNull((Object)this.dependantsArray);
                    action2.invoke((Object)this.dependantsArray[i2]);
                }
            }

            public final void setBehind(@NotNull Billboard other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (this.dependantsArray == null) {
                    this.dependantsArray = new int[4];
                } else {
                    Intrinsics.checkNotNull((Object)this.dependantsArray);
                    if (this.dependantsArray.length <= this.dependantsSize) {
                        int[] newArray = new int[this.dependantsSize * 2];
                        if (this.dependantsArray != null) {
                            int[] it = this.dependantsArray;
                            boolean bl = false;
                            System.arraycopy(it, 0, newArray, 0, it.length);
                        }
                        this.dependantsArray = newArray;
                    }
                }
                Intrinsics.checkNotNull((Object)this.dependantsArray);
                int n = this.dependantsSize;
                this.dependantsSize = n + 1;
                this.dependantsArray[n] = other.index;
            }

            private final Vec3 pos(float x, float y) {
                return ParticleSystem.access$translucencySortBillboardParticles$projectToScreenSpaceSelf(MutableVectors.plusSelf(KotglKt.rotateSelfBy(MutableVectors.mutableVec3(x, y, 0.0f), this.particle.getBillboardRotation()), this.particle.getBillboardPosition()), this.$cameraPos, this.$cameraRight, this.$cameraUp, this.$cameraFacing);
            }

            @NotNull
            public final Vec3 getWorldNormal() {
                return this.particle.getNormal();
            }

            public final float getAlignedDistance() {
                return this.particle.getDistance();
            }

            public final float getFallbackSortZ() {
                return this.minZ + this.maxZ;
            }

            public final float getMinX() {
                return this.minX;
            }

            public final void setMinX(float f) {
                this.minX = f;
            }

            public final float getMaxX() {
                return this.maxX;
            }

            public final void setMaxX(float f) {
                this.maxX = f;
            }

            public final boolean isFullyBehindCamera() {
                return this.maxZ < 0.0f;
            }

            public final boolean isFullyBehind(@NotNull Billboard other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return this.minZ > other.maxZ;
            }

            public final boolean overlapsVerticallyWith(@NotNull Billboard other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return this.maxY > other.minY && this.minY < other.maxY;
            }

            public final float getDepthFactor() {
                return this.depthFactor;
            }

            @NotNull
            public final Vec2 centerOfOverlap(@NotNull Billboard other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                float overlapMinX = Math.max(this.minX, other.minX);
                float overlapMaxX = Math.min(this.maxX, other.maxX);
                float overlapMinY = Math.max(this.minY, other.minY);
                float overlapMaxY = Math.min(this.maxY, other.maxY);
                return Vectors.vec2((overlapMinX + overlapMaxX) * 0.5f, (overlapMinY + overlapMaxY) * 0.5f);
            }
        }
        ArrayList<Billboard> billboards = new ArrayList<Billboard>(particles.size());
        Iterable $this$forEach$iv = particles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Particle particle = (Particle)element$iv;
            boolean bl = false;
            Billboard bb = new Billboard(cameraPos, cameraRight, cameraUp, cameraFacing, billboards.size(), particle);
            if (bb.isFullyBehindCamera()) continue;
            billboards.add(bb);
        }
        if (billboards.size() < 2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = billboards;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Billboard billboard = (Billboard)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getParticle());
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$sortedBy$iv = billboards;
        int $i$f$sortedBy = 0;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Billboard it = (Billboard)a;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getMinX());
                it = (Billboard)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getMinX()));
            }
        });
        $i$f$sortedBy = sorted.size();
        for (int i2 = 0; i2 < $i$f$sortedBy; ++i2) {
            Billboard a = (Billboard)sorted.get(i2);
            int j = i2;
            while (++j < sorted.size() && ((Billboard)sorted.get(j)).getMinX() <= a.getMaxX()) {
                float bDepth;
                Billboard b = (Billboard)sorted.get(j);
                if (!a.overlapsVerticallyWith(b)) continue;
                if (Intrinsics.areEqual((Object)a.getWorldNormal(), (Object)b.getWorldNormal())) {
                    if (a.getAlignedDistance() >= b.getAlignedDistance()) {
                        a.setBehind(b);
                        continue;
                    }
                    b.setBehind(a);
                    continue;
                }
                if (a.isFullyBehind(b)) {
                    a.setBehind(b);
                    continue;
                }
                if (b.isFullyBehind(a)) {
                    b.setBehind(a);
                    continue;
                }
                Vec2 vec2 = a.centerOfOverlap(b);
                float x = vec2.component1();
                float y = vec2.component2();
                MutableVec3 rayDir = MutableVectors.plusSelf(MutableVectors.plusSelf(MutableVectors.mutableVec3(MutableVectors.times((Vec3)cameraRight, x)), MutableVectors.times((Vec3)cameraUp, y)), cameraFacing);
                float aDepth = a.getDepthFactor() / Vectors.dot(rayDir, a.getWorldNormal());
                if (aDepth >= (bDepth = b.getDepthFactor() / Vectors.dot(rayDir, b.getWorldNormal()))) {
                    a.setBehind(b);
                    continue;
                }
                b.setBehind(a);
            }
        }
        ArrayList<Particle> resultList = new ArrayList<Particle>(billboards.size());
        ArrayDeque stack = new ArrayDeque(billboards.size());
        Ref.IntRef index2 = new Ref.IntRef();
        for (Billboard v : billboards) {
            if (v.getSortIndex() != -1) continue;
            Intrinsics.checkNotNull((Object)v);
            ParticleSystem.translucencySortBillboardParticles$strongConnect(index2, (ArrayDeque<Billboard>)stack, resultList, billboards, v);
        }
        CollectionsKt.reverse((List)resultList);
        return resultList;
    }

    private static final MutableVec3 translucencySortBillboardParticles$projectToScreenSpaceSelf(MutableVec3 $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf, Vec3 $cameraPos, MutableVec3 cameraRight, MutableVec3 cameraUp, Vec3 $cameraFacing) {
        MutableVec3 mutableVec3;
        MutableVec3 rel = MutableVectors.minus($this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf, $cameraPos);
        float xView = Vectors.dot(rel, cameraRight);
        float yView = Vectors.dot(rel, cameraUp);
        float zView = Vectors.dot(rel, $cameraFacing);
        if (zView <= 0.0f) {
            MutableVec3 mutableVec32;
            MutableVec3 $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf_u24lambda_u243 = mutableVec32 = $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf;
            boolean bl = false;
            $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf_u24lambda_u243.setX(0.0f);
            $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf_u24lambda_u243.setY(0.0f);
            $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf_u24lambda_u243.setZ(zView);
            return mutableVec32;
        }
        float xScreen = xView / zView;
        float yScreen = yView / zView;
        MutableVec3 $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf_u24lambda_u244 = mutableVec3 = $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf;
        boolean bl = false;
        $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf_u24lambda_u244.setX(xScreen);
        $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf_u24lambda_u244.setY(yScreen);
        $this$translucencySortBillboardParticles_u24projectToScreenSpaceSelf_u24lambda_u244.setZ(zView);
        return mutableVec3;
    }

    private static final void translucencySortBillboardParticles$strongConnect(Ref.IntRef index2, ArrayDeque<translucencySortBillboardParticles.Billboard> stack, ArrayList<Particle> resultList, ArrayList<translucencySortBillboardParticles.Billboard> billboards, translucencySortBillboardParticles.Billboard v) {
        v.setSortIndex(index2.element);
        v.setLowLink(index2.element);
        int n = index2.element;
        index2.element = n + 1;
        stack.addLast((Object)v);
        v.setOnStack(true);
        v.forEachDependant((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(billboards, v, index2, stack, resultList){
            final /* synthetic */ ArrayList<Billboard> $billboards;
            final /* synthetic */ Billboard $v;
            final /* synthetic */ Ref.IntRef $index;
            final /* synthetic */ ArrayDeque<Billboard> $stack;
            final /* synthetic */ ArrayList<Particle> $resultList;
            {
                this.$billboards = $billboards;
                this.$v = $v;
                this.$index = $index;
                this.$stack = $stack;
                this.$resultList = $resultList;
                super(1);
            }

            public final void invoke(int i2) {
                Billboard billboard = this.$billboards.get(i2);
                Intrinsics.checkNotNullExpressionValue((Object)billboard, (String)"get(...)");
                Billboard w = billboard;
                if (w.getSortIndex() == -1) {
                    ParticleSystem.access$translucencySortBillboardParticles$strongConnect(this.$index, this.$stack, this.$resultList, this.$billboards, w);
                    this.$v.setLowLink(Math.min(this.$v.getLowLink(), w.getLowLink()));
                } else if (w.getOnStack()) {
                    this.$v.setLowLink(Math.min(this.$v.getLowLink(), w.getSortIndex()));
                }
            }
        }));
        if (v.getLowLink() == v.getSortIndex()) {
            Billboard w;
            Billboard w0 = (Billboard)stack.removeLast();
            w0.setOnStack(false);
            if (Intrinsics.areEqual((Object)w0, (Object)v)) {
                resultList.add(w0.getParticle());
                return;
            }
            Billboard[] billboardArray = new Billboard[]{w0};
            List sccNode = CollectionsKt.mutableListOf((Object[])billboardArray);
            do {
                w = (Billboard)stack.removeLast();
                w.setOnStack(false);
                sccNode.add(w);
            } while (!Intrinsics.areEqual((Object)w, (Object)v));
            List $this$sortBy$iv = sccNode;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Billboard it = (Billboard)a;
                        boolean bl = false;
                        Comparable comparable = Float.valueOf(it.getFallbackSortZ());
                        it = (Billboard)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getFallbackSortZ()));
                    }
                });
            }
            for (Billboard node : sccNode) {
                resultList.add(node.getParticle());
            }
        }
    }

    public static final /* synthetic */ List access$translucencySortBillboardParticles(ParticleSystem $this, Vec3 cameraFacing, Vec3 cameraPos, Quaternion cameraRot, Collection particles) {
        return $this.translucencySortBillboardParticles(cameraFacing, cameraPos, cameraRot, particles);
    }

    public static final /* synthetic */ MutableVec3 access$translucencySortBillboardParticles$projectToScreenSpaceSelf(MutableVec3 $receiver, Vec3 $cameraPos, MutableVec3 cameraRight, MutableVec3 cameraUp, Vec3 $cameraFacing) {
        return ParticleSystem.translucencySortBillboardParticles$projectToScreenSpaceSelf($receiver, $cameraPos, cameraRight, cameraUp, $cameraFacing);
    }

    public static final /* synthetic */ void access$translucencySortBillboardParticles$strongConnect(Ref.IntRef index2, ArrayDeque stack, ArrayList resultList, ArrayList billboards, translucencySortBillboardParticles.Billboard v) {
        ParticleSystem.translucencySortBillboardParticles$strongConnect(index2, (ArrayDeque<Billboard>)stack, resultList, billboards, v);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010&\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0001iBe\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010X\u001a\u0002052\u0006\u0010Y\u001a\u00020\u001dH\u0002J\u0018\u0010Z\u001a\u00020[2\u0006\u0010Y\u001a\u00020\u001d2\b\b\u0002\u0010\\\u001a\u000205J \u0010]\u001a\u00020[2\u0006\u0010^\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020`2\b\u0010a\u001a\u0004\u0018\u00010bJ \u0010]\u001a\u00020[2\u0006\u0010^\u001a\u00020\u001d2\u0006\u0010c\u001a\u00020C2\b\u0010a\u001a\u0004\u0018\u00010bJ&\u0010]\u001a\u00020[2\u0006\u0010^\u001a\u00020\u001d2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020C0B2\b\u0010a\u001a\u0004\u0018\u00010bJ\b\u0010e\u001a\u00020[H\u0002J\u000e\u0010f\u001a\u00020[2\u0006\u0010Y\u001a\u00020\u001dJ\u000e\u0010g\u001a\u00020[2\u0006\u0010^\u001a\u00020\u001dJ\u000e\u0010h\u001a\u0002052\u0006\u0010Y\u001a\u00020\u001dR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR+\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R+\u0010%\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010$\u001a\u0004\b&\u0010 \"\u0004\b'\u0010\"R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\"\u0010@\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020C0B\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010:\"\u0004\bE\u0010FR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u000e\u0010K\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u0015\u0010\u0004\u001a\u00060\u0005R\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u000e\u0010T\u001a\u00020UX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010:\"\u0004\bW\u0010F\u00a8\u0006j"}, d2={"Lgg/essential/model/ParticleSystem$Emitter;", "", "system", "Lgg/essential/model/ParticleSystem;", "universe", "Lgg/essential/model/ParticleSystem$Universe;", "effectRef", "Lgg/essential/model/ParticleEffectWithReferencedEffects;", "textureSource", "Lkotlin/Function0;", "Lgg/essential/model/backend/RenderBackend$Texture;", "sourceEntity", "Lgg/essential/model/molang/MolangQueryEntity;", "position", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "rotation", "Lgg/essential/model/util/Quaternion;", "velocity", "locator", "Lgg/essential/model/ParticleSystem$Locator;", "locatorOffset", "(Lgg/essential/model/ParticleSystem;Lgg/essential/model/ParticleSystem$Universe;Lgg/essential/model/ParticleEffectWithReferencedEffects;Lkotlin/jvm/functions/Function0;Lgg/essential/model/molang/MolangQueryEntity;Ldev/folomeev/kotgl/matrix/vectors/Vec3;Lgg/essential/model/util/Quaternion;Ldev/folomeev/kotgl/matrix/vectors/Vec3;Lgg/essential/model/ParticleSystem$Locator;Ldev/folomeev/kotgl/matrix/vectors/Vec3;)V", "activeParticles", "", "getActiveParticles", "()I", "setActiveParticles", "(I)V", "<set-?>", "", "activeTime", "getActiveTime", "()F", "setActiveTime", "(F)V", "activeTime$delegate", "Lgg/essential/model/molang/Variables$Variable;", "age", "getAge", "setAge", "age$delegate", "components", "Lgg/essential/model/file/ParticleEffectComponents;", "cooldownTime", "curveVariables", "Lgg/essential/model/CurveVariables;", "effect", "Lgg/essential/model/ParticleEffect;", "getEffect", "()Lgg/essential/model/ParticleEffect;", "getEffectRef", "()Lgg/essential/model/ParticleEffectWithReferencedEffects;", "firedCreationEvents", "", "firedExpirationEvents", "getLocator", "()Lgg/essential/model/ParticleSystem$Locator;", "getLocatorOffset", "()Ldev/folomeev/kotgl/matrix/vectors/Vec3;", "maxParticles", "molang", "Lgg/essential/model/molang/MolangContext;", "getMolang", "()Lgg/essential/model/molang/MolangContext;", "nextTimelineEvent", "", "", "", "getPosition", "setPosition", "(Ldev/folomeev/kotgl/matrix/vectors/Vec3;)V", "getRotation", "()Lgg/essential/model/util/Quaternion;", "setRotation", "(Lgg/essential/model/util/Quaternion;)V", "sleepTime", "getSourceEntity", "()Lgg/essential/model/molang/MolangQueryEntity;", "getSystem", "()Lgg/essential/model/ParticleSystem;", "getTextureSource", "()Lkotlin/jvm/functions/Function0;", "getUniverse", "()Lgg/essential/model/ParticleSystem$Universe;", "variables", "Lgg/essential/model/molang/Variables;", "getVelocity", "setVelocity", "doUpdate", "dt", "emit", "", "inheritVelocity", "fire", "timeSince", "event", "Lgg/essential/model/file/ParticlesFile$Event;", "particle", "Lgg/essential/model/ParticleSystem$Particle;", "eventName", "events", "fireTimelineEvents", "skip", "startLoop", "update", "LocatorFor", "cosmetics"})
    @SourceDebugExtension(value={"SMAP\nParticleSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleSystem.kt\ngg/essential/model/ParticleSystem$Emitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1560:1\n1#2:1561\n1849#3,2:1562\n1849#3,2:1564\n*S KotlinDebug\n*F\n+ 1 ParticleSystem.kt\ngg/essential/model/ParticleSystem$Emitter\n*L\n786#1:1562,2\n794#1:1564,2\n*E\n"})
    private static final class Emitter {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ParticleSystem system;
        @NotNull
        private final Universe universe;
        @NotNull
        private final ParticleEffectWithReferencedEffects effectRef;
        @NotNull
        private final Function0<RenderBackend.Texture> textureSource;
        @NotNull
        private final MolangQueryEntity sourceEntity;
        @NotNull
        private Vec3 position;
        @NotNull
        private Quaternion rotation;
        @NotNull
        private Vec3 velocity;
        @Nullable
        private final Locator locator;
        @Nullable
        private final Vec3 locatorOffset;
        @NotNull
        private final ParticleEffect effect;
        @NotNull
        private final ParticleEffectComponents components;
        @NotNull
        private final CurveVariables curveVariables;
        @NotNull
        private final Variables variables;
        @NotNull
        private final MolangContext molang;
        private int activeParticles;
        private boolean firedCreationEvents;
        private boolean firedExpirationEvents;
        @NotNull
        private final Variables.Variable age$delegate;
        @NotNull
        private final Variables.Variable activeTime$delegate;
        private float sleepTime;
        private float maxParticles;
        private float cooldownTime;
        @Nullable
        private Map.Entry<Float, ? extends List<String>> nextTimelineEvent;

        public Emitter(@NotNull ParticleSystem system, @NotNull Universe universe, @NotNull ParticleEffectWithReferencedEffects effectRef, @NotNull Function0<? extends RenderBackend.Texture> textureSource2, @NotNull MolangQueryEntity sourceEntity, @NotNull Vec3 position2, @NotNull Quaternion rotation, @NotNull Vec3 velocity, @Nullable Locator locator, @Nullable Vec3 locatorOffset) {
            Intrinsics.checkNotNullParameter((Object)system, (String)"system");
            Intrinsics.checkNotNullParameter((Object)universe, (String)"universe");
            Intrinsics.checkNotNullParameter((Object)effectRef, (String)"effectRef");
            Intrinsics.checkNotNullParameter(textureSource2, (String)"textureSource");
            Intrinsics.checkNotNullParameter((Object)sourceEntity, (String)"sourceEntity");
            Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
            Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
            Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
            this.system = system;
            this.universe = universe;
            this.effectRef = effectRef;
            this.textureSource = textureSource2;
            this.sourceEntity = sourceEntity;
            this.position = position2;
            this.rotation = rotation;
            this.velocity = velocity;
            this.locator = locator;
            this.locatorOffset = locatorOffset;
            this.effect = this.effectRef.getParticleEffect();
            this.components = this.effect.getComponents();
            this.curveVariables = new CurveVariables((Function0<MolangContext>)((Function0)new Function0<MolangContext>(this){
                final /* synthetic */ Emitter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MolangContext invoke() {
                    return this.this$0.getMolang();
                }
            }), this.effect.getCurves());
            this.variables = new VariablesMap(null, 1, null).fallbackBackTo(this.curveVariables);
            this.molang = new MolangContext(MolangQuery.Empty.INSTANCE, this.variables);
            this.variables.set("entity_scale", 1.0f);
            Object object = this.components.getEmitterInitialization();
            if (object != null && (object = ((ParticleEffectComponents.EmitterInitialization)object).getCreationExpression()) != null) {
                ((Molang)object).eval(this.molang);
            }
            this.age$delegate = this.variables.getOrPut("emitter_age", 0.0f);
            this.activeTime$delegate = this.variables.getOrPut("emitter_lifetime", 0.0f);
        }

        @NotNull
        public final ParticleSystem getSystem() {
            return this.system;
        }

        @NotNull
        public final Universe getUniverse() {
            return this.universe;
        }

        @NotNull
        public final ParticleEffectWithReferencedEffects getEffectRef() {
            return this.effectRef;
        }

        @NotNull
        public final Function0<RenderBackend.Texture> getTextureSource() {
            return this.textureSource;
        }

        @NotNull
        public final MolangQueryEntity getSourceEntity() {
            return this.sourceEntity;
        }

        @NotNull
        public final Vec3 getPosition() {
            return this.position;
        }

        public final void setPosition(@NotNull Vec3 vec3) {
            Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
            this.position = vec3;
        }

        @NotNull
        public final Quaternion getRotation() {
            return this.rotation;
        }

        public final void setRotation(@NotNull Quaternion quaternion) {
            Intrinsics.checkNotNullParameter((Object)quaternion, (String)"<set-?>");
            this.rotation = quaternion;
        }

        @NotNull
        public final Vec3 getVelocity() {
            return this.velocity;
        }

        public final void setVelocity(@NotNull Vec3 vec3) {
            Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
            this.velocity = vec3;
        }

        @Nullable
        public final Locator getLocator() {
            return this.locator;
        }

        @Nullable
        public final Vec3 getLocatorOffset() {
            return this.locatorOffset;
        }

        @NotNull
        public final ParticleEffect getEffect() {
            return this.effect;
        }

        @NotNull
        public final MolangContext getMolang() {
            return this.molang;
        }

        public final int getActiveParticles() {
            return this.activeParticles;
        }

        public final void setActiveParticles(int n) {
            this.activeParticles = n;
        }

        private final float getAge() {
            return this.age$delegate.getValue(this, $$delegatedProperties[0]);
        }

        private final void setAge(float f) {
            this.age$delegate.setValue(this, $$delegatedProperties[0], f);
        }

        private final float getActiveTime() {
            return this.activeTime$delegate.getValue(this, $$delegatedProperties[1]);
        }

        private final void setActiveTime(float f) {
            this.activeTime$delegate.setValue(this, $$delegatedProperties[1], f);
        }

        /*
         * WARNING - void declaration
         */
        public final void startLoop(float timeSince) {
            float f;
            Object object;
            for (int i2 = 1; i2 < 5; ++i2) {
                this.variables.set("emitter_random_" + i2, this.system.random.nextFloat());
            }
            this.setAge(0.0f);
            Object object2 = this.components.getEmitterLifetimeLooping();
            this.setActiveTime(object2 != null && (object2 = ((ParticleEffectComponents.EmitterLifetimeLooping)object2).getActiveTime()) != null ? ((Molang)object2).eval(this.molang) : ((object = this.components.getEmitterLifetimeOnce()) != null && (object = ((ParticleEffectComponents.EmitterLifetimeOnce)object).getActiveTime()) != null ? ((Molang)object).eval(this.molang) : Float.POSITIVE_INFINITY));
            Object object3 = this.components.getEmitterLifetimeLooping();
            this.sleepTime = object3 != null && (object3 = ((ParticleEffectComponents.EmitterLifetimeLooping)object3).getSleepTime()) != null ? ((Molang)object3).eval(this.molang) : 0.0f;
            Object object4 = this.components.getEmitterRateInstant();
            int n = object4 != null && (object4 = ((ParticleEffectComponents.EmitterRateInstant)object4).getNumParticles()) != null ? (int)((Molang)object4).eval(this.molang) : 0;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                Emitter.emit$default(this, timeSince, false, 2, null);
            }
            Object object5 = this.components.getEmitterRateSteady();
            this.maxParticles = object5 != null && (object5 = ((ParticleEffectComponents.EmitterRateSteady)object5).getMaxParticles()) != null ? ((Molang)object5).eval(this.molang) : Float.POSITIVE_INFINITY;
            Emitter emitter = this;
            Object object6 = this.components.getEmitterRateSteady();
            if (object6 != null && (object6 = ((ParticleEffectComponents.EmitterRateSteady)object6).getSpawnRate()) != null) {
                void it;
                float f2 = ((Molang)object6).eval(this.molang);
                Emitter emitter2 = emitter;
                boolean bl = false;
                float f3 = 1.0f / it;
                emitter = emitter2;
                f = f3;
            } else {
                f = emitter.cooldownTime = Float.POSITIVE_INFINITY;
            }
            if (!this.firedCreationEvents) {
                this.firedCreationEvents = true;
                this.fire(timeSince, this.components.getEmitterLifetimeEvents().getCreationEvents(), null);
            }
            this.nextTimelineEvent = this.components.getEmitterLifetimeEvents().getTimeline().lowestEntry();
        }

        public final void skip(float dt) {
            this.setAge(this.getAge() + dt);
        }

        public final boolean update(float dt) {
            boolean alive = this.doUpdate(dt);
            if (!alive && !this.firedExpirationEvents) {
                this.firedExpirationEvents = true;
                this.fire(0.0f, this.components.getEmitterLifetimeEvents().getExpirationEvents(), null);
            }
            return alive;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean doUpdate(float dt) {
            this.setAge(this.getAge() + dt);
            this.curveVariables.update();
            Object object = this.components.getEmitterInitialization();
            if (object != null && (object = ((ParticleEffectComponents.EmitterInitialization)object).getPerUpdateExpression()) != null) {
                ((Molang)object).eval(this.molang);
            }
            if (this.locator != null) {
                Pair<Vec3, Quaternion> posRot = this.locator.getPositionAndRotation();
                this.position = (Vec3)posRot.getFirst();
                this.rotation = (Quaternion)posRot.getSecond();
                this.velocity = this.locator.getVelocity();
                if (this.locatorOffset != null) {
                    this.position = MutableVectors.plus(this.position, KotglKt.rotateBy(this.locatorOffset, this.rotation));
                }
                if (!this.locator.isValid()) {
                    return false;
                }
            }
            this.fireTimelineEvents();
            ParticleEffectComponents.EmitterLifetimeExpression emitterLifetimeExpression = this.components.getEmitterLifetimeExpression();
            if (emitterLifetimeExpression != null) {
                ParticleEffectComponents.EmitterLifetimeExpression config = emitterLifetimeExpression;
                boolean bl = false;
                if (!(config.getExpirationExpression().eval(this.molang) == 0.0f)) {
                    return false;
                }
                if (config.getActivationExpression().eval(this.molang) == 0.0f) {
                    return true;
                }
            }
            if (this.getAge() > this.getActiveTime()) {
                if (this.components.getEmitterLifetimeOnce() != null) {
                    return false;
                }
                float timeSinceNewLoop = this.getAge() - this.getActiveTime() - this.sleepTime;
                if (timeSinceNewLoop < 0.0f) {
                    return true;
                }
                this.startLoop(timeSinceNewLoop);
            }
            this.cooldownTime -= dt;
            while (this.cooldownTime < 0.0f) {
                if ((float)this.activeParticles < this.maxParticles) {
                    float f;
                    float timeSinceEmit = -this.cooldownTime;
                    this.setAge(this.getAge() - timeSinceEmit);
                    Emitter.emit$default(this, timeSinceEmit, false, 2, null);
                    Emitter emitter = this;
                    float f2 = this.cooldownTime;
                    Object object2 = this.components.getEmitterRateSteady();
                    if (object2 != null && (object2 = ((ParticleEffectComponents.EmitterRateSteady)object2).getSpawnRate()) != null) {
                        void it;
                        float f3 = ((Molang)object2).eval(this.molang);
                        float f4 = f2;
                        Emitter emitter2 = emitter;
                        boolean bl = false;
                        float f5 = 1.0f / it;
                        emitter = emitter2;
                        f2 = f4;
                        f = f5;
                    } else {
                        f = Float.POSITIVE_INFINITY;
                    }
                    emitter.cooldownTime = f2 + f;
                    this.setAge(this.getAge() + timeSinceEmit);
                    continue;
                }
                this.cooldownTime = 0.0f;
            }
            return true;
        }

        public final void emit(float dt, boolean inheritVelocity) {
            Locator locator = this.locator;
            boolean bl = locator != null ? !locator.isVisible() : false;
            if (bl) {
                return;
            }
            ParticleEffectComponents.EmitterLocalSpace emitterLocalSpace = this.components.getEmitterLocalSpace();
            Locator localSpace = (emitterLocalSpace != null ? emitterLocalSpace.getPosition() : false) ? this.locator : null;
            Particle particle = new Particle(this, localSpace);
            particle.emit(inheritVelocity);
            this.universe.addParticle(particle);
            Emitter emitter = particle.getEmitter();
            int n = emitter.activeParticles;
            emitter.activeParticles = n + 1;
            particle.update(dt);
        }

        public static /* synthetic */ void emit$default(Emitter emitter, float f, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            emitter.emit(f, bl);
        }

        private final void fireTimelineEvents() {
            while (this.nextTimelineEvent != null) {
                Map.Entry<Float, ? extends List<String>> entry2;
                float time2 = ((Number)entry2.getKey()).floatValue();
                List<String> events2 = entry2.getValue();
                float timeSinceEvent = this.getAge() - time2;
                if (timeSinceEvent < 0.0f) {
                    return;
                }
                this.fire(timeSinceEvent, events2, null);
                this.nextTimelineEvent = this.components.getEmitterLifetimeEvents().getTimeline().higherEntry((Float)((Comparable)Float.valueOf(time2)));
            }
            return;
        }

        public final void fire(float timeSince, @NotNull List<String> events2, @Nullable Particle particle) {
            Intrinsics.checkNotNullParameter(events2, (String)"events");
            Iterable $this$forEach$iv = events2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.fire(timeSince, it, particle);
            }
        }

        public final void fire(float timeSince, @NotNull String eventName, @Nullable Particle particle) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            ParticlesFile.Event event = this.effect.getEvents().get(eventName);
            if (event == null) {
                return;
            }
            ParticlesFile.Event event2 = event;
            this.fire(timeSince, event2, particle);
        }

        /*
         * WARNING - void declaration
         */
        public final void fire(float timeSince, @NotNull ParticlesFile.Event event, @Nullable Particle particle) {
            block18: {
                Object object;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                List<ParticlesFile.Event> list = event.getSequence();
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Iterable element$iv : $this$forEach$iv) {
                        ParticlesFile.Event it = (ParticlesFile.Event)((Object)element$iv);
                        boolean bl = false;
                        this.fire(timeSince, it, particle);
                    }
                }
                List<ParticlesFile.Event.RandomizeOption> list2 = event.getRandomize();
                if (list2 != null) {
                    Iterable element$iv;
                    List<ParticlesFile.Event.RandomizeOption> options2 = list2;
                    boolean bl = false;
                    element$iv = options2;
                    double d = 0.0;
                    object = element$iv.iterator();
                    while (object.hasNext()) {
                        void it;
                        Object t = object.next();
                        ParticlesFile.Event.RandomizeOption randomizeOption = (ParticlesFile.Event.RandomizeOption)t;
                        double d2 = d;
                        boolean bl2 = false;
                        double d3 = it.getWeight();
                        d = d2 + d3;
                    }
                    double weights = d;
                    double choice = (double)this.system.random.nextFloat() * weights;
                    for (ParticlesFile.Event.RandomizeOption option2 : options2) {
                        if (!((choice -= (double)option2.getWeight()) <= 0.0)) continue;
                        this.fire(timeSince, option2.getValue(), particle);
                        break;
                    }
                }
                Molang molang = event.getExpression();
                if (molang != null) {
                    Molang expr = molang;
                    boolean bl = false;
                    this.setAge(this.getAge() - timeSince);
                    expr.eval(this.molang);
                    this.setAge(this.getAge() + timeSince);
                }
                ParticlesFile.Event.Particle particle2 = event.getParticle();
                if (particle2 != null) {
                    ParticlesFile.Event.Particle config = particle2;
                    boolean bl = false;
                    ParticleEffectWithReferencedEffects particleEffectWithReferencedEffects = this.effectRef.getOtherParticleByReference(config.getEffect());
                    if (particleEffectWithReferencedEffects != null) {
                        Emitter emitter;
                        ParticleEffectWithReferencedEffects targetEffectRef = particleEffectWithReferencedEffects;
                        if (config.getType().isBound() && this.locator != null) {
                            MutableVec3 mutableVec3;
                            Vec3 vec3;
                            Object object2;
                            Object object3 = particle;
                            if (object3 == null || (object3 = ((Particle)object3).getGlobalPosition()) == null) {
                                object3 = this.position;
                            }
                            if ((object2 = particle) == null || (object2 = ((Particle)object2).getGlobalVelocity()) == null) {
                                object2 = this.velocity;
                            }
                            Vec3 vec32 = particle != null && (vec3 = particle.getGlobalPosition()) != null && (mutableVec3 = MutableVectors.minus(vec3, this.locator.getPosition())) != null && (object = KotglKt.rotateSelfBy(mutableVec3, this.locator.getRotation().invert())) != null ? (Vec3)object : this.locatorOffset;
                            emitter = new Emitter(this.system, this.universe, targetEffectRef, this.textureSource, this.sourceEntity, (Vec3)object3, this.rotation, (Vec3)object2, this.locator, vec32);
                        } else {
                            Object object4 = particle;
                            if (object4 == null || (object4 = ((Particle)object4).getGlobalPosition()) == null) {
                                object4 = this.position;
                            }
                            Quaternion quaternion = Quaternion.Companion.getIdentity();
                            Object object5 = particle;
                            if (object5 == null || (object5 = ((Particle)object5).getGlobalVelocity()) == null) {
                                object5 = this.velocity;
                            }
                            emitter = new Emitter(this.system, this.universe, targetEffectRef, this.textureSource, this.sourceEntity, (Vec3)object4, quaternion, (Vec3)object5, null, null);
                        }
                        Emitter targetEmitter = emitter;
                        config.getPreEffectExpression().eval(targetEmitter.molang);
                        if (config.getType().isParticle()) {
                            targetEmitter.emit(timeSince, config.getType().getInheritVelocity());
                        } else {
                            this.universe.getEmitters().add(targetEmitter);
                            targetEmitter.startLoop(timeSince);
                            targetEmitter.update(timeSince);
                        }
                    }
                }
                ParticlesFile.Event.Sound sound = event.getSound();
                if (sound == null) break block18;
                ParticlesFile.Event.Sound config = sound;
                boolean bl = false;
                SoundEffect soundEffect = this.effectRef.getReferencedSounds().get(config.getEvent());
                if (soundEffect != null) {
                    SoundEffect targetSound = soundEffect;
                    this.system.playSound.invoke((Object)new ModelAnimationState.SoundEvent(this.universe.getTimeSource(), this.universe.getLastUpdate() - timeSince, this.sourceEntity, targetSound, particle != null ? (Locator)new Particle.LocatorFor(particle) : (Locator)new LocatorFor(this)));
                }
            }
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Emitter.class, "age", "getAge()F", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Emitter.class, "activeTime", "getActiveTime()F", 0)))};
            $$delegatedProperties = kPropertyArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lgg/essential/model/ParticleSystem$Emitter$LocatorFor;", "Lgg/essential/model/ParticleSystem$Locator;", "emitter", "Lgg/essential/model/ParticleSystem$Emitter;", "(Lgg/essential/model/ParticleSystem$Emitter;)V", "getEmitter", "()Lgg/essential/model/ParticleSystem$Emitter;", "isValid", "", "()Z", "isVisible", "parent", "getParent", "()Lgg/essential/model/ParticleSystem$Locator;", "position", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "getPosition", "()Ldev/folomeev/kotgl/matrix/vectors/Vec3;", "rotation", "Lgg/essential/model/util/Quaternion;", "getRotation", "()Lgg/essential/model/util/Quaternion;", "velocity", "getVelocity", "cosmetics"})
        public static final class LocatorFor
        implements Locator {
            @NotNull
            private final Emitter emitter;

            public LocatorFor(@NotNull Emitter emitter) {
                Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
                this.emitter = emitter;
            }

            @NotNull
            public final Emitter getEmitter() {
                return this.emitter;
            }

            @Override
            @Nullable
            public Locator getParent() {
                return this.emitter.getLocator();
            }

            @Override
            public boolean isValid() {
                return !this.emitter.firedExpirationEvents;
            }

            @Override
            @NotNull
            public Vec3 getPosition() {
                return this.emitter.getPosition();
            }

            @Override
            @NotNull
            public Quaternion getRotation() {
                return this.emitter.getRotation();
            }

            @Override
            @NotNull
            public Vec3 getVelocity() {
                return this.emitter.getVelocity();
            }

            @Override
            public boolean isVisible() {
                Locator locator = this.getParent();
                return locator != null ? locator.isVisible() : true;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001:\u0001\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lgg/essential/model/ParticleSystem$Locator;", "", "isValid", "", "()Z", "isVisible", "parent", "getParent", "()Lgg/essential/model/ParticleSystem$Locator;", "position", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "getPosition", "()Ldev/folomeev/kotgl/matrix/vectors/Vec3;", "positionAndRotation", "Lkotlin/Pair;", "Lgg/essential/model/util/Quaternion;", "getPositionAndRotation", "()Lkotlin/Pair;", "rotation", "getRotation", "()Lgg/essential/model/util/Quaternion;", "velocity", "getVelocity", "Zero", "cosmetics"})
    public static interface Locator {
        @Nullable
        public Locator getParent();

        public boolean isValid();

        @NotNull
        public Vec3 getPosition();

        @NotNull
        public Quaternion getRotation();

        @NotNull
        public Vec3 getVelocity();

        public boolean isVisible();

        @NotNull
        default public Pair<Vec3, Quaternion> getPositionAndRotation() {
            return new Pair((Object)this.getPosition(), (Object)this.getRotation());
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0014"}, d2={"Lgg/essential/model/ParticleSystem$Locator$Zero;", "Lgg/essential/model/ParticleSystem$Locator;", "()V", "isValid", "", "()Z", "isVisible", "parent", "getParent", "()Lgg/essential/model/ParticleSystem$Locator;", "position", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "getPosition", "()Ldev/folomeev/kotgl/matrix/vectors/Vec3;", "rotation", "Lgg/essential/model/util/Quaternion;", "getRotation", "()Lgg/essential/model/util/Quaternion;", "velocity", "getVelocity", "cosmetics"})
        public static final class Zero
        implements Locator {
            @NotNull
            public static final Zero INSTANCE = new Zero();

            private Zero() {
            }

            @Override
            @Nullable
            public Locator getParent() {
                return null;
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            @NotNull
            public Vec3 getPosition() {
                return Vectors.vecZero();
            }

            @Override
            @NotNull
            public Quaternion getRotation() {
                return Quaternion.Companion.getIdentity();
            }

            @Override
            @NotNull
            public Vec3 getVelocity() {
                return Vectors.vecZero();
            }

            @Override
            public boolean isVisible() {
                return true;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010Y\u001a\u0002042\u0006\u0010Z\u001a\u00020\bH\u0002J\u000e\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u000204J\b\u0010^\u001a\u00020\\H\u0002J,\u0010_\u001a\u0002042\u0006\u0010Z\u001a\u00020\b2\u0006\u0010`\u001a\u00020\u00112\b\b\u0002\u0010a\u001a\u00020b2\b\b\u0002\u0010c\u001a\u000204H\u0002J\u0016\u0010d\u001a\u00020\\2\u0006\u0010e\u001a\u00020\u00112\u0006\u0010f\u001a\u00020\u0017J6\u0010g\u001a\u00020\\2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u00112\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u0002042\u0006\u0010p\u001a\u000204J\u000e\u0010q\u001a\u0002042\u0006\u0010Z\u001a\u00020\bR+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u000b\"\u0004\b.\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0019R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00106\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0013R\u0011\u00108\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0013R+\u0010:\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b=\u0010\u000f\u001a\u0004\b;\u0010\u000b\"\u0004\b<\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010B\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010F\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u0013\"\u0004\bH\u0010\u0015R\u0011\u0010I\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010+R\u0013\u0010K\u001a\u0004\u0018\u00010L\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u001a\u0010O\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u000b\"\u0004\bQ\u0010\rR\u001a\u0010R\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u000b\"\u0004\bT\u0010\rR\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010W\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010+\u00a8\u0006s"}, d2={"Lgg/essential/model/ParticleSystem$Particle;", "", "emitter", "Lgg/essential/model/ParticleSystem$Emitter;", "localSpace", "Lgg/essential/model/ParticleSystem$Locator;", "(Lgg/essential/model/ParticleSystem$Emitter;Lgg/essential/model/ParticleSystem$Locator;)V", "<set-?>", "", "age", "getAge", "()F", "setAge", "(F)V", "age$delegate", "Lgg/essential/model/molang/Variables$Variable;", "billboardPosition", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "getBillboardPosition", "()Ldev/folomeev/kotgl/matrix/vectors/Vec3;", "setBillboardPosition", "(Ldev/folomeev/kotgl/matrix/vectors/Vec3;)V", "billboardRotation", "Lgg/essential/model/util/Quaternion;", "getBillboardRotation", "()Lgg/essential/model/util/Quaternion;", "setBillboardRotation", "(Lgg/essential/model/util/Quaternion;)V", "billboardSize", "Lgg/essential/lib/kotgl/matrix/vectors/Vec2;", "getBillboardSize", "()Ldev/folomeev/kotgl/matrix/vectors/Vec2;", "setBillboardSize", "(Ldev/folomeev/kotgl/matrix/vectors/Vec2;)V", "components", "Lgg/essential/model/file/ParticleEffectComponents;", "curveVariables", "Lgg/essential/model/CurveVariables;", "getCurveVariables", "()Lgg/essential/model/CurveVariables;", "direction", "Lgg/essential/lib/kotgl/matrix/vectors/mutables/MutableVec3;", "getDirection", "()Ldev/folomeev/kotgl/matrix/vectors/mutables/MutableVec3;", "distance", "getDistance", "setDistance", "getEmitter", "()Lgg/essential/model/ParticleSystem$Emitter;", "emitterRotationOnEmit", "getEmitterRotationOnEmit", "firedCreationEvents", "", "firedExpirationEvents", "globalPosition", "getGlobalPosition", "globalVelocity", "getGlobalVelocity", "lifetime", "getLifetime", "setLifetime", "lifetime$delegate", "getLocalSpace", "()Lgg/essential/model/ParticleSystem$Locator;", "molang", "Lgg/essential/model/molang/MolangContext;", "nextTimelineEvent", "", "", "", "normal", "getNormal", "setNormal", "position", "getPosition", "renderPass", "Lgg/essential/model/ParticleEffect$RenderPass;", "getRenderPass", "()Lgg/essential/model/ParticleEffect$RenderPass;", "rotationAngle", "getRotationAngle", "setRotationAngle", "rotationRate", "getRotationRate", "setRotationRate", "variables", "Lgg/essential/model/molang/Variables;", "velocity", "getVelocity", "doUpdate", "dt", "emit", "", "inheritVelocity", "fireTimelineEvents", "move", "acceleration", "iteration", "", "sliding", "prepareBillboard", "cameraPos", "cameraRot", "renderBillboard", "matrixStack", "Lgg/essential/model/util/UMatrixStack;", "vertexConsumer", "Lgg/essential/model/util/UVertexConsumer;", "cameraFacing", "cameraUuid", "Ljava/util/UUID;", "cameraFirstPerson", "hideParticlesInFirstPerson", "update", "LocatorFor", "cosmetics"})
    @SourceDebugExtension(value={"SMAP\nParticleSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleSystem.kt\ngg/essential/model/ParticleSystem$Particle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1560:1\n1#2:1561\n1849#3,2:1562\n*S KotlinDebug\n*F\n+ 1 ParticleSystem.kt\ngg/essential/model/ParticleSystem$Particle\n*L\n1241#1:1562,2\n*E\n"})
    private static final class Particle {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final Emitter emitter;
        @Nullable
        private final Locator localSpace;
        @Nullable
        private final ParticleEffect.RenderPass renderPass;
        @NotNull
        private final ParticleEffectComponents components;
        @NotNull
        private final CurveVariables curveVariables;
        @NotNull
        private final Variables variables;
        @NotNull
        private final MolangContext molang;
        private boolean firedCreationEvents;
        private boolean firedExpirationEvents;
        @Nullable
        private Map.Entry<Float, ? extends List<String>> nextTimelineEvent;
        @NotNull
        private final Variables.Variable age$delegate;
        @NotNull
        private final Variables.Variable lifetime$delegate;
        @NotNull
        private final MutableVec3 position;
        @NotNull
        private final MutableVec3 velocity;
        @NotNull
        private final MutableVec3 direction;
        @NotNull
        private final Quaternion emitterRotationOnEmit;
        private float rotationAngle;
        private float rotationRate;
        @NotNull
        private Vec3 billboardPosition;
        @NotNull
        private Quaternion billboardRotation;
        @NotNull
        private Vec2 billboardSize;
        @NotNull
        private Vec3 normal;
        private float distance;

        public Particle(@NotNull Emitter emitter, @Nullable Locator localSpace) {
            Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
            this.emitter = emitter;
            this.localSpace = localSpace;
            this.renderPass = this.emitter.getEffect().renderPass(this.emitter.getTextureSource());
            this.components = this.emitter.getEffect().getComponents();
            this.curveVariables = new CurveVariables((Function0<MolangContext>)((Function0)new Function0<MolangContext>(this){
                final /* synthetic */ Particle this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MolangContext invoke() {
                    return Particle.access$getMolang$p(this.this$0);
                }
            }), this.emitter.getEffect().getCurves());
            this.variables = new VariablesMap(null, 1, null).fallbackBackTo(this.curveVariables).fallbackBackTo(this.emitter.getMolang().getVariables());
            this.molang = new MolangContext(MolangQuery.Empty.INSTANCE, this.variables);
            this.age$delegate = this.variables.getOrPut("particle_age", 0.0f);
            this.lifetime$delegate = this.variables.getOrPut("particle_lifetime", 0.0f);
            for (int i2 = 1; i2 < 5; ++i2) {
                this.variables.set("particle_random_" + i2, this.emitter.getSystem().random.nextFloat());
            }
            this.setAge(0.0f);
            Object object = this.components.getParticleLifetimeExpression();
            this.setLifetime(object != null && (object = ((ParticleEffectComponents.ParticleLifetimeExpression)object).getMaxLifetime()) != null ? ((Molang)object).eval(this.molang) : 0.0f);
            this.nextTimelineEvent = this.components.getParticleLifetimeEvents().getTimeline().lowestEntry();
            this.position = MutableVectors.mutableVec3();
            this.velocity = MutableVectors.mutableVec3();
            this.direction = MutableVectors.mutableVec3();
            this.emitterRotationOnEmit = this.emitter.getRotation();
            Object object2 = this.components.getParticleInitialSpin();
            this.rotationAngle = object2 != null && (object2 = ((ParticleEffectComponents.ParticleInitialSpin)object2).getRotation()) != null ? ((Molang)object2).eval(this.molang) : 0.0f;
            Object object3 = this.components.getParticleInitialSpin();
            this.rotationRate = object3 != null && (object3 = ((ParticleEffectComponents.ParticleInitialSpin)object3).getRotationRate()) != null ? ((Molang)object3).eval(this.molang) : 0.0f;
            this.billboardPosition = Vectors.vec3();
            this.billboardRotation = Quaternion.Companion.getIdentity();
            this.billboardSize = Vectors.vec2();
            this.normal = Vectors.vecZero();
        }

        @NotNull
        public final Emitter getEmitter() {
            return this.emitter;
        }

        @Nullable
        public final Locator getLocalSpace() {
            return this.localSpace;
        }

        @Nullable
        public final ParticleEffect.RenderPass getRenderPass() {
            return this.renderPass;
        }

        @NotNull
        public final CurveVariables getCurveVariables() {
            return this.curveVariables;
        }

        private final float getAge() {
            return this.age$delegate.getValue(this, $$delegatedProperties[0]);
        }

        private final void setAge(float f) {
            this.age$delegate.setValue(this, $$delegatedProperties[0], f);
        }

        private final float getLifetime() {
            return this.lifetime$delegate.getValue(this, $$delegatedProperties[1]);
        }

        private final void setLifetime(float f) {
            this.lifetime$delegate.setValue(this, $$delegatedProperties[1], f);
        }

        @NotNull
        public final MutableVec3 getPosition() {
            return this.position;
        }

        @NotNull
        public final MutableVec3 getVelocity() {
            return this.velocity;
        }

        @NotNull
        public final MutableVec3 getDirection() {
            return this.direction;
        }

        @NotNull
        public final Vec3 getGlobalPosition() {
            return this.localSpace != null ? (Vec3)MutableVectors.plusSelf(KotglKt.rotateBy(this.position, this.localSpace.getRotation()), this.localSpace.getPosition()) : (Vec3)this.position;
        }

        @NotNull
        public final Vec3 getGlobalVelocity() {
            return this.localSpace != null ? (Vec3)KotglKt.rotateBy(this.velocity, this.localSpace.getRotation()) : (Vec3)this.velocity;
        }

        @NotNull
        public final Quaternion getEmitterRotationOnEmit() {
            return this.emitterRotationOnEmit;
        }

        public final float getRotationAngle() {
            return this.rotationAngle;
        }

        public final void setRotationAngle(float f) {
            this.rotationAngle = f;
        }

        public final float getRotationRate() {
            return this.rotationRate;
        }

        public final void setRotationRate(float f) {
            this.rotationRate = f;
        }

        @NotNull
        public final Vec3 getBillboardPosition() {
            return this.billboardPosition;
        }

        public final void setBillboardPosition(@NotNull Vec3 vec3) {
            Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
            this.billboardPosition = vec3;
        }

        @NotNull
        public final Quaternion getBillboardRotation() {
            return this.billboardRotation;
        }

        public final void setBillboardRotation(@NotNull Quaternion quaternion) {
            Intrinsics.checkNotNullParameter((Object)quaternion, (String)"<set-?>");
            this.billboardRotation = quaternion;
        }

        @NotNull
        public final Vec2 getBillboardSize() {
            return this.billboardSize;
        }

        public final void setBillboardSize(@NotNull Vec2 vec2) {
            Intrinsics.checkNotNullParameter((Object)vec2, (String)"<set-?>");
            this.billboardSize = vec2;
        }

        @NotNull
        public final Vec3 getNormal() {
            return this.normal;
        }

        public final void setNormal(@NotNull Vec3 vec3) {
            Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
            this.normal = vec3;
        }

        public final float getDistance() {
            return this.distance;
        }

        public final void setDistance(float f) {
            this.distance = f;
        }

        public final void emit(boolean inheritVelocity) {
            block23: {
                block22: {
                    float it;
                    MutableVec3 vec;
                    Object config;
                    Vec3 pos = null;
                    pos = Vectors.vecZero();
                    Vec3 dir = null;
                    dir = Vectors.vecZero();
                    Random random = this.emitter.getSystem().random;
                    ParticleEffectComponents.EmitterShapePoint emitterShapePoint = this.components.getEmitterShapePoint();
                    if (emitterShapePoint != null) {
                        config = emitterShapePoint;
                        boolean bl = false;
                        pos = ((ParticleEffectComponents.EmitterShapePoint)config).getOffset().eval(this.molang);
                        vec = MutableVectors.mutableVec3();
                        do {
                            MutableVectors.set(vec, (random.nextFloat() - 0.5f) * 2.0f, (random.nextFloat() - 0.5f) * 2.0f, (random.nextFloat() - 0.5f) * 2.0f);
                            it = Vectors.sqrLength(vec);
                            boolean bl2 = false;
                        } while (it > 1.0f || it == 0.0f);
                        MutableVectors.normalizeSelf(vec);
                        dir = Particle.emit$computeFor(((ParticleEffectComponents.EmitterShapePoint)config).getDirection(), this, vec);
                    }
                    ParticleEffectComponents.EmitterShapeBox emitterShapeBox = this.components.getEmitterShapeBox();
                    if (emitterShapeBox != null) {
                        config = emitterShapeBox;
                        boolean bl = false;
                        MutableVec3 point = MutableVectors.mutableVec3((random.nextFloat() - 0.5f) * 2.0f, (random.nextFloat() - 0.5f) * 2.0f, (random.nextFloat() - 0.5f) * 2.0f);
                        if (((ParticleEffectComponents.EmitterShapeBox)config).getSurfaceOnly()) {
                            int side = RandomKt.nextInt((Random)random, (IntRange)new IntRange(0, 5));
                            float value = side > 2 ? 1.0f : -1.0f;
                            switch (side % 3) {
                                case 0: {
                                    point.setX(value);
                                    break;
                                }
                                case 1: {
                                    point.setY(value);
                                    break;
                                }
                                case 2: {
                                    point.setZ(value);
                                }
                            }
                        }
                        MutableVectors.timesSelf(point, ((ParticleEffectComponents.EmitterShapeBox)config).getHalfDimensions().eval(this.molang));
                        pos = MutableVectors.plus(((ParticleEffectComponents.EmitterShapeBox)config).getOffset().eval(this.molang), point);
                        dir = Particle.emit$computeFor(((ParticleEffectComponents.EmitterShapeBox)config).getDirection(), this, point);
                    }
                    ParticleEffectComponents.EmitterShapeSphere emitterShapeSphere = this.components.getEmitterShapeSphere();
                    if (emitterShapeSphere != null) {
                        config = emitterShapeSphere;
                        boolean bl = false;
                        vec = MutableVectors.mutableVec3();
                        do {
                            MutableVectors.set(vec, (random.nextFloat() - 0.5f) * 2.0f, (random.nextFloat() - 0.5f) * 2.0f, (random.nextFloat() - 0.5f) * 2.0f);
                            it = Vectors.sqrLength(vec);
                            boolean bl3 = false;
                        } while (it > 1.0f || it == 0.0f);
                        if (((ParticleEffectComponents.EmitterShapeSphere)config).getSurfaceOnly()) {
                            MutableVectors.normalizeSelf(vec);
                        }
                        MutableVectors.timesSelf(vec, ((ParticleEffectComponents.EmitterShapeSphere)config).getRadius().eval(this.molang));
                        pos = MutableVectors.plus(((ParticleEffectComponents.EmitterShapeSphere)config).getOffset().eval(this.molang), vec);
                        dir = Particle.emit$computeFor(((ParticleEffectComponents.EmitterShapeSphere)config).getDirection(), this, vec);
                    }
                    ParticleEffectComponents.EmitterShapeDisc emitterShapeDisc = this.components.getEmitterShapeDisc();
                    if (emitterShapeDisc != null) {
                        config = emitterShapeDisc;
                        boolean bl = false;
                        float radius = ((ParticleEffectComponents.EmitterShapeDisc)config).getRadius().eval(this.molang);
                        MutableVec3 normal = MutableVectors.normalize(((ParticleEffectComponents.EmitterShapeDisc)config).getPlaneNormal().eval(this.molang));
                        MutableVec3 vec2 = MutableVectors.mutableVec3(1.0f, 0.0f, 0.0f);
                        if ((double)Math.abs(Vectors.dot(vec2, normal)) > 0.9) {
                            MutableVectors.set(vec2, 0.0f, 1.0f, 0.0f);
                        }
                        MutableVectors.normalizeSelf(MutableVectors.crossSelf(vec2, normal));
                        KotglKt.rotateSelfBy(vec2, Quaternion.Companion.fromAxisAngle(normal, random.nextFloat() * (float)2 * (float)Math.PI));
                        MutableVectors.timesSelf(vec2, radius * (((ParticleEffectComponents.EmitterShapeDisc)config).getSurfaceOnly() ? 1.0f : (float)Math.sqrt(random.nextFloat())));
                        pos = MutableVectors.plus(((ParticleEffectComponents.EmitterShapeDisc)config).getOffset().eval(this.molang), vec2);
                        dir = Particle.emit$computeFor(((ParticleEffectComponents.EmitterShapeDisc)config).getDirection(), this, vec2);
                    }
                    ParticleEffectComponents.EmitterLocalSpace emitterLocalSpace = this.components.getEmitterLocalSpace();
                    if (!(emitterLocalSpace != null ? emitterLocalSpace.getRotation() : false)) {
                        pos = KotglKt.rotateBy(pos, this.emitter.getRotation());
                        dir = KotglKt.rotateBy(dir, this.emitter.getRotation());
                    }
                    if (this.localSpace == null) {
                        pos = MutableVectors.plus(pos, this.emitter.getPosition());
                    } else if (this.emitter.getLocatorOffset() != null) {
                        pos = MutableVectors.plus(pos, this.emitter.getLocatorOffset());
                    }
                    MutableVectors.set(this.position, pos);
                    MutableVectors.normalizeSelf(MutableVectors.set(this.direction, dir));
                    MutableVectors.timesSelf(MutableVectors.set(this.velocity, this.direction), this.components.getParticleInitialSpeed().eval(this.molang));
                    if (inheritVelocity) break block22;
                    ParticleEffectComponents.EmitterLocalSpace emitterLocalSpace2 = this.components.getEmitterLocalSpace();
                    boolean bl = emitterLocalSpace2 != null ? emitterLocalSpace2.getVelocity() : false;
                    if (!bl) break block23;
                }
                MutableVectors.plusSelf(this.velocity, this.emitter.getVelocity());
            }
        }

        public final boolean update(float dt) {
            boolean alive;
            if (!this.firedCreationEvents) {
                this.firedCreationEvents = true;
                this.emitter.fire(dt, this.components.getParticleLifetimeEvents().getCreationEvents(), this);
            }
            if (!(alive = this.doUpdate(dt)) && !this.firedExpirationEvents) {
                this.firedExpirationEvents = true;
                this.emitter.fire(0.0f, this.components.getParticleLifetimeEvents().getExpirationEvents(), this);
            }
            return alive;
        }

        private final boolean doUpdate(float dt) {
            block11: {
                float lengthSqr;
                Object config;
                this.setAge(this.getAge() + dt);
                this.curveVariables.update();
                this.fireTimelineEvents();
                if (this.getAge() >= this.getLifetime()) {
                    return false;
                }
                ParticleEffectComponents.ParticleLifetimeExpression particleLifetimeExpression = this.components.getParticleLifetimeExpression();
                if (particleLifetimeExpression != null) {
                    config = particleLifetimeExpression;
                    boolean bl = false;
                    if (!(((ParticleEffectComponents.ParticleLifetimeExpression)config).getExpirationExpression().eval(this.molang) == 0.0f)) {
                        return false;
                    }
                }
                ParticleEffectComponents.ParticleMotionParametric particleMotionParametric = this.components.getParticleMotionParametric();
                if (particleMotionParametric != null) {
                    config = particleMotionParametric;
                    boolean bl = false;
                    MutableVectors.set(this.position, ((ParticleEffectComponents.ParticleMotionParametric)config).getRelativePosition().eval(this.molang));
                    if (this.localSpace == null) {
                        MutableVectors.plusSelf(this.position, this.emitter.getPosition());
                    } else if (this.emitter.getLocatorOffset() != null) {
                        MutableVectors.plusSelf(this.position, this.emitter.getLocatorOffset());
                    }
                    this.rotationAngle = ((ParticleEffectComponents.ParticleMotionParametric)config).getRotation().eval(this.molang);
                    if (((ParticleEffectComponents.ParticleMotionParametric)config).getDirection() != null) {
                        MutableVectors.set(this.direction, ((ParticleEffectComponents.ParticleMotionParametric)config).getDirection().eval(this.molang));
                        MutableVectors.set(this.velocity, (Vec3)Vectors.vecZero());
                    }
                }
                ParticleEffectComponents.ParticleMotionDynamic particleMotionDynamic = this.components.getParticleMotionDynamic();
                if (particleMotionDynamic != null) {
                    config = particleMotionDynamic;
                    boolean bl = false;
                    MutableVec3 linearAcceleration = MutableVectors.toMutable(((ParticleEffectComponents.ParticleMotionDynamic)config).getLinearAcceleration().eval(this.molang));
                    MutableVectors.plusScaledSelf(linearAcceleration, -((ParticleEffectComponents.ParticleMotionDynamic)config).getLinearDragCoefficient().eval(this.molang), this.velocity);
                    if (!Particle.move$default(this, dt, linearAcceleration, 0, false, 12, null)) {
                        return false;
                    }
                    float rotAcceleration = ((ParticleEffectComponents.ParticleMotionDynamic)config).getRotationAcceleration().eval(this.molang);
                    rotAcceleration -= this.rotationRate * ((ParticleEffectComponents.ParticleMotionDynamic)config).getRotationDragCoefficient().eval(this.molang);
                    float deltaRotation = this.rotationRate;
                    this.rotationRate += (rotAcceleration *= dt);
                    deltaRotation += this.rotationRate;
                    this.rotationAngle += (deltaRotation *= 0.5f * dt);
                }
                ParticleEffectComponents.ParticleAppearanceBillboard particleAppearanceBillboard = this.components.getParticleAppearanceBillboard();
                if (particleAppearanceBillboard == null) break block11;
                config = particleAppearanceBillboard;
                boolean bl = false;
                if (((ParticleEffectComponents.ParticleAppearanceBillboard)config).getDirection() instanceof ParticleEffectComponents.ParticleAppearanceBillboard.Direction.FromVelocity && (lengthSqr = Vectors.sqrLength(this.velocity)) > ((ParticleEffectComponents.ParticleAppearanceBillboard.Direction.FromVelocity)((ParticleEffectComponents.ParticleAppearanceBillboard)config).getDirection()).getMinSpeedThresholdSqr()) {
                    MutableVectors.set(this.direction, this.velocity);
                }
            }
            return true;
        }

        private final void fireTimelineEvents() {
            while (this.nextTimelineEvent != null) {
                Map.Entry<Float, ? extends List<String>> entry2;
                float time2 = ((Number)entry2.getKey()).floatValue();
                List<String> events2 = entry2.getValue();
                float timeSinceEvent = this.getAge() - time2;
                if (timeSinceEvent < 0.0f) {
                    return;
                }
                this.emitter.fire(timeSinceEvent, events2, this);
                this.nextTimelineEvent = this.components.getParticleLifetimeEvents().getTimeline().higherEntry((Float)((Comparable)Float.valueOf(time2)));
            }
            return;
        }

        private final boolean move(float dt, Vec3 acceleration, int iteration, boolean sliding) {
            MutableVec3 offset = MutableVectors.mutableVec3(this.velocity);
            MutableVectors.plusScaledSelf(offset, 0.5f * dt, acceleration);
            MutableVectors.timesSelf(offset, dt);
            ParticleEffectComponents.ParticleMotionCollision config = this.components.getParticleMotionCollision();
            if (config == null) {
                MutableVectors.plusSelf(this.position, offset);
                MutableVectors.plusScaledSelf(this.velocity, dt, acceleration);
                return true;
            }
            Pair<Vec3, Vec3> collision = this.emitter.getSystem().collisionProvider.query(this.position, config.getCollisionRadius(), offset);
            if (collision == null) {
                MutableVectors.plusSelf(this.position, offset);
                MutableVectors.plusScaledSelf(this.velocity, dt, acceleration);
                if (sliding) {
                    float speedSqr = Vectors.sqrLength(this.velocity);
                    if (speedSqr > 1.0E-7f) {
                        float orgSpeed = (float)Math.sqrt(speedSqr);
                        float modifiedSpeed = RangesKt.coerceAtLeast((float)(orgSpeed - config.getCollisionDrag() * dt), (float)0.0f);
                        if (modifiedSpeed > 1.0E-4f) {
                            MutableVectors.timesSelf(this.velocity, modifiedSpeed / orgSpeed);
                        } else {
                            MutableVectors.set(this.velocity, (Vec3)Vectors.vecZero());
                        }
                    } else {
                        MutableVectors.set(this.velocity, (Vec3)Vectors.vecZero());
                    }
                }
                return true;
            }
            Vec3 maxOffset = (Vec3)collision.component1();
            Vec3 surfaceNormal = (Vec3)collision.component2();
            if (iteration >= 3 || config.getExpireOnContact()) {
                MutableVectors.plusSelf(this.position, maxOffset);
                MutableVectors.plusScaledSelf(this.velocity, dt, acceleration);
                return !config.getExpireOnContact();
            }
            float preDt = RangesKt.coerceIn((float)((float)Math.sqrt(Vectors.sqrLength(maxOffset) / Vectors.sqrLength(offset))), (float)0.0f, (float)1.0f) * dt;
            MutableVec3 velocityBeforeHit = MutableVectors.plusScaled(this.velocity, preDt, acceleration);
            MutableVec3 velocityAfterHit = ParticleSystemKt.access$reflect(velocityBeforeHit, surfaceNormal);
            MutableVectors.plusScaledSelf(velocityAfterHit, (config.getCoefficientOfRestitution() - 1.0f) * Vectors.dot(velocityAfterHit, surfaceNormal), surfaceNormal);
            MutableVec3 positionAtHit = MutableVectors.plus(this.position, maxOffset);
            MutableVectors.set(this.position, positionAtHit);
            MutableVectors.set(this.velocity, velocityAfterHit);
            float postDt = dt - preDt;
            MutableVec3 postOffset = MutableVectors.mutableVec3(velocityAfterHit);
            MutableVectors.plusScaledSelf(postOffset, 0.5f * postDt, acceleration);
            MutableVectors.timesSelf(postOffset, postDt);
            MutableVec3 positionPostBounce = MutableVectors.plus(positionAtHit, postOffset);
            if (!((Collection)config.getEvents()).isEmpty()) {
                float sqrSpeed = -Vectors.dot(velocityBeforeHit, surfaceNormal);
                Iterable $this$forEach$iv = config.getEvents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ParticleEffectComponents.ParticleMotionCollision.Event eventConfig = (ParticleEffectComponents.ParticleMotionCollision.Event)element$iv;
                    boolean bl = false;
                    if (!(sqrSpeed >= eventConfig.getMinSpeed() * eventConfig.getMinSpeed())) continue;
                    this.emitter.fire(postDt, eventConfig.getEvent(), this);
                }
            }
            if (Vectors.dot(positionPostBounce, surfaceNormal) > Vectors.dot(positionAtHit, surfaceNormal)) {
                return this.move(postDt, acceleration, iteration + 1, sliding);
            }
            MutableVec3 accelerationInPlane = MutableVectors.plusScaled(acceleration, -Vectors.dot(acceleration, surfaceNormal), surfaceNormal);
            return this.move(postDt, accelerationInPlane, iteration + 1, true);
        }

        static /* synthetic */ boolean move$default(Particle particle, float f, Vec3 vec3, int n, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            return particle.move(f, vec3, n, bl);
        }

        /*
         * WARNING - void declaration
         */
        public final void prepareBillboard(@NotNull Vec3 cameraPos, @NotNull Quaternion cameraRot) {
            Quaternion quaternion;
            Intrinsics.checkNotNullParameter((Object)cameraPos, (String)"cameraPos");
            Intrinsics.checkNotNullParameter((Object)cameraRot, (String)"cameraRot");
            ParticleEffectComponents.ParticleAppearanceBillboard particleAppearanceBillboard = this.components.getParticleAppearanceBillboard();
            if (particleAppearanceBillboard == null) {
                throw new UnsupportedOperationException();
            }
            ParticleEffectComponents.ParticleAppearanceBillboard appearance = particleAppearanceBillboard;
            Vec3 position2 = this.getGlobalPosition();
            Object object = this.localSpace;
            if (object == null || (object = object.getRotation()) == null) {
                object = Quaternion.Companion.getIdentity();
            }
            Object localSpaceRotation = object;
            switch (WhenMappings.$EnumSwitchMapping$0[appearance.getFacingCameraMode().ordinal()]) {
                case 1: {
                    quaternion = cameraRot.opposite();
                    break;
                }
                case 2: {
                    quaternion = cameraRot.opposite().projectAroundAxis(Vectors.vecUnitY());
                    break;
                }
                case 3: {
                    quaternion = Quaternion.Companion.fromLookAt(MutableVectors.minus(cameraPos, position2), Vectors.vecUnitY());
                    break;
                }
                case 4: {
                    void $this$prepareBillboard_u24lambda_u2411;
                    MutableVec3 mutableVec3;
                    MutableVec3 mutableVec32 = mutableVec3 = MutableVectors.minus(cameraPos, position2);
                    Quaternion.Companion companion = Quaternion.Companion;
                    boolean bl = false;
                    $this$prepareBillboard_u24lambda_u2411.setY(0.0f);
                    quaternion = companion.fromLookAt(mutableVec3, Vectors.vecUnitY());
                    break;
                }
                case 5: {
                    MutableVec3 mutableVec3;
                    Vec3 direction = Particle.prepareBillboard$computeDirection(appearance, this);
                    MutableVec3 $this$prepareBillboard_u24lambda_u2412 = mutableVec3 = MutableVectors.minus(cameraPos, position2);
                    boolean bl = false;
                    MutableVectors.plusScaledSelf($this$prepareBillboard_u24lambda_u2412, -Vectors.dot($this$prepareBillboard_u24lambda_u2412, direction), direction);
                    MutableVec3 target2 = mutableVec3;
                    quaternion = Quaternion.Companion.fromLookAt(target2, MutableVectors.normalizeSelf(MutableVectors.cross(direction, target2)));
                    break;
                }
                case 6: {
                    quaternion = Quaternion.Companion.fromLookAt(Particle.prepareBillboard$computeDirection(appearance, this), KotglKt.rotateBy(Vectors.vecUnitY(), (Quaternion)localSpaceRotation)).times(Quaternion.Companion.fromAxisAngle(Vectors.vecUnitY(), -((float)Math.PI) / (float)2));
                    break;
                }
                case 7: {
                    quaternion = Quaternion.Companion.fromLookAt(Particle.prepareBillboard$computeDirection(appearance, this), KotglKt.rotateBy(Vectors.vecUnitY(), (Quaternion)localSpaceRotation)).times(Quaternion.Companion.fromAxisAngle(Vectors.vecUnitX(), -((float)Math.PI) / (float)2)).times(Quaternion.Companion.getY180());
                    break;
                }
                case 8: {
                    quaternion = Quaternion.Companion.fromLookAt(Particle.prepareBillboard$computeDirection(appearance, this), KotglKt.rotateBy(Vectors.vecUnitY(), (Quaternion)localSpaceRotation));
                    break;
                }
                case 9: {
                    Object object2 = this.localSpace;
                    if (object2 == null || (object2 = object2.getRotation()) == null) {
                        object2 = this.emitterRotationOnEmit;
                    }
                    quaternion = ((Quaternion)object2).times(Quaternion.Companion.getY180());
                    break;
                }
                case 10: {
                    Object object3 = this.localSpace;
                    if (object3 == null || (object3 = object3.getRotation()) == null) {
                        object3 = this.emitterRotationOnEmit;
                    }
                    quaternion = ((Quaternion)object3).times(Quaternion.Companion.getY180()).times(Quaternion.Companion.fromAxisAngle(Vectors.vecUnitX(), (float)Math.PI / (float)2));
                    break;
                }
                case 11: {
                    Object object4 = this.localSpace;
                    if (object4 == null || (object4 = object4.getRotation()) == null) {
                        object4 = this.emitterRotationOnEmit;
                    }
                    quaternion = ((Quaternion)object4).times(Quaternion.Companion.fromAxisAngle(Vectors.vecUnitY(), -((float)Math.PI) / (float)2));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Quaternion rot = quaternion;
            if (!(this.rotationAngle == 0.0f)) {
                rot = rot.times(Quaternion.Companion.fromAxisAngle(Vectors.vecUnitZ(), -this.rotationAngle / (float)180 * (float)Math.PI));
            }
            this.billboardPosition = position2;
            this.billboardRotation = rot;
            Object object5 = this.components.getParticleInitialization();
            if (object5 != null && (object5 = ((ParticleEffectComponents.ParticleInitialization)object5).getPerRenderExpression()) != null) {
                ((Molang)object5).eval(this.molang);
            }
            this.billboardSize = ParticleSystemKt.access$eval(appearance.getSize(), this.molang);
        }

        public final void renderBillboard(@NotNull UMatrixStack matrixStack, @NotNull UVertexConsumer vertexConsumer, @NotNull Vec3 cameraFacing, @NotNull UUID cameraUuid, boolean cameraFirstPerson, boolean hideParticlesInFirstPerson) {
            MutableVec3 billboardNormal;
            boolean flip;
            Vec2 size;
            Vec2 base;
            int n;
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
            Intrinsics.checkNotNullParameter((Object)cameraFacing, (String)"cameraFacing");
            Intrinsics.checkNotNullParameter((Object)cameraUuid, (String)"cameraUuid");
            if (Intrinsics.areEqual((Object)cameraUuid, (Object)this.emitter.getSourceEntity().getUuid())) {
                if (cameraFirstPerson && hideParticlesInFirstPerson) {
                    return;
                }
                ParticleEffectComponents.ParticleVisibility it = this.components.getParticleVisibility();
                boolean bl = false;
                if (!(cameraFirstPerson ? it.getFirstPerson() : it.getThirdPerson())) {
                    return;
                }
            }
            ParticleEffectComponents.ParticleAppearanceBillboard particleAppearanceBillboard = this.components.getParticleAppearanceBillboard();
            if (particleAppearanceBillboard == null) {
                throw new UnsupportedOperationException();
            }
            ParticleEffectComponents.ParticleAppearanceBillboard appearance = particleAppearanceBillboard;
            Vec3 position2 = this.billboardPosition;
            Quaternion rotation = this.billboardRotation;
            Vec2 vec2 = this.billboardSize;
            float sizeX = vec2.component1();
            float sizeY = vec2.component2();
            Vec2 textureSize = Vectors.vec2(appearance.getUv().getTextureWidth(), appearance.getUv().getTextureHeight());
            Object object = this.components.getParticleAppearanceTinting();
            if (object != null && (object = ((ParticleEffectComponents.ParticleAppearanceTinting)object).getColor()) != null && (object = object.eval(this.molang)) != null) {
                Object object2 = object;
                Color.Companion companion = Color.Companion;
                Object p0 = object2;
                boolean bl = false;
                n = companion.fromVec-WvJmvJ8((Vec4)p0);
            } else {
                n = Color.Companion.getWHITE-yaPNGYs();
            }
            int color2 = n;
            int light = this.components.getParticleAppearanceLighting() != null ? this.emitter.getSystem().lightProvider.query-PvXcHUY(position2) : Light.Companion.getMAX_VALUE-cWgJFAk();
            Vec2 minUV = null;
            Vec2 maxUV = null;
            ParticleEffectComponents.ParticleAppearanceBillboard.UV.Flipbook flipbook = appearance.getUv().getFlipbook();
            if (flipbook != null) {
                base = ParticleSystemKt.access$eval(flipbook.getBase(), this.molang);
                size = ParticleSystemKt.access$toVec2(flipbook.getSize());
                MutableVec2 step = ParticleSystemKt.access$toVec2(flipbook.getStep());
                int maxFrame = (int)flipbook.getMaxFrame().eval(this.molang);
                float timePerFrame = flipbook.getStretchToLifetime() ? this.getLifetime() / (float)maxFrame : 1.0f / flipbook.getFramePerSecond();
                int frame = (int)(this.getAge() / timePerFrame);
                boolean bl = false;
                int frame2 = flipbook.getLoop() ? frame % maxFrame : RangesKt.coerceAtMost((int)frame, (int)maxFrame);
                minUV = MutableVectors.plusScaled(base, (float)frame2, step);
                maxUV = MutableVectors.plus(minUV, size);
            } else {
                Object object3 = appearance.getUv().getUv();
                base = object3 != null && (object3 = ParticleSystemKt.access$eval(object3, this.molang)) != null ? (Vec2)object3 : (Vec2)Vectors.vecZero();
                Object object4 = appearance.getUv().getUvSize();
                size = object4 != null && (object4 = ParticleSystemKt.access$eval(object4, this.molang)) != null ? (Vec2)object4 : textureSize;
                minUV = base;
                maxUV = MutableVectors.plus(minUV, size);
            }
            minUV = MutableVectors.div(minUV, textureSize);
            maxUV = MutableVectors.div(maxUV, textureSize);
            boolean bl = this.emitter.getEffect().getMaterial().getBackfaceCulling() ? false : (flip = Vectors.dot(cameraFacing, billboardNormal = KotglKt.rotateSelfBy(MutableVectors.mutableVec3(0.0f, 0.0f, -1.0f), rotation)) > 0.0f);
            if (!flip) {
                Particle.renderBillboard$emitPoint(rotation, vertexConsumer, matrixStack, position2, color2, light, -sizeX, -sizeY, ((MutableVec2)maxUV).getX(), ((MutableVec2)maxUV).getY());
                Particle.renderBillboard$emitPoint(rotation, vertexConsumer, matrixStack, position2, color2, light, -sizeX, sizeY, ((MutableVec2)maxUV).getX(), ((MutableVec2)minUV).getY());
                Particle.renderBillboard$emitPoint(rotation, vertexConsumer, matrixStack, position2, color2, light, sizeX, sizeY, ((MutableVec2)minUV).getX(), ((MutableVec2)minUV).getY());
                Particle.renderBillboard$emitPoint(rotation, vertexConsumer, matrixStack, position2, color2, light, sizeX, -sizeY, ((MutableVec2)minUV).getX(), ((MutableVec2)maxUV).getY());
            } else {
                Particle.renderBillboard$emitPoint(rotation, vertexConsumer, matrixStack, position2, color2, light, sizeX, -sizeY, ((MutableVec2)minUV).getX(), ((MutableVec2)maxUV).getY());
                Particle.renderBillboard$emitPoint(rotation, vertexConsumer, matrixStack, position2, color2, light, sizeX, sizeY, ((MutableVec2)minUV).getX(), ((MutableVec2)minUV).getY());
                Particle.renderBillboard$emitPoint(rotation, vertexConsumer, matrixStack, position2, color2, light, -sizeX, sizeY, ((MutableVec2)maxUV).getX(), ((MutableVec2)minUV).getY());
                Particle.renderBillboard$emitPoint(rotation, vertexConsumer, matrixStack, position2, color2, light, -sizeX, -sizeY, ((MutableVec2)maxUV).getX(), ((MutableVec2)maxUV).getY());
            }
        }

        private static final Vec3 emit$computeFor(ParticleEffectComponents.Direction $this$emit_u24computeFor, Particle this$0, Vec3 point) {
            Vec3 vec3;
            ParticleEffectComponents.Direction direction = $this$emit_u24computeFor;
            if (Intrinsics.areEqual((Object)direction, (Object)ParticleEffectComponents.Direction.Inwards.INSTANCE)) {
                vec3 = MutableVectors.times(point, -1.0f);
            } else if (Intrinsics.areEqual((Object)direction, (Object)ParticleEffectComponents.Direction.Outwards.INSTANCE)) {
                vec3 = point;
            } else if (direction instanceof ParticleEffectComponents.Direction.Custom) {
                vec3 = ((ParticleEffectComponents.Direction.Custom)$this$emit_u24computeFor).getVec().eval(this$0.molang);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return vec3;
        }

        private static final Vec3 prepareBillboard$computeDirection(ParticleEffectComponents.ParticleAppearanceBillboard appearance, Particle this$0) {
            Vec3 vec3;
            ParticleEffectComponents.ParticleAppearanceBillboard.Direction config = appearance.getDirection();
            if (config instanceof ParticleEffectComponents.ParticleAppearanceBillboard.Direction.FromVelocity) {
                vec3 = this$0.direction;
            } else if (config instanceof ParticleEffectComponents.ParticleAppearanceBillboard.Direction.Custom) {
                vec3 = ((ParticleEffectComponents.ParticleAppearanceBillboard.Direction.Custom)config).getDirection().eval(this$0.molang);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Vec3 localDirection = vec3;
            return this$0.localSpace != null ? (Vec3)KotglKt.rotateBy(localDirection, this$0.localSpace.getRotation()) : localDirection;
        }

        private static final void renderBillboard$emitPoint(Quaternion rotation, UVertexConsumer $vertexConsumer, UMatrixStack $matrixStack, Vec3 position2, int color2, int light, float x, float y, float u, float v) {
            MutableVec3 pos = MutableVectors.mutableVec3(x, y, 0.0f);
            KotglKt.rotateSelfBy(pos, rotation);
            $vertexConsumer.pos($matrixStack, (double)position2.getX() + (double)pos.getX(), (double)position2.getY() + (double)pos.getY(), (double)position2.getZ() + (double)pos.getZ()).tex(u, v).color-EIFkdBU(color2).light-vX8ayIk(light).endVertex();
        }

        public static final /* synthetic */ MolangContext access$getMolang$p(Particle $this) {
            return $this.molang;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Particle.class, "age", "getAge()F", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Particle.class, "lifetime", "getLifetime()F", 0)))};
            $$delegatedProperties = kPropertyArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lgg/essential/model/ParticleSystem$Particle$LocatorFor;", "Lgg/essential/model/ParticleSystem$Locator;", "particle", "Lgg/essential/model/ParticleSystem$Particle;", "(Lgg/essential/model/ParticleSystem$Particle;)V", "isValid", "", "()Z", "isVisible", "parent", "getParent", "()Lgg/essential/model/ParticleSystem$Locator;", "getParticle", "()Lgg/essential/model/ParticleSystem$Particle;", "position", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "getPosition", "()Ldev/folomeev/kotgl/matrix/vectors/Vec3;", "rotation", "Lgg/essential/model/util/Quaternion;", "getRotation", "()Lgg/essential/model/util/Quaternion;", "velocity", "getVelocity", "cosmetics"})
        public static final class LocatorFor
        implements Locator {
            @NotNull
            private final Particle particle;

            public LocatorFor(@NotNull Particle particle) {
                Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
                this.particle = particle;
            }

            @NotNull
            public final Particle getParticle() {
                return this.particle;
            }

            @Override
            @Nullable
            public Locator getParent() {
                return this.particle.getLocalSpace();
            }

            @Override
            public boolean isValid() {
                return !this.particle.firedExpirationEvents;
            }

            @Override
            @NotNull
            public Vec3 getPosition() {
                return this.particle.getGlobalPosition();
            }

            @Override
            @NotNull
            public Quaternion getRotation() {
                return Quaternion.Companion.getIdentity();
            }

            @Override
            @NotNull
            public Vec3 getVelocity() {
                return this.particle.getGlobalVelocity();
            }

            @Override
            public boolean isVisible() {
                Locator locator = this.getParent();
                return locator != null ? locator.isVisible() : true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.values().length];
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.RotateXYZ.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.RotateY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.LookAtXYZ.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.LookAtY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.LookAtDirection.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.DirectionX.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.DirectionY.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.DirectionZ.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.EmitterTransformXY.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.EmitterTransformXZ.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticleEffectComponents.ParticleAppearanceBillboard.FacingCameraMode.EmitterTransformYZ.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aR\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lgg/essential/model/ParticleSystem$Universe;", "", "timeSource", "Lgg/essential/model/molang/MolangQueryTime;", "(Lgg/essential/model/ParticleSystem;Lgg/essential/model/molang/MolangQueryTime;)V", "emitters", "", "Lgg/essential/model/ParticleSystem$Emitter;", "getEmitters", "()Ljava/util/List;", "lastUpdate", "", "getLastUpdate", "()F", "setLastUpdate", "(F)V", "particles", "Lgg/essential/model/ParticleSystem$Particle;", "getParticles", "getTimeSource", "()Lgg/essential/model/molang/MolangQueryTime;", "addParticle", "", "particle", "removeParticleAt", "index", "", "cosmetics"})
    @SourceDebugExtension(value={"SMAP\nParticleSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleSystem.kt\ngg/essential/model/ParticleSystem$Universe\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1560:1\n357#2,7:1561\n*S KotlinDebug\n*F\n+ 1 ParticleSystem.kt\ngg/essential/model/ParticleSystem$Universe\n*L\n116#1:1561,7\n*E\n"})
    private final class Universe {
        @NotNull
        private final MolangQueryTime timeSource;
        private float lastUpdate;
        @NotNull
        private final List<Emitter> emitters;
        @NotNull
        private final List<Particle> particles;

        public Universe(MolangQueryTime timeSource) {
            Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
            this.timeSource = timeSource;
            this.lastUpdate = this.timeSource.getTime();
            this.emitters = new ArrayList();
            this.particles = new ArrayList();
        }

        @NotNull
        public final MolangQueryTime getTimeSource() {
            return this.timeSource;
        }

        public final float getLastUpdate() {
            return this.lastUpdate;
        }

        public final void setLastUpdate(float f) {
            this.lastUpdate = f;
        }

        @NotNull
        public final List<Emitter> getEmitters() {
            return this.emitters;
        }

        @NotNull
        public final List<Particle> getParticles() {
            return this.particles;
        }

        public final void addParticle(@NotNull Particle particle) {
            Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
            this.particles.add(particle);
            ParticleEffect effect2 = particle.getEmitter().getEffect();
            ParticleEffect.RenderPass renderPass = particle.getRenderPass();
            if (renderPass != null && effect2.getComponents().getParticleAppearanceBillboard() != null) {
                Object object;
                Map $this$getOrPut$iv = ParticleSystem.this.billboardRenderPasses;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(renderPass);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(renderPass, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(particle);
            }
        }

        @NotNull
        public final Particle removeParticleAt(int index2) {
            Particle particle = this.particles.set(index2, null);
            if (particle == null) {
                throw new IndexOutOfBoundsException();
            }
            Particle particle2 = particle;
            ParticleEffect effect2 = particle2.getEmitter().getEffect();
            ParticleEffect.RenderPass renderPass = particle2.getRenderPass();
            if (renderPass != null && effect2.getComponents().getParticleAppearanceBillboard() != null) {
                Set renderPassSet = (Set)MapsKt.getValue((Map)ParticleSystem.this.billboardRenderPasses, (Object)renderPass);
                renderPassSet.remove(particle2);
                if (renderPassSet.isEmpty()) {
                    ParticleSystem.this.billboardRenderPasses.remove(renderPass);
                }
            }
            return particle2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lgg/essential/model/ParticleSystem$VertexConsumerProvider;", "", "provide", "", "renderPass", "Lgg/essential/model/ParticleEffect$RenderPass;", "block", "Lkotlin/Function1;", "Lgg/essential/model/util/UVertexConsumer;", "cosmetics"})
    public static interface VertexConsumerProvider {
        public void provide(@NotNull ParticleEffect.RenderPass var1, @NotNull Function1<? super UVertexConsumer, Unit> var2);
    }
}

