/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.cosmetics;

import com.google.common.collect.Maps;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.lib.caffeine.cache.Cache;
import gg.essential.lib.caffeine.cache.Caffeine;
import gg.essential.lib.caffeine.cache.Expiry;
import gg.essential.lib.caffeine.cache.RemovalCause;
import gg.essential.lib.caffeine.cache.Scheduler;
import gg.essential.network.connectionmanager.AsyncResponseHandler;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.EarlyResponseHandler;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.Multithreading;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class PacketHandlers {
    @NotNull
    private final Executor mainThreadExecutor = ExtensionsKt.getExecutor(UMinecraft.getMinecraft());
    @NotNull
    private final Map<Class<? extends Packet>, PacketHandler<?>> packetHandlers = Maps.newHashMap();
    @NotNull
    private final @NotNull Cache<@NotNull UUID, @NotNull Pair<@NotNull Long, @NotNull Consumer<@NotNull Optional<Packet>>>> awaitingPacketResponses = Caffeine.newBuilder().maximumSize(10000L).executor(Multithreading.getPool()).scheduler(Scheduler.forScheduledExecutorService(Multithreading.getScheduledPool())).expireAfter(new Expiry<UUID, Pair<Long, Consumer<Optional<Packet>>>>(this){

        @Override
        public long expireAfterCreate(@NotNull UUID packetId, @NotNull @NotNull Pair<@NotNull Long, @NotNull Consumer<@NotNull Optional<Packet>>> valueData, long currentTime) {
            return (Long)valueData.getKey();
        }

        @Override
        public long expireAfterUpdate(@NotNull UUID packetId, @NotNull @NotNull Pair<@NotNull Long, @NotNull Consumer<@NotNull Optional<Packet>>> valueData, long currentTime, long currentDuration) {
            return currentDuration;
        }

        @Override
        public long expireAfterRead(@NotNull UUID packetId, @NotNull @NotNull Pair<@NotNull Long, @NotNull Consumer<@NotNull Optional<Packet>>> valueData, long currentTime, long currentDuration) {
            return currentDuration;
        }
    }).evictionListener((key, value, cause) -> {
        if (value != null && (RemovalCause.EXPIRED == cause || RemovalCause.SIZE == cause)) {
            @NotNull Consumer packetHandler = (Consumer)value.getRight();
            this.mainThreadExecutor.execute(() -> packetHandler.accept(Optional.empty()));
        }
    }).build();

    public <T extends Packet> void register(Class<T> cls, PacketHandler<T> handler) {
        this.packetHandlers.put(cls, handler);
    }

    public void register(@NotNull UUID packetId, @NotNull TimeUnit timeoutUnit, @NotNull Long timeoutValue, @NotNull Consumer<Optional<Packet>> responseCallback) {
        this.awaitingPacketResponses.put(packetId, (Pair<Long, Consumer<Optional<Packet>>>)Pair.of((Object)timeoutUnit.toNanos(timeoutValue), responseCallback));
    }

    public void handle(ConnectionManager connectionManager, Packet packet2) {
        Consumer asyncResponseHandler;
        Consumer fResponseHandler;
        Pair<Long, Consumer<Optional<Packet>>> responseCallbackPair;
        PacketHandler<?> packetHandler = this.packetHandlers.get(packet2.getClass());
        UUID packetId = packet2.getPacketUniqueId();
        Consumer responseHandler = null;
        if (packetId != null && (responseCallbackPair = this.awaitingPacketResponses.getIfPresent(packetId)) != null) {
            this.awaitingPacketResponses.invalidate(packetId);
            responseHandler = (Consumer)responseCallbackPair.getRight();
        }
        if (responseHandler instanceof AsyncResponseHandler) {
            fResponseHandler = null;
            asyncResponseHandler = responseHandler;
        } else {
            fResponseHandler = responseHandler;
            asyncResponseHandler = null;
        }
        if (packetHandler == null && responseHandler == null) {
            return;
        }
        Runnable syncPacketHandler = null;
        if (packetHandler != null) {
            try {
                syncPacketHandler = packetHandler.handleAsync(connectionManager, packet2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        Runnable fSyncPacketHandler = syncPacketHandler;
        if (asyncResponseHandler != null) {
            try {
                asyncResponseHandler.accept(Optional.of(packet2));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.mainThreadExecutor.execute(() -> {
            if (!connectionManager.isOpen()) {
                return;
            }
            Consumer responseHandlerSync = fResponseHandler;
            if (responseHandlerSync instanceof EarlyResponseHandler) {
                try {
                    responseHandlerSync.accept(Optional.of(packet2));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                responseHandlerSync = null;
            }
            if (fSyncPacketHandler != null) {
                try {
                    fSyncPacketHandler.run();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (responseHandlerSync != null) {
                try {
                    responseHandlerSync.accept(Optional.of(packet2));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
    }
}

