/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.handler.cosmetics;

import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsUserUnlockedPacket;
import gg.essential.cosmetics.model.CosmeticUnlockData;
import gg.essential.gui.common.CosmeticToastsKt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ServerCosmeticsUserUnlockedPacketHandler
extends PacketHandler<ServerCosmeticsUserUnlockedPacket> {
    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerCosmeticsUserUnlockedPacket packet2) {
        CosmeticsManager cosmeticsManager = connectionManager.getCosmeticsManager();
        Set<String> currentUnlocks = cosmeticsManager.getUnlockedCosmetics().get();
        Map<String, CosmeticUnlockData> newUnlocks = packet2.getUnlockedCosmetics();
        cosmeticsManager.addUnlockedCosmeticsData(newUnlocks);
        if (!packet2.occurredFromPurchase()) {
            cosmeticsManager.getCapeManager().unlockMissingCapesAsync();
            return;
        }
        newUnlocks.entrySet().stream().filter(e -> !currentUnlocks.contains(e.getKey())).forEach(e -> {
            String newCosmetic = (String)e.getKey();
            CosmeticUnlockData unlockData = (CosmeticUnlockData)e.getValue();
            if (unlockData == null || unlockData.isWardrobeUnlock()) {
                return;
            }
            if (ServerCosmeticsUserUnlockedPacket.suppressNotifications.contains(newCosmetic)) {
                ServerCosmeticsUserUnlockedPacket.suppressNotifications.remove(newCosmetic);
                return;
            }
            Cosmetic cosmetic2 = cosmeticsManager.getCosmetic(newCosmetic);
            if (cosmetic2 != null) {
                CosmeticToastsKt.sendCosmeticUnlockedToast(cosmetic2);
            }
        });
    }
}

