/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.relationship;

import com.google.common.collect.Maps;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipState;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipType;
import gg.essential.Essential;
import gg.essential.api.gui.NotificationBuilder;
import gg.essential.connectionmanager.common.model.relationships.Relationship;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.relationships.ClientRelationshipCreatePacket;
import gg.essential.connectionmanager.common.packet.relationships.RelationshipDeletePacket;
import gg.essential.connectionmanager.common.packet.relationships.ServerRelationshipCreateFailedResponsePacket;
import gg.essential.connectionmanager.common.packet.relationships.ServerRelationshipDeletePacket;
import gg.essential.connectionmanager.common.packet.relationships.ServerRelationshipPopulatePacket;
import gg.essential.connectionmanager.common.packet.relationships.privacy.FriendRequestPrivacySettingPacket;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.friends.state.IRelationshipManager;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.StateCallbackManager;
import gg.essential.network.connectionmanager.handler.relationships.FriendRequestPrivacySettingPacketHandler;
import gg.essential.network.connectionmanager.handler.relationships.ServerRelationshipDeletePacketHandler;
import gg.essential.network.connectionmanager.handler.relationships.ServerRelationshipPopulatePacketHandler;
import gg.essential.network.connectionmanager.relationship.FriendRequestState;
import gg.essential.network.connectionmanager.relationship.RelationshipErrorResponse;
import gg.essential.network.connectionmanager.relationship.RelationshipResponse;
import gg.essential.network.connectionmanager.relationship.RelationshipResponseKt;
import gg.essential.util.Multithreading;
import gg.essential.util.ObservableMapEvent;
import gg.essential.util.SimpleObservableMap;
import gg.essential.util.StringsKt;
import gg.essential.util.UUIDUtil;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelationshipManager
extends StateCallbackManager<IRelationshipManager>
implements NetworkedManager {
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final SimpleObservableMap<UUID, Relationship> friends = new SimpleObservableMap(Maps.newConcurrentMap());
    @NotNull
    private final SimpleObservableMap<UUID, Relationship> outgoingFriendRequests = new SimpleObservableMap(Maps.newConcurrentMap());
    @NotNull
    private final SimpleObservableMap<UUID, Relationship> incomingFriendRequests = new SimpleObservableMap(Maps.newConcurrentMap());
    @NotNull
    private final SimpleObservableMap<UUID, Relationship> blockedByMe = new SimpleObservableMap(Maps.newConcurrentMap());
    @NotNull
    private final SimpleObservableMap<UUID, Relationship> blockedMe = new SimpleObservableMap(Maps.newConcurrentMap());

    public RelationshipManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.registerPacketHandler(FriendRequestPrivacySettingPacket.class, new FriendRequestPrivacySettingPacketHandler());
        connectionManager.registerPacketHandler(ServerRelationshipDeletePacket.class, new ServerRelationshipDeletePacketHandler());
        connectionManager.registerPacketHandler(ServerRelationshipPopulatePacket.class, new ServerRelationshipPopulatePacketHandler());
        this.friends.addObserver((o, arg) -> {
            for (IRelationshipManager callback : this.getCallbacks()) {
                if (arg instanceof ObservableMapEvent.Clear) {
                    callback.clearFriends();
                    continue;
                }
                if (arg instanceof ObservableMapEvent.Add) {
                    callback.friendAdded((UUID)((ObservableMapEvent.Add)arg).getElement().component1());
                    continue;
                }
                if (!(arg instanceof ObservableMapEvent.Remove)) continue;
                callback.friendRemoved((UUID)((ObservableMapEvent.Remove)arg).getElement().component1());
            }
        });
        this.blockedByMe.addObserver((o, arg) -> {
            for (IRelationshipManager callback : this.getCallbacks()) {
                if (arg instanceof ObservableMapEvent.Clear) {
                    callback.clearBlocked();
                    continue;
                }
                if (arg instanceof ObservableMapEvent.Add) {
                    callback.playerBlocked((UUID)((ObservableMapEvent.Add)arg).getElement().component1());
                    continue;
                }
                if (!(arg instanceof ObservableMapEvent.Remove)) continue;
                callback.playerUnblocked((UUID)((ObservableMapEvent.Remove)arg).getElement().component1());
            }
        });
        this.incomingFriendRequests.addObserver((o, arg) -> {
            for (IRelationshipManager callback : this.getCallbacks()) {
                if (arg instanceof ObservableMapEvent.Clear) {
                    callback.clearAllIncomingRequests();
                    continue;
                }
                if (arg instanceof ObservableMapEvent.Add) {
                    callback.newIncomingFriendRequest((UUID)((ObservableMapEvent.Add)arg).getElement().component1());
                    continue;
                }
                if (!(arg instanceof ObservableMapEvent.Remove)) continue;
                callback.clearIncomingFriendRequest((UUID)((ObservableMapEvent.Remove)arg).getElement().component1());
            }
        });
        this.outgoingFriendRequests.addObserver((o, arg) -> {
            for (IRelationshipManager callback : this.getCallbacks()) {
                if (arg instanceof ObservableMapEvent.Clear) {
                    callback.clearAllOutgoingRequests();
                    continue;
                }
                if (arg instanceof ObservableMapEvent.Add) {
                    callback.newOutgoingFriendRequest((UUID)((ObservableMapEvent.Add)arg).getElement().component1());
                    continue;
                }
                if (!(arg instanceof ObservableMapEvent.Remove)) continue;
                callback.clearOutgoingFriendRequest((UUID)((ObservableMapEvent.Remove)arg).getElement().component1());
            }
        });
    }

    @NotNull
    public Map<UUID, Relationship> getFriends() {
        return this.friends;
    }

    @NotNull
    public Map<UUID, Relationship> getOutgoingFriendRequests() {
        return this.outgoingFriendRequests;
    }

    @NotNull
    public Map<UUID, Relationship> getIncomingFriendRequests() {
        return this.incomingFriendRequests;
    }

    @NotNull
    public Map<UUID, Relationship> getBlockedByMe() {
        return this.blockedByMe;
    }

    @Nullable
    public Relationship getFriend(@NotNull UUID uuid) {
        return this.friends.get(uuid);
    }

    @Nullable
    public Relationship getOutgoingFriendRequest(@NotNull UUID uuid) {
        return this.outgoingFriendRequests.get(uuid);
    }

    @Nullable
    public Relationship getIncomingFriendRequest(@NotNull UUID uuid) {
        return this.incomingFriendRequests.get(uuid);
    }

    @Nullable
    public Relationship getBlockedByMe(@NotNull UUID uuid) {
        return this.blockedByMe.get(uuid);
    }

    public boolean isFriend(@NotNull UUID uuid) {
        return this.friends.containsKey(uuid);
    }

    public boolean hasOutgoingFriendRequest(@NotNull UUID uuid) {
        return this.outgoingFriendRequests.containsKey(uuid);
    }

    public boolean isBlockedByMe(@NotNull UUID uuid) {
        return this.blockedByMe.containsKey(uuid);
    }

    public boolean hasBlockedMe(@NotNull UUID uuid) {
        return this.blockedMe.containsKey(uuid);
    }

    public CompletableFuture<RelationshipResponse> createFriendRelationship(@NotNull UUID targetUUID, boolean acceptingRequest) {
        return this.createFriendRelationship(targetUUID, acceptingRequest, true);
    }

    public CompletableFuture<RelationshipResponse> createFriendRelationship(@NotNull UUID targetUUID, boolean acceptingRequest, boolean notification) {
        if (targetUUID.equals(UUIDUtil.getClientUUID())) {
            if (notification) {
                // empty if block
            }
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED, "Cannot add yourself"));
        }
        if (this.isFriend(targetUUID)) {
            if (notification) {
                UUIDUtil.getName(targetUUID).whenCompleteAsync((name2, e) -> {
                    String username = name2 != null ? name2 : "unknown";
                    ExtensionsKt.error(Notifications.INSTANCE, "Friend request failed", "", (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)builder -> {
                        ExtensionsKt.markdownBody(builder, "You are already friends with " + StringsKt.colored(username, EssentialPalette.TEXT_HIGHLIGHT) + ".");
                        return Unit.INSTANCE;
                    }));
                });
            }
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED, "Already your friend"));
        }
        if (!acceptingRequest && this.hasOutgoingFriendRequest(targetUUID)) {
            if (notification) {
                UUIDUtil.getName(targetUUID).whenCompleteAsync((name2, e) -> {
                    String username = name2 != null ? name2 : "unknown";
                    ExtensionsKt.error(Notifications.INSTANCE, "Friend request failed", "", (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)builder -> {
                        ExtensionsKt.markdownBody(builder, "Friend request already sent to " + StringsKt.colored(username, EssentialPalette.TEXT_HIGHLIGHT) + ".");
                        return Unit.INSTANCE;
                    }));
                });
            }
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED, "Already invited to be friend"));
        }
        if (this.isBlockedByMe(targetUUID)) {
            UUIDUtil.getName(targetUUID).whenCompleteAsync((name2, e) -> {
                String username = name2 != null ? name2 : "unknown";
                ExtensionsKt.error(Notifications.INSTANCE, "Friend request failed", "", (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)builder -> {
                    ExtensionsKt.markdownBody(builder, "You have blocked " + StringsKt.colored(username, EssentialPalette.TEXT_HIGHLIGHT) + ". Unblock them before sending them a friend request.");
                    return Unit.INSTANCE;
                }));
            });
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED, "You blocked this player"));
        }
        if (this.hasBlockedMe(targetUUID)) {
            if (notification) {
                UUIDUtil.getName(targetUUID).whenCompleteAsync((name2, e) -> {
                    String username = name2 != null ? name2 : "unknown";
                    ExtensionsKt.warning(Notifications.INSTANCE, "Friend request declined", "", (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)builder -> {
                        ExtensionsKt.markdownBody(builder, StringsKt.colored(username, EssentialPalette.TEXT_HIGHLIGHT) + " has blocked you.");
                        return Unit.INSTANCE;
                    }));
                });
            }
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED, "This player blocked you"));
        }
        return this.createRelationship(targetUUID, RelationshipType.FRIENDS);
    }

    public CompletableFuture<RelationshipResponse> createBlockedRelationship(@NotNull UUID uuid) {
        return this.createBlockedRelationship(uuid, true);
    }

    public CompletableFuture<RelationshipResponse> createBlockedRelationship(@NotNull UUID uuid, boolean notification) {
        if (uuid.equals(UUIDUtil.getClientUUID())) {
            if (notification) {
                // empty if block
            }
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED, "Cannot block yourself"));
        }
        if (this.isBlockedByMe(uuid)) {
            if (notification) {
                // empty if block
            }
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED, "Already blocked this player"));
        }
        return this.createRelationship(uuid, RelationshipType.BLOCKED);
    }

    public void createRelationship(@NotNull Relationship relationship) {
        UUID ourUUID = this.connectionManager.getMinecraftHook().getPlayerUUID();
        boolean areWeTheSender = relationship.getSenderUUID().equals(ourUUID);
        UUID targetUUID = areWeTheSender ? relationship.getTargetUUID() : relationship.getSenderUUID();
        block0 : switch (relationship.getType()) {
            case NEUTRAL: {
                this.friends.remove(targetUUID);
                this.outgoingFriendRequests.remove(targetUUID);
                this.incomingFriendRequests.remove(targetUUID);
                this.blockedMe.remove(targetUUID);
                this.blockedByMe.remove(targetUUID);
                break;
            }
            case FRIENDS: {
                switch (relationship.getState()) {
                    case PENDING: {
                        this.friends.remove(targetUUID);
                        this.blockedMe.remove(targetUUID);
                        this.blockedByMe.remove(targetUUID);
                        if (areWeTheSender) {
                            this.outgoingFriendRequests.put(targetUUID, relationship);
                            break block0;
                        }
                        this.incomingFriendRequests.put(targetUUID, relationship);
                        break block0;
                    }
                    case VERIFIED: {
                        this.outgoingFriendRequests.remove(targetUUID);
                        this.incomingFriendRequests.remove(targetUUID);
                        this.blockedMe.remove(targetUUID);
                        this.blockedByMe.remove(targetUUID);
                        this.friends.put(targetUUID, relationship);
                        break block0;
                    }
                    case DECLINED: {
                        this.friends.remove(targetUUID);
                        this.outgoingFriendRequests.remove(targetUUID);
                        this.incomingFriendRequests.remove(targetUUID);
                        this.blockedMe.remove(targetUUID);
                        this.blockedByMe.remove(targetUUID);
                    }
                }
                break;
            }
            case BLOCKED: {
                this.friends.remove(targetUUID);
                this.outgoingFriendRequests.remove(targetUUID);
                this.incomingFriendRequests.remove(targetUUID);
                if (areWeTheSender) {
                    this.blockedByMe.put(targetUUID, relationship);
                    break;
                }
                this.blockedMe.put(targetUUID, relationship);
            }
        }
        Multithreading.runAsync(this.connectionManager.getSpsManager()::refreshWhitelist);
    }

    public CompletableFuture<RelationshipResponse> createRelationship(@NotNull UUID targetUUID, @NotNull RelationshipType type) {
        CompletableFuture<RelationshipResponse> future2 = new CompletableFuture<RelationshipResponse>();
        this.connectionManager.send(new ClientRelationshipCreatePacket(targetUUID, type), responseOptional -> {
            if (!responseOptional.isPresent()) {
                ExtensionsKt.error(Notifications.INSTANCE, "Error", "A timeout occurred please try again.");
            }
            future2.complete(responseOptional.map(packet2 -> {
                if (packet2 instanceof ServerRelationshipCreateFailedResponsePacket) {
                    String reason2 = ((ServerRelationshipCreateFailedResponsePacket)packet2).getReason();
                    RelationshipErrorResponse relationshipErrorResponse = RelationshipErrorResponse.getResponse(reason2);
                    if (relationshipErrorResponse == null) {
                        Essential.logger.error("Unknown relationshipErrorResponse reason: " + reason2);
                    }
                    return new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, relationshipErrorResponse);
                }
                if (!(packet2 instanceof ServerRelationshipPopulatePacket)) {
                    return new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, "An unknown error occurred");
                }
                return new RelationshipResponse(((ServerRelationshipPopulatePacket)packet2).getRelationships()[0].getState() != RelationshipState.DECLINED ? FriendRequestState.SENT : FriendRequestState.ERROR_UNHANDLED);
            }).orElse(new RelationshipResponse(FriendRequestState.ERROR_HANDLED, "An unknown error occurred")));
        });
        return future2;
    }

    public void removeRelationship(@NotNull Relationship relationship) {
        UUID ourUUID = this.connectionManager.getMinecraftHook().getPlayerUUID();
        boolean areWeTheSender = relationship.getSenderUUID().equals(ourUUID);
        UUID targetUUID = areWeTheSender ? relationship.getTargetUUID() : relationship.getSenderUUID();
        switch (relationship.getType()) {
            case FRIENDS: {
                if (relationship.isPending()) {
                    if (areWeTheSender) {
                        this.outgoingFriendRequests.remove(targetUUID);
                        break;
                    }
                    this.incomingFriendRequests.remove(targetUUID);
                    break;
                }
                this.friends.remove(targetUUID);
                break;
            }
            case BLOCKED: {
                if (areWeTheSender) {
                    this.blockedByMe.remove(targetUUID);
                    break;
                }
                this.blockedMe.remove(targetUUID);
            }
        }
        Multithreading.runAsync(this.connectionManager.getSpsManager()::refreshWhitelist);
    }

    public CompletableFuture<RelationshipResponse> deleteRelationship(@NotNull UUID targetUUID, @NotNull RelationshipType type) {
        CompletableFuture<RelationshipResponse> future2 = new CompletableFuture<RelationshipResponse>();
        this.connectionManager.send(new RelationshipDeletePacket(targetUUID, type), responseOptional -> {
            if (!responseOptional.isPresent()) {
                ExtensionsKt.error(Notifications.INSTANCE, "Error", "A timeout occurred please try again.");
                future2.complete(new RelationshipResponse(FriendRequestState.ERROR_HANDLED));
                return;
            }
            Packet responsePacket = (Packet)responseOptional.get();
            if (!(responsePacket instanceof ResponseActionPacket)) {
                if (responsePacket instanceof ServerRelationshipCreateFailedResponsePacket) {
                    String reason2 = ((ServerRelationshipCreateFailedResponsePacket)responsePacket).getReason();
                    RelationshipErrorResponse relationshipErrorResponse = RelationshipErrorResponse.getResponse(reason2);
                    if (relationshipErrorResponse == null) {
                        Essential.logger.error("Unknown relationshipErrorResponse reason: " + reason2);
                    }
                    RelationshipResponse relationshipResponse = new RelationshipResponse(FriendRequestState.ERROR_HANDLED, relationshipErrorResponse);
                    RelationshipResponseKt.displayToast(relationshipResponse, targetUUID);
                    future2.complete(relationshipResponse);
                } else {
                    future2.complete(new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, "An unknown error occurred. Please contact support if issues persist."));
                }
                return;
            }
            ResponseActionPacket response = (ResponseActionPacket)responsePacket;
            if (!response.isSuccessful()) {
                future2.complete(new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, "An unknown error occurred. Please contact support if issues persist."));
                return;
            }
            this.outgoingFriendRequests.remove(targetUUID);
            this.incomingFriendRequests.remove(targetUUID);
            this.friends.remove(targetUUID);
            this.blockedByMe.remove(targetUUID);
            this.blockedMe.remove(targetUUID);
            future2.complete(new RelationshipResponse(FriendRequestState.SENT));
            Multithreading.runAsync(this.connectionManager.getSpsManager()::refreshWhitelist);
        });
        return future2;
    }

    public CompletableFuture<RelationshipResponse> unblock(@NotNull UUID user) {
        Relationship block = this.blockedByMe.get(user);
        if (block != null) {
            return this.deleteRelationship(user, RelationshipType.BLOCKED);
        }
        return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, "This player is not blocked"));
    }

    public CompletableFuture<RelationshipResponse> removeFriend(@NotNull UUID otherUser) {
        Relationship friendRelationship = this.friends.get(otherUser);
        if (friendRelationship != null) {
            return this.deleteRelationship(otherUser, friendRelationship.getType());
        }
        return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, "You are not friends with this player"));
    }

    public CompletableFuture<RelationshipResponse> acceptFriend(@NotNull UUID user) {
        return this.createFriendRelationship(user, true);
    }

    public CompletableFuture<RelationshipResponse> denyFriend(@NotNull UUID user) {
        Relationship request2 = this.incomingFriendRequests.get(user);
        if (request2 != null) {
            this.removeRelationship(request2);
            return this.deleteRelationship(user, RelationshipType.FRIENDS);
        }
        return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, "You do not have a friend request from this player"));
    }

    public CompletableFuture<RelationshipResponse> cancelFriendRequest(@NotNull UUID user) {
        Relationship request2 = this.outgoingFriendRequests.get(user);
        if (request2 != null) {
            this.removeRelationship(request2);
            return this.deleteRelationship(user, RelationshipType.FRIENDS);
        }
        return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, "You do not have a friend request to this player"));
    }

    public CompletableFuture<RelationshipResponse> addFriend(@NotNull UUID uuid, boolean notification) {
        return this.createFriendRelationship(uuid, false, notification);
    }

    @Override
    public void onConnected() {
        this.resetState();
    }

    @Override
    public void resetState() {
        this.blockedMe.clear();
        this.blockedByMe.clear();
        this.incomingFriendRequests.clear();
        this.outgoingFriendRequests.clear();
        this.friends.clear();
    }
}

