/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.subscription;

import gg.essential.connectionmanager.common.packet.subscription.SubscriptionUpdatePacket;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.SetKt;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.collections.MutableTrackedSet;
import gg.essential.gui.elementa.state.v2.collections.TrackedSet;
import gg.essential.network.CMConnection;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.util.USession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;

public class SubscriptionManager
implements NetworkedManager {
    @NotNull
    private final PacketQueue packetQueue;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final MutableState<MutableTrackedSet<UUID>> subscriptions = SetKt.mutableSetState(new UUID[0]);
    private final State<TrackedSet<UUID>> subscriptionsAndSelf = SetKt.toSetState(observer -> {
        LinkedHashSet<UUID> combined = new LinkedHashSet<UUID>();
        combined.add(USession.Companion.getActive().get(observer).getUuid());
        combined.addAll((Collection)this.subscriptions.get(observer));
        return combined;
    });

    public SubscriptionManager(@NotNull CMConnection cmConnection) {
        this.packetQueue = new SequentialPacketQueue.Builder(cmConnection).onTimeoutRetransmit().create();
    }

    public boolean isSubscribedOrSelf(@NotNull UUID uuid) {
        return this.isSubscribed(uuid) || uuid.equals(USession.Companion.activeNow().getUuid());
    }

    public boolean isSubscribed(@NotNull UUID uuid) {
        return ((MutableTrackedSet)this.subscriptions.getUntracked()).contains(uuid);
    }

    public State<TrackedSet<UUID>> getSubscriptionsAndSelf() {
        return this.subscriptionsAndSelf;
    }

    public void subscribeToFeeds(@NotNull Set<UUID> uuids) {
        UUID ownUuid = USession.Companion.activeNow().getUuid();
        if (uuids.contains(ownUuid)) {
            this.subscribeToFeeds(SetsKt.minus(uuids, (Object)ownUuid));
            return;
        }
        SetKt.addAll(this.subscriptions, uuids);
        this.packetQueue.enqueue(new SubscriptionUpdatePacket(uuids.toArray(new UUID[0]), true), response -> {
            for (Listener listener2 : this.listeners) {
                listener2.onSubscriptionAdded(uuids);
            }
        });
    }

    public void unSubscribeFromFeeds(@NotNull Set<UUID> uuids) {
        UUID ownUuid = USession.Companion.activeNow().getUuid();
        if (uuids.contains(ownUuid)) {
            this.unSubscribeFromFeeds(SetsKt.minus(uuids, (Object)ownUuid));
            return;
        }
        SetKt.removeAll(this.subscriptions, uuids);
        this.packetQueue.enqueue(new SubscriptionUpdatePacket(uuids.toArray(new UUID[0]), false), response -> {
            for (Listener listener2 : this.listeners) {
                listener2.onSubscriptionRemoved(uuids);
            }
        });
    }

    @Override
    public void onConnected() {
        this.packetQueue.reset();
        Set uuids = (Set)this.subscriptions.getUntracked();
        this.resetState();
        this.subscribeToFeeds(uuids);
    }

    @Override
    public void resetState() {
        Set uuids = (Set)this.subscriptions.getUntracked();
        SetKt.clear(this.subscriptions);
        for (Listener listener2 : this.listeners) {
            listener2.onSubscriptionRemoved(uuids);
        }
    }

    public void addListener(@NotNull Listener listener2) {
        this.listeners.add(listener2);
    }

    public static interface Listener {
        default public void onSubscriptionAdded(@NotNull Set<UUID> uuids) {
        }

        default public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
        }
    }
}

