/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.sps;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgg/essential/sps/TPSSessionMonitor;", "", "()V", "allSession", "Lgg/essential/sps/TPSSessionMonitor$Session;", "maxTPS", "", "minTPS", "windowedSession", "getAverageTPS", "getMaxTPS", "getMinTPS", "tick", "", "Session", "essential-gui-essential"})
public final class TPSSessionMonitor {
    @NotNull
    private final Session allSession = new Session();
    @NotNull
    private final Session windowedSession = new Session();
    private float minTPS = Float.MAX_VALUE;
    private float maxTPS;

    public final void tick() {
        long now2 = System.nanoTime();
        this.allSession.tick(now2);
        this.windowedSession.tick(now2);
        if (this.windowedSession.getTickCount() >= 100L) {
            float windowedTPS = this.windowedSession.getAverageTPS();
            this.minTPS = Math.min(this.minTPS, windowedTPS);
            this.maxTPS = Math.max(this.maxTPS, windowedTPS);
            this.windowedSession.reset();
        }
    }

    public final float getAverageTPS() {
        return this.allSession.getAverageTPS();
    }

    public final float getMinTPS() {
        if (this.minTPS == Float.MAX_VALUE) {
            return this.getAverageTPS();
        }
        return this.minTPS;
    }

    public final float getMaxTPS() {
        if (this.maxTPS == 0.0f) {
            return this.getAverageTPS();
        }
        return this.maxTPS;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lgg/essential/sps/TPSSessionMonitor$Session;", "", "()V", "firstTickTime", "", "lastTickTime", "tickCount", "getTickCount", "()J", "setTickCount", "(J)V", "getAverageTPS", "", "reset", "", "tick", "now", "essential-gui-essential"})
    public static final class Session {
        private long tickCount;
        private long firstTickTime;
        private long lastTickTime;

        public Session() {
            this.reset();
        }

        public final long getTickCount() {
            return this.tickCount;
        }

        public final void setTickCount(long l) {
            this.tickCount = l;
        }

        public final void tick(long now2) {
            if (this.firstTickTime == 0L) {
                this.firstTickTime = now2;
                this.lastTickTime = now2;
                return;
            }
            this.lastTickTime = now2;
            long l = this.tickCount;
            this.tickCount = l + 1L;
        }

        public final float getAverageTPS() {
            long totalTime = this.lastTickTime - this.firstTickTime;
            if (totalTime == 0L || this.tickCount == 0L) {
                return 0.0f;
            }
            double averageTimePerTick = totalTime / this.tickCount;
            return (float)(1.0E9 / averageTimePerTick);
        }

        public final void reset() {
            this.tickCount = 0L;
            this.firstTickTime = 0L;
            this.lastTickTime = 0L;
        }
    }
}

