/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.Essential;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import net.fabricmc.loader.api.FabricLoader;

public class EssentialContainerUtil {
    public static boolean isContainerPresent() {
        return FabricLoader.getInstance().isModLoaded("essential-container");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateStage1IfOutdated(Path gameDir) throws Exception {
        int bundledVersion;
        String variant = "fabric";
        Path dataDir = gameDir.resolve("essential").resolve("loader").resolve("stage0").resolve(variant);
        Path updatePath = dataDir.resolve("stage1.update.jar");
        Path activePath = dataDir.resolve("stage1.jar");
        URL activeUrl = activePath.toUri().toURL();
        URL bundledUrl = Essential.class.getResource("loader-stage1.jar");
        if (bundledUrl == null) {
            throw new RuntimeException("Failed to retrieve bundled stage1 jar.");
        }
        int activeVersion = EssentialContainerUtil.getStage1Version(activeUrl);
        if (activeVersion >= (bundledVersion = EssentialContainerUtil.getStage1Version(bundledUrl))) {
            Essential.logger.debug("Stage1 appears to be up-to-date. Bundled update would be {}, active is {}.", (Object)bundledVersion, (Object)activeVersion);
            return;
        }
        Essential.logger.info("Updating stage1 jar from version {} to bundled version {}.", (Object)activeVersion, (Object)bundledVersion);
        Files.deleteIfExists(updatePath);
        Path tmpPath = Files.createTempFile(updatePath.getParent(), "update", ".jar", new FileAttribute[0]);
        try {
            try (InputStream in = bundledUrl.openStream();){
                Files.copy(in, tmpPath, StandardCopyOption.REPLACE_EXISTING);
            }
            Files.move(tmpPath, updatePath, new CopyOption[0]);
        }
        finally {
            Files.deleteIfExists(tmpPath);
        }
    }

    private static int getStage1Version(URL file) throws IOException {
        try (JarInputStream in = new JarInputStream(file.openStream(), false);){
            Manifest manifest = in.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            int n = Integer.parseInt(attributes.getValue("Implementation-Version"));
            return n;
        }
    }
}

