/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.api.utils.mojang.Model;
import gg.essential.api.utils.mojang.Name;
import gg.essential.api.utils.mojang.Profile;
import gg.essential.api.utils.mojang.Property;
import gg.essential.api.utils.mojang.SkinResponse;
import gg.essential.mod.Skin;
import gg.essential.network.mojang.MojangProfileApi;
import gg.essential.network.mojang.MojangProfileLookupApi;
import gg.essential.util.ModelKt;
import gg.essential.util.UuidNameLookup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\tH\u0016J \u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001b\u001a\u00020\u0007*\u00020\u001cH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgg/essential/util/MojangAPI;", "Lgg/essential/api/utils/mojang/MojangAPI;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "changeSkin", "Lgg/essential/api/utils/mojang/SkinResponse;", "accessToken", "", "uuid", "Ljava/util/UUID;", "model", "Lgg/essential/api/utils/mojang/Model;", "url", "getName", "Ljava/util/concurrent/CompletableFuture;", "getNameHistory", "", "Lgg/essential/api/utils/mojang/Name;", "getProfile", "Lgg/essential/api/utils/mojang/Profile;", "getUUID", "name", "uploadSkin", "file", "Ljava/io/File;", "toSkinResponse", "Lgg/essential/network/mojang/MojangProfileApi$Profile;", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nMojangAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MojangAPI.kt\ngg/essential/util/MojangAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n1549#2:84\n1620#2,3:85\n1549#2:88\n1620#2,3:89\n*S KotlinDebug\n*F\n+ 1 MojangAPI.kt\ngg/essential/util/MojangAPI\n*L\n44#1:80\n44#1:81,3\n72#1:84\n72#1:85,3\n75#1:88\n75#1:89,3\n*E\n"})
public final class MojangAPI
implements gg.essential.api.utils.mojang.MojangAPI {
    @NotNull
    public static final MojangAPI INSTANCE = new MojangAPI();
    private static final Logger LOGGER = LoggerFactory.getLogger(gg.essential.api.utils.mojang.MojangAPI.class);

    private MojangAPI() {
    }

    @Override
    @Nullable
    public CompletableFuture<UUID> getUUID(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return UuidNameLookup.getUUID(name2);
    }

    @Override
    @Nullable
    public CompletableFuture<String> getName(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return UuidNameLookup.getName(uuid);
    }

    @Override
    @Deprecated(message="Name history has been removed from the Mojang API")
    @Nullable
    public List<Name> getNameHistory(@Nullable UUID uuid) {
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Profile getProfile(@NotNull UUID uuid) {
        Collection<Property> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        MojangProfileLookupApi.Profile profile2 = MojangProfileLookupApi.INSTANCE.fetchBlocking(uuid);
        if (profile2 == null) {
            return null;
        }
        MojangProfileLookupApi.Profile profile3 = profile2;
        String string = profile3.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Iterable iterable = profile3.getProperties();
        String string2 = profile3.getName();
        String string3 = StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MojangProfileLookupApi.Property property2 = (MojangProfileLookupApi.Property)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Property(it.getName(), it.getValue()));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        String string4 = string2;
        String string5 = string3;
        return new Profile(string5, string4, list);
    }

    @Override
    @Nullable
    public SkinResponse changeSkin(@NotNull String accessToken, @NotNull UUID uuid, @NotNull Model model, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            MojangProfileApi api = new MojangProfileApi(accessToken);
            return (SkinResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SkinResponse>, Object>(api, url, model, null){
                Object L$0;
                int label;
                final /* synthetic */ MojangProfileApi $api;
                final /* synthetic */ String $url;
                final /* synthetic */ Model $model;
                {
                    this.$api = $api;
                    this.$url = $url;
                    this.$model = $model;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            MojangAPI mojangAPI = MojangAPI.INSTANCE;
                            this.L$0 = mojangAPI;
                            this.label = 1;
                            Object object3 = this.$api.putSkin(Skin.Companion.fromUrl(this.$url, ModelKt.toModModel(this.$model)), (Continuation<? super MojangProfileApi.Profile>)((Continuation)this));
                            if (object3 != object2) return MojangAPI.access$toSkinResponse(mojangAPI, (MojangProfileApi.Profile)object3);
                            return object2;
                        }
                        case 1: {
                            void $result;
                            MojangAPI mojangAPI = (MojangAPI)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return MojangAPI.access$toSkinResponse(mojangAPI, (MojangProfileApi.Profile)object3);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super SkinResponse> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while updating skin", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final SkinResponse uploadSkin(@NotNull String accessToken, @NotNull Model model, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            MojangProfileApi api = new MojangProfileApi(accessToken);
            return (SkinResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SkinResponse>, Object>(api, file, model, null){
                Object L$0;
                int label;
                final /* synthetic */ MojangProfileApi $api;
                final /* synthetic */ File $file;
                final /* synthetic */ Model $model;
                {
                    this.$api = $api;
                    this.$file = $file;
                    this.$model = $model;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            MojangAPI mojangAPI = MojangAPI.INSTANCE;
                            this.L$0 = mojangAPI;
                            this.label = 1;
                            Object object3 = this.$api.putSkin(FilesKt.readBytes((File)this.$file), ModelKt.toModModel(this.$model), (Continuation<? super MojangProfileApi.Profile>)((Continuation)this));
                            if (object3 != object2) return MojangAPI.access$toSkinResponse(mojangAPI, (MojangProfileApi.Profile)object3);
                            return object2;
                        }
                        case 1: {
                            void $result;
                            MojangAPI mojangAPI = (MojangAPI)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return MojangAPI.access$toSkinResponse(mojangAPI, (MojangProfileApi.Profile)object3);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super SkinResponse> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while uploading a skin to Mojang", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SkinResponse toSkinResponse(MojangProfileApi.Profile $this$toSkinResponse) {
        Collection<gg.essential.api.utils.mojang.Skin> collection;
        MojangProfileApi.Cape skin2;
        Collection<gg.essential.api.utils.mojang.Skin> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String string = $this$toSkinResponse.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Iterable iterable = $this$toSkinResponse.getSkins();
        String string2 = $this$toSkinResponse.getName();
        String string3 = StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MojangProfileApi.Skin skin3 = (MojangProfileApi.Skin)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new gg.essential.api.utils.mojang.Skin(((MojangProfileApi.Skin)((Object)skin2)).getId(), ((MojangProfileApi.Skin)((Object)skin2)).getActive() ? "ACTIVE" : "INACTIVE", ((MojangProfileApi.Skin)((Object)skin2)).getUrl(), ((MojangProfileApi.Skin)((Object)skin2)).getVariant().getVariant()));
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = $this$toSkinResponse.getCapes();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cape;
            skin2 = (MojangProfileApi.Cape)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new gg.essential.api.utils.mojang.Skin(cape.getId(), cape.getActive() ? "ACTIVE" : "INACTIVE", cape.getUrl(), "N/A"));
        }
        Collection<gg.essential.api.utils.mojang.Skin> collection3 = collection = (List)destination$iv$iv;
        Collection<gg.essential.api.utils.mojang.Skin> collection4 = collection2;
        String string4 = string2;
        String string5 = string3;
        return new SkinResponse(string5, string4, (List<gg.essential.api.utils.mojang.Skin>)collection4, (List<gg.essential.api.utils.mojang.Skin>)collection3);
    }

    public static final /* synthetic */ SkinResponse access$toSkinResponse(MojangAPI $this, MojangProfileApi.Profile $receiver) {
        return $this.toSkinResponse($receiver);
    }
}

