/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.relationships.ClientLookupUuidByNamePacket;
import gg.essential.connectionmanager.common.packet.relationships.ServerLookupUuidByNameResponsePacket;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.gui.common.ReadOnlyState;
import gg.essential.network.CMConnection;
import gg.essential.network.mojang.MojangNameToUuidApi;
import gg.essential.network.mojang.MojangProfileLookupApi;
import gg.essential.util.DispatchersKt;
import gg.essential.util.EssentialGuiExtensionsKt;
import gg.essential.util.GuiEssentialPlatform;
import gg.essential.util.PlayerNotFoundException;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;

public class UuidNameLookup {
    private static final ConcurrentHashMap<UUID, CompletableFuture<String>> uuidLoadingFutures = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, CompletableFuture<UUID>> nameLoadingFutures = new ConcurrentHashMap();

    public static CompletableFuture<String> getName(UUID uuid) {
        return uuidLoadingFutures.computeIfAbsent(uuid, ignored1 -> CompletableFuture.supplyAsync(() -> {
            try {
                MojangProfileLookupApi.Profile profile2 = MojangProfileLookupApi.INSTANCE.fetchBlocking(uuid);
                if (profile2 == null) {
                    throw new PlayerNotFoundException("Player not found");
                }
                nameLoadingFutures.put(profile2.getName().toLowerCase(Locale.ROOT), CompletableFuture.completedFuture(uuid));
                return profile2.getName();
            }
            catch (Exception e) {
                uuidLoadingFutures.remove(uuid);
                throw new CompletionException("Failed to load name", e);
            }
        }, ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO())));
    }

    public static CompletableFuture<UUID> getUUID(String userName) {
        return nameLoadingFutures.computeIfAbsent(userName.toLowerCase(Locale.ROOT), nameLower -> {
            CompletableFuture future2 = new CompletableFuture();
            CMConnection cmConnection = GuiEssentialPlatform.Companion.getPlatform().getCmConnection();
            cmConnection.send(new ClientLookupUuidByNamePacket((String)nameLower), maybeResponse -> {
                Packet response = maybeResponse.orElse(null);
                if (response instanceof ServerLookupUuidByNameResponsePacket) {
                    ServerLookupUuidByNameResponsePacket p = (ServerLookupUuidByNameResponsePacket)response;
                    uuidLoadingFutures.put(p.getUuid(), CompletableFuture.completedFuture(p.getUsername()));
                    future2.complete(p.getUuid());
                } else {
                    Dispatchers.getIO().dispatch((CoroutineContext)EmptyCoroutineContext.INSTANCE, () -> {
                        try {
                            MojangNameToUuidApi.Profile profile2 = MojangNameToUuidApi.INSTANCE.fetchBlocking((String)nameLower);
                            if (profile2 == null) {
                                throw new PlayerNotFoundException("Player not found");
                            }
                            UUID loadedUuid = profile2.getId();
                            uuidLoadingFutures.put(loadedUuid, CompletableFuture.completedFuture(profile2.getName()));
                            future2.complete(loadedUuid);
                        }
                        catch (Exception e) {
                            nameLoadingFutures.remove(nameLower);
                            future2.completeExceptionally(new CompletionException("Failed to load UUID", e));
                        }
                    });
                }
            });
            return future2;
        });
    }

    public static void populate(String username, UUID uuid) {
        uuidLoadingFutures.computeIfAbsent(uuid, k -> new CompletableFuture()).complete(username);
        nameLoadingFutures.computeIfAbsent(username.toLowerCase(Locale.ROOT), k -> new CompletableFuture()).complete(uuid);
    }

    @Deprecated
    public static ReadOnlyState<String> getNameAsState(UUID uuid) {
        return UuidNameLookup.getNameAsState(uuid, "");
    }

    @Deprecated
    public static ReadOnlyState<String> getNameAsState(UUID uuid, String initialValue) {
        BasicState state2 = new BasicState((Object)initialValue);
        UuidNameLookup.getName(uuid).thenAcceptAsync(arg_0 -> ((BasicState)state2).set(arg_0), ExecutorsKt.asExecutor((CoroutineDispatcher)DispatchersKt.getClient(Dispatchers.INSTANCE)));
        return new ReadOnlyState<String>((State<String>)state2);
    }

    public static gg.essential.gui.elementa.state.v2.State<String> nameState(UUID uuid) {
        return UuidNameLookup.nameState(uuid, "");
    }

    public static gg.essential.gui.elementa.state.v2.State<String> nameState(UUID uuid, String initialValue) {
        gg.essential.gui.elementa.state.v2.State<String> nullableState = EssentialGuiExtensionsKt.toState(UuidNameLookup.getName(uuid));
        return observer -> {
            String value = (String)nullableState.get(observer);
            if (value == null) {
                value = initialValue;
            }
            return value;
        };
    }
}

